% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-.R
\name{rvar_ifelse}
\alias{rvar_ifelse}
\title{Random variable ifelse}
\usage{
rvar_ifelse(test, yes, no)
}
\arguments{
\item{test}{(logical \code{\link{rvar}}, or castable to one) logical test determining
whether the value in \code{yes} or \code{no} is assigned in the corresponding position
of the result.}

\item{yes}{(\code{\link{rvar}}, or castable to one) corresponding values assigned for
entries in \code{test} that are \code{TRUE}.}

\item{no}{(\code{\link{rvar}}, or castable to one) corresponding values assigned for
entries in \code{test} that are \code{FALSE}.}
}
\value{
An \code{\link{rvar}} with the common type of \code{yes} and \code{no} (as determined by
\code{vctrs::vec_cast_common()}) and a shape determined by broadcasting \code{test},
\code{yes}, and \code{no} to a common shape (see the section on broadcasting rules in
\code{vignette("rvar")}). For every element of \code{draws_of(test)}, the corresponding
element of \code{draws_of(yes)} or \code{draws_of(no)} is placed into the result,
depending on whether the element of \code{test} is \code{TRUE} or \code{FALSE}.
}
\description{
A version of \code{ifelse()} that returns an \code{\link{rvar}}.
}
\examples{
x <- rvar(1:4)
y <- rvar(5:8)

i <- rvar(c(TRUE,FALSE,TRUE,FALSE))
z <- rvar_ifelse(i, x, y)
z
draws_of(z)
}
