% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose}
\alias{compose}
\title{Compose multiple functions}
\usage{
compose(..., .dir = c("backward", "forward"))
}
\arguments{
\item{...}{Functions to apply in order (from right to left by
default). Formulas are converted to functions in the usual way.

These dots support \link[rlang:list2]{tidy dots} features. In
particular, if your functions are stored in a list, you can
splice that in with \verb{!!!}.}

\item{.dir}{If \code{"backward"} (the default), the functions are called
in the reverse order, from right to left, as is conventional in
mathematics. If \code{"forward"}, they are called from left to right.}
}
\value{
A function
}
\description{
Compose multiple functions
}
\examples{
not_null <- compose(`!`, is.null)
not_null(4)
not_null(NULL)

add1 <- function(x) x + 1
compose(add1, add1)(8)

# You can use the formula shortcut for functions:
fn <- compose(~ paste(.x, "foo"), ~ paste(.x, "bar"))
fn("input")

# Lists of functions can be spliced with !!!
fns <- list(
  function(x) paste(x, "foo"),
  ~ paste(.x, "bar")
)
fn <- compose(!!!fns)
fn("input")
}
