% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sumScoreEAP}
\alias{sumScoreEAP}
\title{Compute the sum-score EAP table}
\usage{
sumScoreEAP(grp, ..., qwidth = 6, qpoints = 49L, .twotier = TRUE)
}
\arguments{
\item{grp}{a list containing the model and data. See the details section.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{qwidth}{DEPRECATED}

\item{qpoints}{DEPRECATED}

\item{.twotier}{whether to enable the two-tier optimization}
}
\description{
Observed tables cannot be computed when data is
missing. Therefore, you can optionally omit items with the
greatest number of responses missing when conducting the
distribution test.
}
\details{
When two-tier covariance structure is detected, EAP scores are
only reported for primary factors. It is possible to compute EAP
scores for specific factors, but it is not clear why this would be
useful because they are conditional on the specific factor sum
scores. Moveover, the algorithm to compute them efficiently has not been
published yet (as of Jun 2014).
}
\section{Format of a group}{


A model, or group within a model, is represented as a named list.
\describe{
\item{spec}{list of response model objects}
\item{param}{numeric matrix of item parameters}
\item{free}{logical matrix of indicating which parameters are free (TRUE) or fixed (FALSE)}
\item{mean}{numeric vector giving the mean of the latent distribution}
\item{cov}{numeric matrix giving the covariance of the latent distribution}
\item{data}{data.frame containing observed item responses, and optionally,
weights and frequencies}
\item{score}{factors scores with response patterns in rows}
\item{weightColumn}{name of the data column containing the numeric row weights (optional)}
\item{freqColumn}{name of the data column containing the integral row frequencies (optional)}
\item{qwidth}{width of the quadrature expressed in Z units}
\item{qpoints}{number of quadrature points}
\item{minItemsPerScore}{minimum number of non-missing items when estimating factor scores}
}

The \code{param} matrix stores items parameters by column. If a
column has more rows than are required to fully specify a model
then the extra rows are ignored.  The order of the items in
\code{spec} and order of columns in \code{param} are assumed to
match. All items should have the same number of latent dimensions.
Loadings on latent dimensions are given in the first few rows and
can be named by setting rownames. Item names are assigned by
\code{param} colnames.

Currently only a multivariate normal distribution is available,
parameterized by the \code{mean} and \code{cov}. If \code{mean} and
\code{cov} are not specified then a standard normal distribution is
assumed. The quadrature consists of equally spaced points. For
example, \code{qwidth=2} and \code{qpoints=5} would produce points
-2, -1, 0, 1, and 2. The quadrature specification is part of the
group and not passed as extra arguments for the sake of
consistency. As currently implemented, OpenMx uses EAP scores to
estimate latent distribution parameters. By default, the exact same
EAP scores should be produced by \link{EAPscores}.
}

\examples{
# see Thissen, Pommerich, Billeaud, & Williams (1995, Table 2)
 spec <- list()
 spec[1:3] <- list(rpf.grm(outcomes=4))

 param <- matrix(c(1.87, .65, 1.97, 3.14,
                   2.66, .12, 1.57, 2.69,
                   1.24, .08, 2.03, 4.3), nrow=4)
 # fix parameterization
 param <- apply(param, 2, function(p) c(p[1], p[2:4] * -p[1]))

 grp <- list(spec=spec, mean=0, cov=matrix(1,1,1), param=param)
 sumScoreEAP(grp)
}
\seealso{
Other scoring: 
\code{\link{EAPscores}()},
\code{\link{bestToOmit}()},
\code{\link{itemOutcomeBySumScore}()},
\code{\link{observedSumScore}()},
\code{\link{omitItems}()},
\code{\link{omitMostMissing}()}
}
\concept{scoring}
