% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_nest_by}
\alias{df_nest_by}
\title{Nest a Tibble By Groups}
\usage{
df_nest_by(data, ..., vars = NULL)
}
\arguments{
\item{data}{a data frame}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used as grouping variables.}

\item{vars}{a character vector containing the grouping variables of interest.}
}
\value{
A tbl with one row per unique combination of the grouping variables.
  The first columns are the grouping variables, followed by a list column of
  tibbles with matching rows of the remaining columns.
}
\description{
Nest a tibble data frame using grouping specification. Supports standard and non standard evaluation.
}
\examples{

# Non standard evaluation
ToothGrowth \%>\%
 df_nest_by(dose, supp)

# Standard evaluation
ToothGrowth \%>\%
 df_nest_by(vars = c("dose", "supp"))

}
