% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot-file.R
\name{expect_snapshot_file}
\alias{expect_snapshot_file}
\title{Snapshot testing for whole files}
\usage{
expect_snapshot_file(path, name = basename(path), binary = TRUE, cran = FALSE)
}
\arguments{
\item{path}{Path to file to snapshot.}

\item{name}{Snapshot name, taken from \code{path} by default.}

\item{binary}{If \code{FALSE}, files are compared line-by-line, ignoring the
difference between Windows and Mac/Linux line endings.}

\item{cran}{Should these expectations be verified on CRAN? By default,
they are not, because snapshot tests tend to be fragile because they
often rely on minor details of dependencies.}
}
\description{
Whole file snapshot testing is designed for testing objects that don't have
a convenient textual representation, with initial support for images
(\code{.png}, \code{.jpg}, \code{.svg}), data frames (\code{.csv}), and text files
(\code{.R}, \code{.txt}, \code{.json}, ...).

The first time \code{expect_snapshot_file()} is run, it will create
\verb{_snaps/\{test\}/\{name\}.\{ext\}} containing reference output. Future runs will
be compared to this reference: if different, the test will fail and the new
results will be saved in \verb{_snaps/\{test\}/\{name\}.new.\{ext\}}. To review
failures, call \code{\link[=snapshot_review]{snapshot_review()}}.

We generally expect this function to be used via a wrapper that takes care
of ensuring that output is as reproducible as possible, e.g. automatically
skipping tests where it's known that images can't be reproduced exactly.
}
\examples{

# To use expect_snapshot_file() you'll typically need to start by writing
# a helper function that creates a file from your code, returning a path
save_png <- function(code, width = 400, height = 400) {
  path <- tempfile(fileext = ".png")
  png(path, width = width, height = height)
  on.exit(dev.off())
  code

  path
}
path <- save_png(plot(1:5))
path

\dontrun{
expect_snapshot_file(save_png(hist(mtcars$mpg)), "plot.png")
}

# You'd then also provide a helper that skips tests where you can't
# be sure of producing exactly the same output
expect_snapshot_plot <- function(name, code) {
  # Other packages might affect results
  skip_if_not_installed("ggplot2", "2.0.0")
  # Or maybe the output is different on some operation systems
  skip_on_os("windows")
  # You'll need to carefully think about and experiment with these skips

  path <- save_png(code)
  expect_snapshot_file(path, paste0(name, ".png"))
}
}
