% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_matcher_registry.R
\name{RequestMatcherRegistry}
\alias{RequestMatcherRegistry}
\title{RequestMatcherRegistry}
\description{
handles request matchers
}
\note{
r1=from new request; r2=from recorded interaction
}
\examples{
\dontrun{
(x <- RequestMatcherRegistry$new())
x$default_matchers
x$registry
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{registry}}{initialze registry list with a request, or leave empty}

\item{\code{default_matchers}}{request matchers to use. default: method, uri}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RequestMatcherRegistry$new()}}
\item \href{#method-register}{\code{RequestMatcherRegistry$register()}}
\item \href{#method-register_built_ins}{\code{RequestMatcherRegistry$register_built_ins()}}
\item \href{#method-try_to_register_body_as_json}{\code{RequestMatcherRegistry$try_to_register_body_as_json()}}
\item \href{#method-clone}{\code{RequestMatcherRegistry$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new RequestMatcherRegistry object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestMatcherRegistry$new(
  registry = list(),
  default_matchers = list("method", "uri")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{registry}}{initialze registry list with a request, or leave empty}

\item{\code{default_matchers}}{request matchers to use. default: method, uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RequestMatcherRegistry} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-register"></a>}}
\if{latex}{\out{\hypertarget{method-register}{}}}
\subsection{Method \code{register()}}{
Register a custom matcher
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestMatcherRegistry$register(name, func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{matcher name}

\item{\code{func}}{function that describes a matcher, should return
a single boolean}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; registers the matcher
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-register_built_ins"></a>}}
\if{latex}{\out{\hypertarget{method-register_built_ins}{}}}
\subsection{Method \code{register_built_ins()}}{
Register all built in matchers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestMatcherRegistry$register_built_ins()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
no return; registers all built in matchers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-try_to_register_body_as_json"></a>}}
\if{latex}{\out{\hypertarget{method-try_to_register_body_as_json}{}}}
\subsection{Method \code{try_to_register_body_as_json()}}{
Try to register body as JSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestMatcherRegistry$try_to_register_body_as_json(r1, r2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{r1, r2}}{\link{Request} class objects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; registers the matcher
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestMatcherRegistry$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
