% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeBasedRange.R, R/timeBasedSeq.R
\name{timeBasedRange}
\alias{timeBasedRange}
\alias{timeBasedSeq}
\title{Create a Sequence or Range of Times}
\usage{
timeBasedRange(x, ...)

timeBasedSeq(x, retclass = NULL, length.out = NULL)
}
\arguments{
\item{x}{An ISO-8601 time-date range string.}

\item{\dots}{Unused.}

\item{retclass}{The return class desired.}

\item{length.out}{Passed to \code{seq()} internally.}
}
\value{
\code{timeBasedSeq()} returns a vector of time-based observations.
\code{timeBasedRange()} returns a one or two element numeric vector representing
the start and end number of seconds since epoch (1970-01-01).

When \code{retclass = NULL}, the result of \code{timeBasedSeq()} is a named list
containing elements "from", "to", "by" and "length.out".
}
\description{
A function to create a vector of time-based objects suitable for indexing an
xts object, given a string conforming to the ISO-8601 time and date standard
for range-based specification. The resulting series can be of any class
supported by xts, including POSIXct, Date, chron, timeDate, yearmon, and
yearqtr.
}
\details{
\code{timeBasedRange()} creates a one or two element numeric vector representing
the start and end number of seconds since epoch (1970-01-01). For internal
use.

\code{timeBasedSeq()} creates sequences of time-based observations using strings
formatted according to the ISO-8601 specification. The general format is
\emph{from/to/by} or \emph{from::to::by}, where \emph{to} and \emph{by} are optional when the
'length.out' argument is specified.

The \emph{from} and \emph{to} elements of the string must be left-specified with
respect to the standard \emph{CCYYMMDD HHMMSS} form. All dates/times specified
will be set to either the earliest point (from) or the latest (to), to the
given the level of specificity. For example, \sQuote{1999} in the \emph{from}
field would set the start to the beginning of 1999. \sQuote{1999} in the
\emph{to} field would set the end to the end of 1999.

The amount of resolution in the result is determined by the resolution of
the \emph{from} and \emph{to} component, unless the optional \emph{by} component is
specified.

For example, \code{timeBasedSeq("1999/2008")} returns a vector of Dates for
January 1st of each year. \code{timeBasedSeq("199501/1996")} returns a yearmon
vector of 24 months in 1995 and 1996. And \code{timeBasedSeq("19950101/1996")}
creates a Date vector for all the days in those two years.

The optional \emph{by} field (the third delimited element to the string), will
the resolution heuristic described above and will use the specified \emph{by}
resolution. The possible values for \emph{by} are: 'Y' (years), 'm' (months),
'd' (days), 'H' (hours), 'M' (minutes), 'S' (seconds). Sub-second
resolutions are not supported.
}
\examples{

timeBasedSeq('1999/2008')
timeBasedSeq('199901/2008')
timeBasedSeq('199901/2008/d')
timeBasedSeq('20080101 0830',length=100) # 100 minutes
timeBasedSeq('20080101 083000',length=100) # 100 seconds

}
\references{
International Organization for Standardization: ISO 8601
\url{https://www.iso.org}
}
\seealso{
\code{\link[=timeBased]{timeBased()}}, \code{\link[=xts]{xts()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
