# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Security.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.security


# enumeration
class IpfwPolicy(Enumeration):
    idlType = "security.IpfwPolicy:1.0.0"
    values = ["ACCEPT", "DROP", "REJECT"]

IpfwPolicy.ACCEPT = IpfwPolicy(0)
IpfwPolicy.DROP = IpfwPolicy(1)
IpfwPolicy.REJECT = IpfwPolicy(2)

# structure
class IpfwRule(Structure):
    idlType = "security.IpfwRule:1.0.0"
    elements = ["ipMask", "policy"]

    def __init__(self, ipMask, policy):
        typecheck.is_string(ipMask, AssertionError)
        typecheck.is_enum(policy, raritan.rpc.security.IpfwPolicy, AssertionError)

        self.ipMask = ipMask
        self.policy = policy

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            ipMask = json['ipMask'],
            policy = raritan.rpc.security.IpfwPolicy.decode(json['policy']),
        )
        return obj

    def encode(self):
        json = {}
        json['ipMask'] = self.ipMask
        json['policy'] = raritan.rpc.security.IpfwPolicy.encode(self.policy)
        return json

# structure
class IpFw(Structure):
    idlType = "security.IpFw:2.0.0"
    elements = ["enabled", "defaultPolicyIn", "defaultPolicyOut", "ruleSetIn", "ruleSetOut"]

    def __init__(self, enabled, defaultPolicyIn, defaultPolicyOut, ruleSetIn, ruleSetOut):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(defaultPolicyIn, raritan.rpc.security.IpfwPolicy, AssertionError)
        typecheck.is_enum(defaultPolicyOut, raritan.rpc.security.IpfwPolicy, AssertionError)
        for x0 in ruleSetIn:
            typecheck.is_struct(x0, raritan.rpc.security.IpfwRule, AssertionError)
        for x0 in ruleSetOut:
            typecheck.is_struct(x0, raritan.rpc.security.IpfwRule, AssertionError)

        self.enabled = enabled
        self.defaultPolicyIn = defaultPolicyIn
        self.defaultPolicyOut = defaultPolicyOut
        self.ruleSetIn = ruleSetIn
        self.ruleSetOut = ruleSetOut

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            defaultPolicyIn = raritan.rpc.security.IpfwPolicy.decode(json['defaultPolicyIn']),
            defaultPolicyOut = raritan.rpc.security.IpfwPolicy.decode(json['defaultPolicyOut']),
            ruleSetIn = [raritan.rpc.security.IpfwRule.decode(x0, agent) for x0 in json['ruleSetIn']],
            ruleSetOut = [raritan.rpc.security.IpfwRule.decode(x0, agent) for x0 in json['ruleSetOut']],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['defaultPolicyIn'] = raritan.rpc.security.IpfwPolicy.encode(self.defaultPolicyIn)
        json['defaultPolicyOut'] = raritan.rpc.security.IpfwPolicy.encode(self.defaultPolicyOut)
        json['ruleSetIn'] = [raritan.rpc.security.IpfwRule.encode(x0) for x0 in self.ruleSetIn]
        json['ruleSetOut'] = [raritan.rpc.security.IpfwRule.encode(x0) for x0 in self.ruleSetOut]
        return json

# enumeration
class RoleAccessPolicy(Enumeration):
    idlType = "security.RoleAccessPolicy:1.0.0"
    values = ["ALLOW", "DENY"]

RoleAccessPolicy.ALLOW = RoleAccessPolicy(0)
RoleAccessPolicy.DENY = RoleAccessPolicy(1)

# structure
class RoleAccessRule(Structure):
    idlType = "security.RoleAccessRule:1.0.0"
    elements = ["startIp", "endIp", "roleId", "policy"]

    def __init__(self, startIp, endIp, roleId, policy):
        typecheck.is_string(startIp, AssertionError)
        typecheck.is_string(endIp, AssertionError)
        typecheck.is_int(roleId, AssertionError)
        typecheck.is_enum(policy, raritan.rpc.security.RoleAccessPolicy, AssertionError)

        self.startIp = startIp
        self.endIp = endIp
        self.roleId = roleId
        self.policy = policy

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            startIp = json['startIp'],
            endIp = json['endIp'],
            roleId = json['roleId'],
            policy = raritan.rpc.security.RoleAccessPolicy.decode(json['policy']),
        )
        return obj

    def encode(self):
        json = {}
        json['startIp'] = self.startIp
        json['endIp'] = self.endIp
        json['roleId'] = self.roleId
        json['policy'] = raritan.rpc.security.RoleAccessPolicy.encode(self.policy)
        return json

# structure
class RoleAccessControl(Structure):
    idlType = "security.RoleAccessControl:1.0.0"
    elements = ["enabled", "defaultPolicy", "rules"]

    def __init__(self, enabled, defaultPolicy, rules):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(defaultPolicy, raritan.rpc.security.RoleAccessPolicy, AssertionError)
        for x0 in rules:
            typecheck.is_struct(x0, raritan.rpc.security.RoleAccessRule, AssertionError)

        self.enabled = enabled
        self.defaultPolicy = defaultPolicy
        self.rules = rules

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            defaultPolicy = raritan.rpc.security.RoleAccessPolicy.decode(json['defaultPolicy']),
            rules = [raritan.rpc.security.RoleAccessRule.decode(x0, agent) for x0 in json['rules']],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['defaultPolicy'] = raritan.rpc.security.RoleAccessPolicy.encode(self.defaultPolicy)
        json['rules'] = [raritan.rpc.security.RoleAccessRule.encode(x0) for x0 in self.rules]
        return json

# structure
class BlockSettings(Structure):
    idlType = "security.BlockSettings:1.0.0"
    elements = ["maxFailedLogins", "blockTimeout", "failedLoginTimeout"]

    def __init__(self, maxFailedLogins, blockTimeout, failedLoginTimeout):
        typecheck.is_int(maxFailedLogins, AssertionError)
        typecheck.is_int(blockTimeout, AssertionError)
        typecheck.is_int(failedLoginTimeout, AssertionError)

        self.maxFailedLogins = maxFailedLogins
        self.blockTimeout = blockTimeout
        self.failedLoginTimeout = failedLoginTimeout

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            maxFailedLogins = json['maxFailedLogins'],
            blockTimeout = json['blockTimeout'],
            failedLoginTimeout = json['failedLoginTimeout'],
        )
        return obj

    def encode(self):
        json = {}
        json['maxFailedLogins'] = self.maxFailedLogins
        json['blockTimeout'] = self.blockTimeout
        json['failedLoginTimeout'] = self.failedLoginTimeout
        return json

# structure
class PasswordSettings(Structure):
    idlType = "security.PasswordSettings:1.0.0"
    elements = ["enableAging", "agingInterval", "enableStrongReq", "minPwLength", "maxPwLength", "enforceLower", "enforceUpper", "enforceNumeric", "enforceSpecial", "pwHistoryDepth"]

    def __init__(self, enableAging, agingInterval, enableStrongReq, minPwLength, maxPwLength, enforceLower, enforceUpper, enforceNumeric, enforceSpecial, pwHistoryDepth):
        typecheck.is_bool(enableAging, AssertionError)
        typecheck.is_int(agingInterval, AssertionError)
        typecheck.is_bool(enableStrongReq, AssertionError)
        typecheck.is_int(minPwLength, AssertionError)
        typecheck.is_int(maxPwLength, AssertionError)
        typecheck.is_bool(enforceLower, AssertionError)
        typecheck.is_bool(enforceUpper, AssertionError)
        typecheck.is_bool(enforceNumeric, AssertionError)
        typecheck.is_bool(enforceSpecial, AssertionError)
        typecheck.is_int(pwHistoryDepth, AssertionError)

        self.enableAging = enableAging
        self.agingInterval = agingInterval
        self.enableStrongReq = enableStrongReq
        self.minPwLength = minPwLength
        self.maxPwLength = maxPwLength
        self.enforceLower = enforceLower
        self.enforceUpper = enforceUpper
        self.enforceNumeric = enforceNumeric
        self.enforceSpecial = enforceSpecial
        self.pwHistoryDepth = pwHistoryDepth

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enableAging = json['enableAging'],
            agingInterval = json['agingInterval'],
            enableStrongReq = json['enableStrongReq'],
            minPwLength = json['minPwLength'],
            maxPwLength = json['maxPwLength'],
            enforceLower = json['enforceLower'],
            enforceUpper = json['enforceUpper'],
            enforceNumeric = json['enforceNumeric'],
            enforceSpecial = json['enforceSpecial'],
            pwHistoryDepth = json['pwHistoryDepth'],
        )
        return obj

    def encode(self):
        json = {}
        json['enableAging'] = self.enableAging
        json['agingInterval'] = self.agingInterval
        json['enableStrongReq'] = self.enableStrongReq
        json['minPwLength'] = self.minPwLength
        json['maxPwLength'] = self.maxPwLength
        json['enforceLower'] = self.enforceLower
        json['enforceUpper'] = self.enforceUpper
        json['enforceNumeric'] = self.enforceNumeric
        json['enforceSpecial'] = self.enforceSpecial
        json['pwHistoryDepth'] = self.pwHistoryDepth
        return json

# structure
class SSHSettings(Structure):
    idlType = "security.SSHSettings:1.0.0"
    elements = ["allowPasswordAuth", "allowPublicKeyAuth"]

    def __init__(self, allowPasswordAuth, allowPublicKeyAuth):
        typecheck.is_bool(allowPasswordAuth, AssertionError)
        typecheck.is_bool(allowPublicKeyAuth, AssertionError)

        self.allowPasswordAuth = allowPasswordAuth
        self.allowPublicKeyAuth = allowPublicKeyAuth

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            allowPasswordAuth = json['allowPasswordAuth'],
            allowPublicKeyAuth = json['allowPublicKeyAuth'],
        )
        return obj

    def encode(self):
        json = {}
        json['allowPasswordAuth'] = self.allowPasswordAuth
        json['allowPublicKeyAuth'] = self.allowPublicKeyAuth
        return json

# enumeration
class SSHHostKeyType(Enumeration):
    idlType = "security.SSHHostKeyType:2.0.0"
    values = ["SSH_HOST_KEY_TYPE_RSA", "SSH_HOST_KEY_TYPE_ECDSA", "SSH_HOST_KEY_TYPE_ED25519"]

SSHHostKeyType.SSH_HOST_KEY_TYPE_RSA = SSHHostKeyType(0)
SSHHostKeyType.SSH_HOST_KEY_TYPE_ECDSA = SSHHostKeyType(1)
SSHHostKeyType.SSH_HOST_KEY_TYPE_ED25519 = SSHHostKeyType(2)

# enumeration
class SSHKeyFingerprintType(Enumeration):
    idlType = "security.SSHKeyFingerprintType:1.0.0"
    values = ["SSH_KEY_FPRINT_TYPE_MD5_HEX", "SSH_KEY_FPRINT_TYPE_SHA256_BASE64", "SSH_KEY_FPRINT_TYPE_UNKNOWN"]

SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_MD5_HEX = SSHKeyFingerprintType(0)
SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_SHA256_BASE64 = SSHKeyFingerprintType(1)
SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_UNKNOWN = SSHKeyFingerprintType(2)

# structure
class SSHKeyFingerprint(Structure):
    idlType = "security.SSHKeyFingerprint:1.0.0"
    elements = ["fingerprint", "type"]

    def __init__(self, fingerprint, type):
        typecheck.is_string(fingerprint, AssertionError)
        typecheck.is_enum(type, raritan.rpc.security.SSHKeyFingerprintType, AssertionError)

        self.fingerprint = fingerprint
        self.type = type

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            fingerprint = json['fingerprint'],
            type = raritan.rpc.security.SSHKeyFingerprintType.decode(json['type']),
        )
        return obj

    def encode(self):
        json = {}
        json['fingerprint'] = self.fingerprint
        json['type'] = raritan.rpc.security.SSHKeyFingerprintType.encode(self.type)
        return json

# structure
class SSHHostKey(Structure):
    idlType = "security.SSHHostKey:2.0.0"
    elements = ["key", "type", "fingerprints"]

    def __init__(self, key, type, fingerprints):
        typecheck.is_string(key, AssertionError)
        typecheck.is_enum(type, raritan.rpc.security.SSHHostKeyType, AssertionError)
        for x0 in fingerprints:
            typecheck.is_struct(x0, raritan.rpc.security.SSHKeyFingerprint, AssertionError)

        self.key = key
        self.type = type
        self.fingerprints = fingerprints

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            key = json['key'],
            type = raritan.rpc.security.SSHHostKeyType.decode(json['type']),
            fingerprints = [raritan.rpc.security.SSHKeyFingerprint.decode(x0, agent) for x0 in json['fingerprints']],
        )
        return obj

    def encode(self):
        json = {}
        json['key'] = self.key
        json['type'] = raritan.rpc.security.SSHHostKeyType.encode(self.type)
        json['fingerprints'] = [raritan.rpc.security.SSHKeyFingerprint.encode(x0) for x0 in self.fingerprints]
        return json

# structure
class RestrictedServiceAgreement(Structure):
    idlType = "security.RestrictedServiceAgreement:1.0.0"
    elements = ["enabled", "banner"]

    def __init__(self, enabled, banner):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_string(banner, AssertionError)

        self.enabled = enabled
        self.banner = banner

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            banner = json['banner'],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['banner'] = self.banner
        return json

# structure
class TpmInfo(Structure):
    idlType = "security.TpmInfo:1.0.0"
    elements = ["detected"]

    def __init__(self, detected):
        typecheck.is_bool(detected, AssertionError)

        self.detected = detected

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            detected = json['detected'],
        )
        return obj

    def encode(self):
        json = {}
        json['detected'] = self.detected
        return json

# value object
class PasswordSettingsChanged(raritan.rpc.event.UserEvent):
    idlType = "security.PasswordSettingsChanged:1.0.0"

    def __init__(self, oldSettings, newSettings, actUserName, actIpAddr, source):
        super(raritan.rpc.security.PasswordSettingsChanged, self).__init__(actUserName, actIpAddr, source)
        typecheck.is_struct(oldSettings, raritan.rpc.security.PasswordSettings, AssertionError)
        typecheck.is_struct(newSettings, raritan.rpc.security.PasswordSettings, AssertionError)

        self.oldSettings = oldSettings
        self.newSettings = newSettings

    def encode(self):
        json = super(raritan.rpc.security.PasswordSettingsChanged, self).encode()
        json['oldSettings'] = raritan.rpc.security.PasswordSettings.encode(self.oldSettings)
        json['newSettings'] = raritan.rpc.security.PasswordSettings.encode(self.newSettings)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            oldSettings = raritan.rpc.security.PasswordSettings.decode(json['oldSettings'], agent),
            newSettings = raritan.rpc.security.PasswordSettings.decode(json['newSettings'], agent),
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["oldSettings", "newSettings"]
        elements = elements + super(raritan.rpc.security.PasswordSettingsChanged, self).listElements()
        return elements

# value object
class FrontPanelPrivilegesChanged(raritan.rpc.event.UserEvent):
    idlType = "security.FrontPanelPrivilegesChanged:1.0.0"

    def __init__(self, oldPrivileges, newPrivileges, actUserName, actIpAddr, source):
        super(raritan.rpc.security.FrontPanelPrivilegesChanged, self).__init__(actUserName, actIpAddr, source)
        for x0 in oldPrivileges:
            typecheck.is_string(x0, AssertionError)
        for x0 in newPrivileges:
            typecheck.is_string(x0, AssertionError)

        self.oldPrivileges = oldPrivileges
        self.newPrivileges = newPrivileges

    def encode(self):
        json = super(raritan.rpc.security.FrontPanelPrivilegesChanged, self).encode()
        json['oldPrivileges'] = [x0 for x0 in self.oldPrivileges]
        json['newPrivileges'] = [x0 for x0 in self.newPrivileges]
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            oldPrivileges = [x0 for x0 in json['oldPrivileges']],
            newPrivileges = [x0 for x0 in json['newPrivileges']],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["oldPrivileges", "newPrivileges"]
        elements = elements + super(raritan.rpc.security.FrontPanelPrivilegesChanged, self).listElements()
        return elements

# interface
class Security(Interface):
    idlType = "security.Security:5.0.0"

    ERR_INVALID_VALUE = 1

    class _getHttpRedirSettings(Interface.Method):
        name = 'getHttpRedirSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setHttpRedirSettings(Interface.Method):
        name = 'setHttpRedirSettings'

        @staticmethod
        def encode(http2httpsRedir):
            typecheck.is_bool(http2httpsRedir, AssertionError)
            args = {}
            args['http2httpsRedir'] = http2httpsRedir
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _isHstsEnabled(Interface.Method):
        name = 'isHstsEnabled'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setHstsEnabled(Interface.Method):
        name = 'setHstsEnabled'

        @staticmethod
        def encode(enable):
            typecheck.is_bool(enable, AssertionError)
            args = {}
            args['enable'] = enable
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getIpFwSettings(Interface.Method):
        name = 'getIpFwSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.IpFw.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.IpFw, DecodeException)
            return _ret_

    class _setIpFwSettings(Interface.Method):
        name = 'setIpFwSettings'

        @staticmethod
        def encode(ipFw):
            typecheck.is_struct(ipFw, raritan.rpc.security.IpFw, AssertionError)
            args = {}
            args['ipFw'] = raritan.rpc.security.IpFw.encode(ipFw)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getIpV6FwSettings(Interface.Method):
        name = 'getIpV6FwSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.IpFw.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.IpFw, DecodeException)
            return _ret_

    class _setIpV6FwSettings(Interface.Method):
        name = 'setIpV6FwSettings'

        @staticmethod
        def encode(ipV6Fw):
            typecheck.is_struct(ipV6Fw, raritan.rpc.security.IpFw, AssertionError)
            args = {}
            args['ipV6Fw'] = raritan.rpc.security.IpFw.encode(ipV6Fw)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getRoleAccessControlSettings(Interface.Method):
        name = 'getRoleAccessControlSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.RoleAccessControl.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.RoleAccessControl, DecodeException)
            return _ret_

    class _setRoleAccessControlSettings(Interface.Method):
        name = 'setRoleAccessControlSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.RoleAccessControl, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.RoleAccessControl.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getRoleAccessControlSettingsV6(Interface.Method):
        name = 'getRoleAccessControlSettingsV6'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.RoleAccessControl.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.RoleAccessControl, DecodeException)
            return _ret_

    class _setRoleAccessControlSettingsV6(Interface.Method):
        name = 'setRoleAccessControlSettingsV6'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.RoleAccessControl, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.RoleAccessControl.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getBlockSettings(Interface.Method):
        name = 'getBlockSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.BlockSettings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.BlockSettings, DecodeException)
            return _ret_

    class _setBlockSettings(Interface.Method):
        name = 'setBlockSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.BlockSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.BlockSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getPwSettings(Interface.Method):
        name = 'getPwSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.PasswordSettings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.PasswordSettings, DecodeException)
            return _ret_

    class _setPwSettings(Interface.Method):
        name = 'setPwSettings'

        @staticmethod
        def encode(pwSettings):
            typecheck.is_struct(pwSettings, raritan.rpc.security.PasswordSettings, AssertionError)
            args = {}
            args['pwSettings'] = raritan.rpc.security.PasswordSettings.encode(pwSettings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getIdleTimeoutSettings(Interface.Method):
        name = 'getIdleTimeoutSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setIdleTimeoutSettings(Interface.Method):
        name = 'setIdleTimeoutSettings'

        @staticmethod
        def encode(idleTimeout):
            typecheck.is_int(idleTimeout, AssertionError)
            args = {}
            args['idleTimeout'] = idleTimeout
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSingleLoginLimitation(Interface.Method):
        name = 'getSingleLoginLimitation'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setSingleLoginLimitation(Interface.Method):
        name = 'setSingleLoginLimitation'

        @staticmethod
        def encode(singleLogin):
            typecheck.is_bool(singleLogin, AssertionError)
            args = {}
            args['singleLogin'] = singleLogin
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getSSHSettings(Interface.Method):
        name = 'getSSHSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.SSHSettings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.SSHSettings, DecodeException)
            return _ret_

    class _setSSHSettings(Interface.Method):
        name = 'setSSHSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.SSHSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.SSHSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getSSHHostKeys(Interface.Method):
        name = 'getSSHHostKeys'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.security.SSHHostKey.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.security.SSHHostKey, DecodeException)
            return _ret_

    class _getRestrictedServiceAgreement(Interface.Method):
        name = 'getRestrictedServiceAgreement'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.RestrictedServiceAgreement.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.RestrictedServiceAgreement, DecodeException)
            return _ret_

    class _setRestrictedServiceAgreement(Interface.Method):
        name = 'setRestrictedServiceAgreement'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.RestrictedServiceAgreement, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.RestrictedServiceAgreement.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSupportedFrontPanelPrivileges(Interface.Method):
        name = 'getSupportedFrontPanelPrivileges'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getFrontPanelPrivileges(Interface.Method):
        name = 'getFrontPanelPrivileges'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _setFrontPanelPrivileges(Interface.Method):
        name = 'setFrontPanelPrivileges'

        @staticmethod
        def encode(privileges):
            for x0 in privileges:
                typecheck.is_string(x0, AssertionError)
            args = {}
            args['privileges'] = [x0 for x0 in privileges]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setDefaultAdminAccountPassword(Interface.Method):
        name = 'setDefaultAdminAccountPassword'

        @staticmethod
        def encode(password, disableStrongPasswordReq):
            typecheck.is_string(password, AssertionError)
            typecheck.is_bool(disableStrongPasswordReq, AssertionError)
            args = {}
            args['password'] = password
            args['disableStrongPasswordReq'] = disableStrongPasswordReq
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _isSecureBootActive(Interface.Method):
        name = 'isSecureBootActive'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _getTpmInfo(Interface.Method):
        name = 'getTpmInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.security.TpmInfo.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.security.TpmInfo, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Security, self).__init__(target, agent)
        self.getHttpRedirSettings = Security._getHttpRedirSettings(self)
        self.setHttpRedirSettings = Security._setHttpRedirSettings(self)
        self.isHstsEnabled = Security._isHstsEnabled(self)
        self.setHstsEnabled = Security._setHstsEnabled(self)
        self.getIpFwSettings = Security._getIpFwSettings(self)
        self.setIpFwSettings = Security._setIpFwSettings(self)
        self.getIpV6FwSettings = Security._getIpV6FwSettings(self)
        self.setIpV6FwSettings = Security._setIpV6FwSettings(self)
        self.getRoleAccessControlSettings = Security._getRoleAccessControlSettings(self)
        self.setRoleAccessControlSettings = Security._setRoleAccessControlSettings(self)
        self.getRoleAccessControlSettingsV6 = Security._getRoleAccessControlSettingsV6(self)
        self.setRoleAccessControlSettingsV6 = Security._setRoleAccessControlSettingsV6(self)
        self.getBlockSettings = Security._getBlockSettings(self)
        self.setBlockSettings = Security._setBlockSettings(self)
        self.getPwSettings = Security._getPwSettings(self)
        self.setPwSettings = Security._setPwSettings(self)
        self.getIdleTimeoutSettings = Security._getIdleTimeoutSettings(self)
        self.setIdleTimeoutSettings = Security._setIdleTimeoutSettings(self)
        self.getSingleLoginLimitation = Security._getSingleLoginLimitation(self)
        self.setSingleLoginLimitation = Security._setSingleLoginLimitation(self)
        self.getSSHSettings = Security._getSSHSettings(self)
        self.setSSHSettings = Security._setSSHSettings(self)
        self.getSSHHostKeys = Security._getSSHHostKeys(self)
        self.getRestrictedServiceAgreement = Security._getRestrictedServiceAgreement(self)
        self.setRestrictedServiceAgreement = Security._setRestrictedServiceAgreement(self)
        self.getSupportedFrontPanelPrivileges = Security._getSupportedFrontPanelPrivileges(self)
        self.getFrontPanelPrivileges = Security._getFrontPanelPrivileges(self)
        self.setFrontPanelPrivileges = Security._setFrontPanelPrivileges(self)
        self.setDefaultAdminAccountPassword = Security._setDefaultAdminAccountPassword(self)
        self.isSecureBootActive = Security._isSecureBootActive(self)
        self.getTpmInfo = Security._getTpmInfo(self)
