#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 1;

use CGI;
use CGIParameters qw( read_cgi_parameters );

my $cgi = CGI->new( { sessid => '0123456789abcdefg' } );
eval {
    read_cgi_parameters( $cgi,
                         { sessid => { re => '[0-9a-f]+' } } );
};
ok( $@ eq "Malformed query variable 'sessid' (should match regular expression '^([0-9a-f]+)\$')\n" );
