---
layout: post
title: Polyglot 1.10 - улучшения i18n_headers
lang: ru
description: Релиз Jekyll Polyglot 1.10.0 с улучшениями SEO при использовании плагина i18n_headers
---

Jekyll-Polyglot 1.10 теперь доступен. В этом релизе значительно улучшен плагин liquid `i18n_headers` для SEO, а также внесены небольшие изменения для идемпотентности при параллельной сборке. Сообщество и инструменты Vibe Coding внесли большой вклад в разработку функций, тестирование и написание этого поста.

## улучшения i18n_headers

Плагин `i18n_headers` теперь обладает расширенными возможностями:

* добавляет `<link rel="canonical" ...>` для каждого языка страницы, чтобы индексация была уникальной для каждого сайта.
* добавляет `<link rel="alternate" hreflang="x-default" ...>`, чтобы указывать на версию сайта по умолчанию, если браузер не запрашивает подходящий язык.
* корректно определяет `<link rel="alternate" hreflang="...">` для страниц и постов в коллекциях с пользовательскими постоянными ссылками.
* теперь URL по умолчанию будет включать `site.baseUrl`, если он определён.

Также исправлена ошибка, из-за которой относительные ссылки могли случайно искажать эти теги.

## вклад vibe-coded

Использование некоторых инструментов [vibe coding](https://en.wikipedia.org/wiki/Vibe_coding) помогло найти, измерить и проверить исправления и новые функции для этого релиза. Это новый подход к разработке ПО, позволивший писать продвинутые Ruby-тесты для кода плагинов Jekyll, работающих на многих языках сайта.

Тесты, написанные с помощью vibe coding, помогли поддерживать высокий охват тестами и уверенно добавлять сложные функции. Автоматизация тестирования обеспечила корректную реализацию сложных возможностей.

Кроме того, инструменты vibe coding помогли перевести этот блог-пост на многие языки.

## вклад сообщества

Jekyll-Polyglot поддерживается людьми. Документация на человеческих языках создаётся людьми, которые хотят видеть этот плагин задокументированным на своём родном языке. Люди, вносящие исправления и документацию, помогли этому плагину достичь тысяч загрузок на каждый релиз. Программирование с поддержкой ИИ — в моих или ваших руках — будет формировать используемое нами ПО и те многочисленные языки, на которых мы пишем и говорим. 

## требуется ruby >= 3.1

Постоянные обновления безопасности зависимостей сборки jekyll-polyglot потребовали крупного обновления до ruby 3.1. Это может повлиять на системы сборки, которые используют jekyll-polyglot для генерации документации. Сейчас хорошее время для перехода на последнюю основную версию ruby. Сообщите, если эти изменения вызывают сложности со сборкой jekyll. 