// Historic Unix crypt(3) password hashing routines.
//
// Rust version Copyright (c) 2016 Ivan Nejgebauer <inejge@gmail.com>
//
// Licensed under the MIT license <LICENSE-MIT or
// http://opensource.org/licenses/MIT>. This file may not be copied,
// modified, or distributed except according to the terms of this
// license.
//
// Original copyright/license notices follow:
//
// @(#)UnixCrypt.java   0.9 96/11/25
//
// Copyright (c) 1996 Aki Yoshida. All rights reserved.
//
// Permission to use, copy, modify and distribute this software
// for non-commercial or commercial purposes and without fee is
// hereby granted provided that this copyright notice appears in
// all copies.
// ---
// Unix crypt(3C) utility
// @version 0.9, 11/25/96
// @author  Aki Yoshida
// ---
// modified April 2001
// by Iris Van den Broeke, Daniel Deville
// ---
// Unix Crypt.
// Implements the one way cryptography used by Unix systems for
// simple password protection.
// @version $Id: UnixCrypt2.txt,v 1.1.1.1 2005/09/13 22:20:13 christos Exp $
// @author Greg Wilkins (gregw)

const PC1ROT: [[u64; 16]; 16] = [
    [ 0x0000000000000000, 0x0000000000000000, 0x0000010000000000, 0x0000010000000000,
      0x0000000100000000, 0x0000000100000000, 0x0000010100000000, 0x0000010100000000,
      0x0000000000100000, 0x0000000000100000, 0x0000010000100000, 0x0000010000100000,
      0x0000000100100000, 0x0000000100100000, 0x0000010100100000, 0x0000010100100000, ],
    [ 0x0000000000000000, 0x0000000080000000, 0x0000040000000000, 0x0000040080000000,
      0x0010000000000000, 0x0010000080000000, 0x0010040000000000, 0x0010040080000000,
      0x0000000800000000, 0x0000000880000000, 0x0000040800000000, 0x0000040880000000,
      0x0010000800000000, 0x0010000880000000, 0x0010040800000000, 0x0010040880000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000004000, 0x0000000000004000,
      0x0000000000000008, 0x0000000000000008, 0x0000000000004008, 0x0000000000004008,
      0x0000000000000010, 0x0000000000000010, 0x0000000000004010, 0x0000000000004010,
      0x0000000000000018, 0x0000000000000018, 0x0000000000004018, 0x0000000000004018, ],
    [ 0x0000000000000000, 0x0000000200000000, 0x0001000000000000, 0x0001000200000000,
      0x0400000000000000, 0x0400000200000000, 0x0401000000000000, 0x0401000200000000,
      0x0020000000000000, 0x0020000200000000, 0x0021000000000000, 0x0021000200000000,
      0x0420000000000000, 0x0420000200000000, 0x0421000000000000, 0x0421000200000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000400000, 0x0000000000400000,
      0x0000000004000000, 0x0000000004000000, 0x0000000004400000, 0x0000000004400000,
      0x0000000000000800, 0x0000000000000800, 0x0000000000400800, 0x0000000000400800,
      0x0000000004000800, 0x0000000004000800, 0x0000000004400800, 0x0000000004400800, ],
    [ 0x0000000000000000, 0x0000000000008000, 0x0040000000000000, 0x0040000000008000,
      0x0000004000000000, 0x0000004000008000, 0x0040004000000000, 0x0040004000008000,
      0x8000000000000000, 0x8000000000008000, 0x8040000000000000, 0x8040000000008000,
      0x8000004000000000, 0x8000004000008000, 0x8040004000000000, 0x8040004000008000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000080, 0x0000000000000080,
      0x0000000000080000, 0x0000000000080000, 0x0000000000080080, 0x0000000000080080,
      0x0000000000800000, 0x0000000000800000, 0x0000000000800080, 0x0000000000800080,
      0x0000000000880000, 0x0000000000880000, 0x0000000000880080, 0x0000000000880080, ],
    [ 0x0000000000000000, 0x0000000008000000, 0x0000002000000000, 0x0000002008000000,
      0x0000100000000000, 0x0000100008000000, 0x0000102000000000, 0x0000102008000000,
      0x0000200000000000, 0x0000200008000000, 0x0000202000000000, 0x0000202008000000,
      0x0000300000000000, 0x0000300008000000, 0x0000302000000000, 0x0000302008000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000010000000, 0x0000000010000000,
      0x0000000000001000, 0x0000000000001000, 0x0000000010001000, 0x0000000010001000,
      0x0000000040000000, 0x0000000040000000, 0x0000000050000000, 0x0000000050000000,
      0x0000000040001000, 0x0000000040001000, 0x0000000050001000, 0x0000000050001000, ],
    [ 0x0000000000000000, 0x0000001000000000, 0x0000080000000000, 0x0000081000000000,
      0x1000000000000000, 0x1000001000000000, 0x1000080000000000, 0x1000081000000000,
      0x0004000000000000, 0x0004001000000000, 0x0004080000000000, 0x0004081000000000,
      0x1004000000000000, 0x1004001000000000, 0x1004080000000000, 0x1004081000000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000040000, 0x0000000000040000,
      0x0000020000000000, 0x0000020000000000, 0x0000020000040000, 0x0000020000040000,
      0x0000000000000004, 0x0000000000000004, 0x0000000000040004, 0x0000000000040004,
      0x0000020000000004, 0x0000020000000004, 0x0000020000040004, 0x0000020000040004, ],
    [ 0x0000000000000000, 0x0000400000000000, 0x0200000000000000, 0x0200400000000000,
      0x0080000000000000, 0x0080400000000000, 0x0280000000000000, 0x0280400000000000,
      0x0000008000000000, 0x0000408000000000, 0x0200008000000000, 0x0200408000000000,
      0x0080008000000000, 0x0080408000000000, 0x0280008000000000, 0x0280408000000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000040, 0x0000000000000040,
      0x0000000020000000, 0x0000000020000000, 0x0000000020000040, 0x0000000020000040,
      0x0000000000200000, 0x0000000000200000, 0x0000000000200040, 0x0000000000200040,
      0x0000000020200000, 0x0000000020200000, 0x0000000020200040, 0x0000000020200040, ],
    [ 0x0000000000000000, 0x0002000000000000, 0x0800000000000000, 0x0802000000000000,
      0x0100000000000000, 0x0102000000000000, 0x0900000000000000, 0x0902000000000000,
      0x4000000000000000, 0x4002000000000000, 0x4800000000000000, 0x4802000000000000,
      0x4100000000000000, 0x4102000000000000, 0x4900000000000000, 0x4902000000000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000002000, 0x0000000000002000,
      0x0000000000000020, 0x0000000000000020, 0x0000000000002020, 0x0000000000002020,
      0x0000000000000400, 0x0000000000000400, 0x0000000000002400, 0x0000000000002400,
      0x0000000000000420, 0x0000000000000420, 0x0000000000002420, 0x0000000000002420, ],
    [ 0x0000000000000000, 0x2000000000000000, 0x0000000400000000, 0x2000000400000000,
      0x0000800000000000, 0x2000800000000000, 0x0000800400000000, 0x2000800400000000,
      0x0008000000000000, 0x2008000000000000, 0x0008000400000000, 0x2008000400000000,
      0x0008800000000000, 0x2008800000000000, 0x0008800400000000, 0x2008800400000000, ],
];

const PC2ROT: [[[u64; 16]; 16]; 2] = [
  [ [ 0x0000000000000000, 0x0000800000000000, 0x0800000000000000, 0x0800800000000000,
      0x0000004000000000, 0x0000804000000000, 0x0800004000000000, 0x0800804000000000,
      0x0000000400000000, 0x0000800400000000, 0x0800000400000000, 0x0800800400000000,
      0x0000004400000000, 0x0000804400000000, 0x0800004400000000, 0x0800804400000000, ],
    [ 0x0000000000000000, 0x0080000000000000, 0x0000040000000000, 0x0080040000000000,
      0x0008000000000000, 0x0088000000000000, 0x0008040000000000, 0x0088040000000000,
      0x0000200000000000, 0x0080200000000000, 0x0000240000000000, 0x0080240000000000,
      0x0008200000000000, 0x0088200000000000, 0x0008240000000000, 0x0088240000000000, ],
    [ 0x0000000000000000, 0x0040000000000000, 0x2000000000000000, 0x2040000000000000,
      0x0000008000000000, 0x0040008000000000, 0x2000008000000000, 0x2040008000000000,
      0x0000001000000000, 0x0040001000000000, 0x2000001000000000, 0x2040001000000000,
      0x0000009000000000, 0x0040009000000000, 0x2000009000000000, 0x2040009000000000, ],
    [ 0x0000000000000000, 0x0400000000000000, 0x8000000000000000, 0x8400000000000000,
      0x0000002000000000, 0x0400002000000000, 0x8000002000000000, 0x8400002000000000,
      0x0100000000000000, 0x0500000000000000, 0x8100000000000000, 0x8500000000000000,
      0x0100002000000000, 0x0500002000000000, 0x8100002000000000, 0x8500002000000000, ],
    [ 0x0000000000000000, 0x0000000000004000, 0x0000000020000000, 0x0000000020004000,
      0x0001000000000000, 0x0001000000004000, 0x0001000020000000, 0x0001000020004000,
      0x0200000000000000, 0x0200000000004000, 0x0200000020000000, 0x0200000020004000,
      0x0201000000000000, 0x0201000000004000, 0x0201000020000000, 0x0201000020004000, ],
    [ 0x0000000000000000, 0x1000000000000000, 0x0004000000000000, 0x1004000000000000,
      0x0002000000000000, 0x1002000000000000, 0x0006000000000000, 0x1006000000000000,
      0x0000000800000000, 0x1000000800000000, 0x0004000800000000, 0x1004000800000000,
      0x0002000800000000, 0x1002000800000000, 0x0006000800000000, 0x1006000800000000, ],
    [ 0x0000000000000000, 0x0000000000000008, 0x0000000000008000, 0x0000000000008008,
      0x0010000000000000, 0x0010000000000008, 0x0010000000008000, 0x0010000000008008,
      0x0020000000000000, 0x0020000000000008, 0x0020000000008000, 0x0020000000008008,
      0x0030000000000000, 0x0030000000000008, 0x0030000000008000, 0x0030000000008008, ],
    [ 0x0000000000000000, 0x0000400000000000, 0x0000080000000000, 0x0000480000000000,
      0x0000100000000000, 0x0000500000000000, 0x0000180000000000, 0x0000580000000000,
      0x4000000000000000, 0x4000400000000000, 0x4000080000000000, 0x4000480000000000,
      0x4000100000000000, 0x4000500000000000, 0x4000180000000000, 0x4000580000000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000000080000, 0x0000000000080000, 0x0000000000080000, 0x0000000000080000,
      0x0000000000100000, 0x0000000000100000, 0x0000000000100000, 0x0000000000100000,
      0x0000000000180000, 0x0000000000180000, 0x0000000000180000, 0x0000000000180000, ],
    [ 0x0000000000000000, 0x0000000000040000, 0x0000000000000020, 0x0000000000040020,
      0x0000000000000004, 0x0000000000040004, 0x0000000000000024, 0x0000000000040024,
      0x0000000200000000, 0x0000000200040000, 0x0000000200000020, 0x0000000200040020,
      0x0000000200000004, 0x0000000200040004, 0x0000000200000024, 0x0000000200040024, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000000000040, 0x0000000000000040, 0x0000000000000040, 0x0000000000000040,
      0x0000000000001000, 0x0000000000001000, 0x0000000000001000, 0x0000000000001000,
      0x0000000000001040, 0x0000000000001040, 0x0000000000001040, 0x0000000000001040, ],
    [ 0x0000000000000000, 0x0000000000000010, 0x0000000000000400, 0x0000000000000410,
      0x0000000000000080, 0x0000000000000090, 0x0000000000000480, 0x0000000000000490,
      0x0000000040000000, 0x0000000040000010, 0x0000000040000400, 0x0000000040000410,
      0x0000000040000080, 0x0000000040000090, 0x0000000040000480, 0x0000000040000490, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000100000000, 0x0000000100000000, 0x0000000100000000, 0x0000000100000000,
      0x0000000000800000, 0x0000000000800000, 0x0000000000800000, 0x0000000000800000,
      0x0000000100800000, 0x0000000100800000, 0x0000000100800000, 0x0000000100800000, ],
    [ 0x0000000000000000, 0x0000020000000000, 0x0000000080000000, 0x0000020080000000,
      0x0000000000400000, 0x0000020000400000, 0x0000000080400000, 0x0000020080400000,
      0x0000000008000000, 0x0000020008000000, 0x0000000088000000, 0x0000020088000000,
      0x0000000008400000, 0x0000020008400000, 0x0000000088400000, 0x0000020088400000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000000200000, 0x0000000000200000, 0x0000000000200000, 0x0000000000200000,
      0x0000000004000000, 0x0000000004000000, 0x0000000004000000, 0x0000000004000000,
      0x0000000004200000, 0x0000000004200000, 0x0000000004200000, 0x0000000004200000, ],
    [ 0x0000000000000000, 0x0000000000000800, 0x0000010000000000, 0x0000010000000800,
      0x0000000000002000, 0x0000000000002800, 0x0000010000002000, 0x0000010000002800,
      0x0000000010000000, 0x0000000010000800, 0x0000010010000000, 0x0000010010000800,
      0x0000000010002000, 0x0000000010002800, 0x0000010010002000, 0x0000010010002800, ],
  ],
  [ [ 0x0000000000000000, 0x0000000800000000, 0x0000000400000000, 0x0000000c00000000,
      0x0000100000000000, 0x0000100800000000, 0x0000100400000000, 0x0000100c00000000,
      0x0010000000000000, 0x0010000800000000, 0x0010000400000000, 0x0010000c00000000,
      0x0010100000000000, 0x0010100800000000, 0x0010100400000000, 0x0010100c00000000, ],
    [ 0x0000000000000000, 0x0100000000000000, 0x0001000000000000, 0x0101000000000000,
      0x0000001000000000, 0x0100001000000000, 0x0001001000000000, 0x0101001000000000,
      0x0004000000000000, 0x0104000000000000, 0x0005000000000000, 0x0105000000000000,
      0x0004001000000000, 0x0104001000000000, 0x0005001000000000, 0x0105001000000000, ],
    [ 0x0000000000000000, 0x0000002000000000, 0x0000040000000000, 0x0000042000000000,
      0x4000000000000000, 0x4000002000000000, 0x4000040000000000, 0x4000042000000000,
      0x0000400000000000, 0x0000402000000000, 0x0000440000000000, 0x0000442000000000,
      0x4000400000000000, 0x4000402000000000, 0x4000440000000000, 0x4000442000000000, ],
    [ 0x0000000000000000, 0x0000004000000000, 0x0000200000000000, 0x0000204000000000,
      0x0000080000000000, 0x0000084000000000, 0x0000280000000000, 0x0000284000000000,
      0x0000800000000000, 0x0000804000000000, 0x0000a00000000000, 0x0000a04000000000,
      0x0000880000000000, 0x0000884000000000, 0x0000a80000000000, 0x0000a84000000000, ],
    [ 0x0000000000000000, 0x0000000000400000, 0x0000000000000020, 0x0000000000400020,
      0x0040000000000000, 0x0040000000400000, 0x0040000000000020, 0x0040000000400020,
      0x0800000000000000, 0x0800000000400000, 0x0800000000000020, 0x0800000000400020,
      0x0840000000000000, 0x0840000000400000, 0x0840000000000020, 0x0840000000400020, ],
    [ 0x0000000000000000, 0x0080000000000000, 0x0000008000000000, 0x0080008000000000,
      0x2000000000000000, 0x2080000000000000, 0x2000008000000000, 0x2080008000000000,
      0x0020000000000000, 0x00a0000000000000, 0x0020008000000000, 0x00a0008000000000,
      0x2020000000000000, 0x20a0000000000000, 0x2020008000000000, 0x20a0008000000000, ],
    [ 0x0000000000000000, 0x0000000004000000, 0x0000000008000000, 0x000000000c000000,
      0x0400000000000000, 0x0400000004000000, 0x0400000008000000, 0x040000000c000000,
      0x8000000000000000, 0x8000000004000000, 0x8000000008000000, 0x800000000c000000,
      0x8400000000000000, 0x8400000004000000, 0x8400000008000000, 0x840000000c000000, ],
    [ 0x0000000000000000, 0x0002000000000000, 0x0200000000000000, 0x0202000000000000,
      0x1000000000000000, 0x1002000000000000, 0x1200000000000000, 0x1202000000000000,
      0x0008000000000000, 0x000a000000000000, 0x0208000000000000, 0x020a000000000000,
      0x1008000000000000, 0x100a000000000000, 0x1208000000000000, 0x120a000000000000, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000000001000, 0x0000000000001000, 0x0000000000001000, 0x0000000000001000,
      0x0000000000000010, 0x0000000000000010, 0x0000000000000010, 0x0000000000000010,
      0x0000000000001010, 0x0000000000001010, 0x0000000000001010, 0x0000000000001010, ],
    [ 0x0000000000000000, 0x0000000000000040, 0x0000010000000000, 0x0000010000000040,
      0x0000000000200000, 0x0000000000200040, 0x0000010000200000, 0x0000010000200040,
      0x0000000000008000, 0x0000000000008040, 0x0000010000008000, 0x0000010000008040,
      0x0000000000208000, 0x0000000000208040, 0x0000010000208000, 0x0000010000208040, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000000002000, 0x0000000000002000, 0x0000000000002000, 0x0000000000002000,
      0x0000020000000000, 0x0000020000000000, 0x0000020000000000, 0x0000020000000000,
      0x0000020000002000, 0x0000020000002000, 0x0000020000002000, 0x0000020000002000, ],
    [ 0x0000000000000000, 0x0000000000000800, 0x0000000100000000, 0x0000000100000800,
      0x0000000010000000, 0x0000000010000800, 0x0000000110000000, 0x0000000110000800,
      0x0000000000000004, 0x0000000000000804, 0x0000000100000004, 0x0000000100000804,
      0x0000000010000004, 0x0000000010000804, 0x0000000110000004, 0x0000000110000804, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000000000008, 0x0000000000000008, 0x0000000000000008, 0x0000000000000008,
      0x0000000040000000, 0x0000000040000000, 0x0000000040000000, 0x0000000040000000,
      0x0000000040000008, 0x0000000040000008, 0x0000000040000008, 0x0000000040000008, ],
    [ 0x0000000000000000, 0x0000000020000000, 0x0000000200000000, 0x0000000220000000,
      0x0000000000000080, 0x0000000020000080, 0x0000000200000080, 0x0000000220000080,
      0x0000000000100000, 0x0000000020100000, 0x0000000200100000, 0x0000000220100000,
      0x0000000000100080, 0x0000000020100080, 0x0000000200100080, 0x0000000220100080, ],
    [ 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
      0x0000000000000400, 0x0000000000000400, 0x0000000000000400, 0x0000000000000400,
      0x0000000000080000, 0x0000000000080000, 0x0000000000080000, 0x0000000000080000,
      0x0000000000080400, 0x0000000000080400, 0x0000000000080400, 0x0000000000080400, ],
    [ 0x0000000000000000, 0x0000000000800000, 0x0000000000004000, 0x0000000000804000,
      0x0000000080000000, 0x0000000080800000, 0x0000000080004000, 0x0000000080804000,
      0x0000000000040000, 0x0000000000840000, 0x0000000000044000, 0x0000000000844000,
      0x0000000080040000, 0x0000000080840000, 0x0000000080044000, 0x0000000080844000, ],
  ]
];

#[allow(non_upper_case_globals)]
const Rotates: [usize; 16] = [ 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1 ];

const IE3264: [[u64; 16]; 8] = [
    [ 0x0000000000000000, 0x0000000000004004, 0x0400000000000040, 0x0400000000004044,
      0x0000000040040000, 0x0000000040044004, 0x0400000040040040, 0x0400000040044044,
      0x0000000000400400, 0x0000000000404404, 0x0400000000400440, 0x0400000000404444,
      0x0000000040440400, 0x0000000040444404, 0x0400000040440440, 0x0400000040444444, ],
    [ 0x0000000000000000, 0x0000400400000000, 0x0000004004000000, 0x0000404404000000,
      0x4004000000000000, 0x4004400400000000, 0x4004004004000000, 0x4004404404000000,
      0x0040040000000000, 0x0040440400000000, 0x0040044004000000, 0x0040444404000000,
      0x4044040000000000, 0x4044440400000000, 0x4044044004000000, 0x4044444404000000, ],
    [ 0x0000000000000000, 0x0000000000002000, 0x0000000000000020, 0x0000000000002020,
      0x0000000020000000, 0x0000000020002000, 0x0000000020000020, 0x0000000020002020,
      0x0000000000200000, 0x0000000000202000, 0x0000000000200020, 0x0000000000202020,
      0x0000000020200000, 0x0000000020202000, 0x0000000020200020, 0x0000000020202020, ],
    [ 0x0000000000000000, 0x0000200000000000, 0x0000002000000000, 0x0000202000000000,
      0x2000000000000000, 0x2000200000000000, 0x2000002000000000, 0x2000202000000000,
      0x0020000000000000, 0x0020200000000000, 0x0020002000000000, 0x0020202000000000,
      0x2020000000000000, 0x2020200000000000, 0x2020002000000000, 0x2020202000000000, ],
    [ 0x0000000000000000, 0x0000000000001000, 0x0000000000000010, 0x0000000000001010,
      0x0000000010000000, 0x0000000010001000, 0x0000000010000010, 0x0000000010001010,
      0x0000000000100000, 0x0000000000101000, 0x0000000000100010, 0x0000000000101010,
      0x0000000010100000, 0x0000000010101000, 0x0000000010100010, 0x0000000010101010, ],
    [ 0x0000000000000000, 0x0000100000000000, 0x0000001000000000, 0x0000101000000000,
      0x1000000000000000, 0x1000100000000000, 0x1000001000000000, 0x1000101000000000,
      0x0010000000000000, 0x0010100000000000, 0x0010001000000000, 0x0010101000000000,
      0x1010000000000000, 0x1010100000000000, 0x1010001000000000, 0x1010101000000000, ],
    [ 0x0000000000000000, 0x0000000000800800, 0x0000000000008008, 0x0000000000808808,
      0x0000008008000000, 0x0000008008800800, 0x0000008008008008, 0x0000008008808808,
      0x0000000080080000, 0x0000000080880800, 0x0000000080088008, 0x0000000080888808,
      0x0000008088080000, 0x0000008088880800, 0x0000008088088008, 0x0000008088888808, ],
    [ 0x0000000000000000, 0x0080080000000000, 0x0000800800000000, 0x0080880800000000,
      0x0800000000000080, 0x0880080000000080, 0x0800800800000080, 0x0880880800000080,
      0x8008000000000000, 0x8088080000000000, 0x8008800800000000, 0x8088880800000000,
      0x8808000000000080, 0x8888080000000080, 0x8808800800000080, 0x8888880800000080, ],
];

const CF6464: [[u64; 16]; 16] = [
    [ 0x0000000000000000, 0x0000000000000040, 0x0000000000004000, 0x0000000000004040,
      0x0000000000400000, 0x0000000000400040, 0x0000000000404000, 0x0000000000404040,
      0x0000000040000000, 0x0000000040000040, 0x0000000040004000, 0x0000000040004040,
      0x0000000040400000, 0x0000000040400040, 0x0000000040404000, 0x0000000040404040, ],
    [ 0x0000000000000000, 0x0000000000000004, 0x0000000000000400, 0x0000000000000404,
      0x0000000000040000, 0x0000000000040004, 0x0000000000040400, 0x0000000000040404,
      0x0000000004000000, 0x0000000004000004, 0x0000000004000400, 0x0000000004000404,
      0x0000000004040000, 0x0000000004040004, 0x0000000004040400, 0x0000000004040404, ],
    [ 0x0000000000000000, 0x0000004000000000, 0x0000400000000000, 0x0000404000000000,
      0x0040000000000000, 0x0040004000000000, 0x0040400000000000, 0x0040404000000000,
      0x4000000000000000, 0x4000004000000000, 0x4000400000000000, 0x4000404000000000,
      0x4040000000000000, 0x4040004000000000, 0x4040400000000000, 0x4040404000000000, ],
    [ 0x0000000000000000, 0x0000000400000000, 0x0000040000000000, 0x0000040400000000,
      0x0004000000000000, 0x0004000400000000, 0x0004040000000000, 0x0004040400000000,
      0x0400000000000000, 0x0400000400000000, 0x0400040000000000, 0x0400040400000000,
      0x0404000000000000, 0x0404000400000000, 0x0404040000000000, 0x0404040400000000, ],
    [ 0x0000000000000000, 0x0000000000000010, 0x0000000000001000, 0x0000000000001010,
      0x0000000000100000, 0x0000000000100010, 0x0000000000101000, 0x0000000000101010,
      0x0000000010000000, 0x0000000010000010, 0x0000000010001000, 0x0000000010001010,
      0x0000000010100000, 0x0000000010100010, 0x0000000010101000, 0x0000000010101010, ],
    [ 0x0000000000000000, 0x0000000000000001, 0x0000000000000100, 0x0000000000000101,
      0x0000000000010000, 0x0000000000010001, 0x0000000000010100, 0x0000000000010101,
      0x0000000001000000, 0x0000000001000001, 0x0000000001000100, 0x0000000001000101,
      0x0000000001010000, 0x0000000001010001, 0x0000000001010100, 0x0000000001010101, ],
    [ 0x0000000000000000, 0x0000001000000000, 0x0000100000000000, 0x0000101000000000,
      0x0010000000000000, 0x0010001000000000, 0x0010100000000000, 0x0010101000000000,
      0x1000000000000000, 0x1000001000000000, 0x1000100000000000, 0x1000101000000000,
      0x1010000000000000, 0x1010001000000000, 0x1010100000000000, 0x1010101000000000, ],
    [ 0x0000000000000000, 0x0000000100000000, 0x0000010000000000, 0x0000010100000000,
      0x0001000000000000, 0x0001000100000000, 0x0001010000000000, 0x0001010100000000,
      0x0100000000000000, 0x0100000100000000, 0x0100010000000000, 0x0100010100000000,
      0x0101000000000000, 0x0101000100000000, 0x0101010000000000, 0x0101010100000000, ],
    [ 0x0000000000000000, 0x0000000000000080, 0x0000000000008000, 0x0000000000008080,
      0x0000000000800000, 0x0000000000800080, 0x0000000000808000, 0x0000000000808080,
      0x0000000080000000, 0x0000000080000080, 0x0000000080008000, 0x0000000080008080,
      0x0000000080800000, 0x0000000080800080, 0x0000000080808000, 0x0000000080808080, ],
    [ 0x0000000000000000, 0x0000000000000008, 0x0000000000000800, 0x0000000000000808,
      0x0000000000080000, 0x0000000000080008, 0x0000000000080800, 0x0000000000080808,
      0x0000000008000000, 0x0000000008000008, 0x0000000008000800, 0x0000000008000808,
      0x0000000008080000, 0x0000000008080008, 0x0000000008080800, 0x0000000008080808, ],
    [ 0x0000000000000000, 0x0000008000000000, 0x0000800000000000, 0x0000808000000000,
      0x0080000000000000, 0x0080008000000000, 0x0080800000000000, 0x0080808000000000,
      0x8000000000000000, 0x8000008000000000, 0x8000800000000000, 0x8000808000000000,
      0x8080000000000000, 0x8080008000000000, 0x8080800000000000, 0x8080808000000000, ],
    [ 0x0000000000000000, 0x0000000800000000, 0x0000080000000000, 0x0000080800000000,
      0x0008000000000000, 0x0008000800000000, 0x0008080000000000, 0x0008080800000000,
      0x0800000000000000, 0x0800000800000000, 0x0800080000000000, 0x0800080800000000,
      0x0808000000000000, 0x0808000800000000, 0x0808080000000000, 0x0808080800000000, ],
    [ 0x0000000000000000, 0x0000000000000020, 0x0000000000002000, 0x0000000000002020,
      0x0000000000200000, 0x0000000000200020, 0x0000000000202000, 0x0000000000202020,
      0x0000000020000000, 0x0000000020000020, 0x0000000020002000, 0x0000000020002020,
      0x0000000020200000, 0x0000000020200020, 0x0000000020202000, 0x0000000020202020, ],
    [ 0x0000000000000000, 0x0000000000000002, 0x0000000000000200, 0x0000000000000202,
      0x0000000000020000, 0x0000000000020002, 0x0000000000020200, 0x0000000000020202,
      0x0000000002000000, 0x0000000002000002, 0x0000000002000200, 0x0000000002000202,
      0x0000000002020000, 0x0000000002020002, 0x0000000002020200, 0x0000000002020202, ],
    [ 0x0000000000000000, 0x0000002000000000, 0x0000200000000000, 0x0000202000000000,
      0x0020000000000000, 0x0020002000000000, 0x0020200000000000, 0x0020202000000000,
      0x2000000000000000, 0x2000002000000000, 0x2000200000000000, 0x2000202000000000,
      0x2020000000000000, 0x2020002000000000, 0x2020200000000000, 0x2020202000000000, ],
    [ 0x0000000000000000, 0x0000000200000000, 0x0000020000000000, 0x0000020200000000,
      0x0002000000000000, 0x0002000200000000, 0x0002020000000000, 0x0002020200000000,
      0x0200000000000000, 0x0200000200000000, 0x0200020000000000, 0x0200020200000000,
      0x0202000000000000, 0x0202000200000000, 0x0202020000000000, 0x0202020200000000, ],
];

const SPE: [[u64; 64]; 8] = [
    [ 0x0080088008200000, 0x0000008008000000, 0x0000000000200020, 0x0080088008200020,
      0x0000000000200000, 0x0080088008000020, 0x0000008008000020, 0x0000000000200020,
      0x0080088008000020, 0x0080088008200000, 0x0000008008200000, 0x0080080000000020,
      0x0080080000200020, 0x0000000000200000, 0x0000000000000000, 0x0000008008000020,
      0x0000008008000000, 0x0000000000000020, 0x0080080000200000, 0x0080088008000000,
      0x0080088008200020, 0x0000008008200000, 0x0080080000000020, 0x0080080000200000,
      0x0000000000000020, 0x0080080000000000, 0x0080088008000000, 0x0000008008200020,
      0x0080080000000000, 0x0080080000200020, 0x0000008008200020, 0x0000000000000000,
      0x0000000000000000, 0x0080088008200020, 0x0080080000200000, 0x0000008008000020,
      0x0080088008200000, 0x0000008008000000, 0x0080080000000020, 0x0080080000200000,
      0x0000008008200020, 0x0080080000000000, 0x0080088008000000, 0x0000000000200020,
      0x0080088008000020, 0x0000000000000020, 0x0000000000200020, 0x0000008008200000,
      0x0080088008200020, 0x0080088008000000, 0x0000008008200000, 0x0080080000200020,
      0x0000000000200000, 0x0080080000000020, 0x0000008008000020, 0x0000000000000000,
      0x0000008008000000, 0x0000000000200000, 0x0080080000200020, 0x0080088008200000,
      0x0000000000000020, 0x0000008008200020, 0x0080080000000000, 0x0080088008000020, ],
    [ 0x1000800810004004, 0x0000000000000000, 0x0000800810000000, 0x0000000010004004,
      0x1000000000004004, 0x1000800800000000, 0x0000800800004004, 0x0000800810000000,
      0x0000800800000000, 0x1000000010004004, 0x1000000000000000, 0x0000800800004004,
      0x1000000010000000, 0x0000800810004004, 0x0000000010004004, 0x1000000000000000,
      0x0000000010000000, 0x1000800800004004, 0x1000000010004004, 0x0000800800000000,
      0x1000800810000000, 0x0000000000004004, 0x0000000000000000, 0x1000000010000000,
      0x1000800800004004, 0x1000800810000000, 0x0000800810004004, 0x1000000000004004,
      0x0000000000004004, 0x0000000010000000, 0x1000800800000000, 0x1000800810004004,
      0x1000000010000000, 0x0000800810004004, 0x0000800800004004, 0x1000800810000000,
      0x1000800810004004, 0x1000000010000000, 0x1000000000004004, 0x0000000000000000,
      0x0000000000004004, 0x1000800800000000, 0x0000000010000000, 0x1000000010004004,
      0x0000800800000000, 0x0000000000004004, 0x1000800810000000, 0x1000800800004004,
      0x0000800810004004, 0x0000800800000000, 0x0000000000000000, 0x1000000000004004,
      0x1000000000000000, 0x1000800810004004, 0x0000800810000000, 0x0000000010004004,
      0x1000000010004004, 0x0000000010000000, 0x1000800800000000, 0x0000800800004004,
      0x1000800800004004, 0x1000000000000000, 0x0000000010004004, 0x0000800810000000, ],
    [ 0x0000000000400410, 0x0010004004400400, 0x0010000000000000, 0x0010000000400410,
      0x0000004004000010, 0x0000000000400400, 0x0010000000400410, 0x0010004004000000,
      0x0010000000400400, 0x0000004004000000, 0x0000004004400400, 0x0000000000000010,
      0x0010004004400410, 0x0010000000000010, 0x0000000000000010, 0x0000004004400410,
      0x0000000000000000, 0x0000004004000010, 0x0010004004400400, 0x0010000000000000,
      0x0010000000000010, 0x0010004004400410, 0x0000004004000000, 0x0000000000400410,
      0x0000004004400410, 0x0010000000400400, 0x0010004004000010, 0x0000004004400400,
      0x0010004004000000, 0x0000000000000000, 0x0000000000400400, 0x0010004004000010,
      0x0010004004400400, 0x0010000000000000, 0x0000000000000010, 0x0000004004000000,
      0x0010000000000010, 0x0000004004000010, 0x0000004004400400, 0x0010000000400410,
      0x0000000000000000, 0x0010004004400400, 0x0010004004000000, 0x0000004004400410,
      0x0000004004000010, 0x0000000000400400, 0x0010004004400410, 0x0000000000000010,
      0x0010004004000010, 0x0000000000400410, 0x0000000000400400, 0x0010004004400410,
      0x0000004004000000, 0x0010000000400400, 0x0010000000400410, 0x0010004004000000,
      0x0010000000400400, 0x0000000000000000, 0x0000004004400410, 0x0010000000000010,
      0x0000000000400410, 0x0010004004000010, 0x0010000000000000, 0x0000004004400400, ],
    [ 0x0800100040040080, 0x0000100000001000, 0x0800000000000080, 0x0800100040041080,
      0x0000000000000000, 0x0000000040041000, 0x0800100000001080, 0x0800000040040080,
      0x0000100040041000, 0x0800000000001080, 0x0000000000001000, 0x0800100000000080,
      0x0800000000001080, 0x0800100040040080, 0x0000000040040000, 0x0000000000001000,
      0x0800000040041080, 0x0000100040040000, 0x0000100000000000, 0x0800000000000080,
      0x0000100040040000, 0x0800100000001080, 0x0000000040041000, 0x0000100000000000,
      0x0800100000000080, 0x0000000000000000, 0x0800000040040080, 0x0000100040041000,
      0x0000100000001000, 0x0800000040041080, 0x0800100040041080, 0x0000000040040000,
      0x0800000040041080, 0x0800100000000080, 0x0000000040040000, 0x0800000000001080,
      0x0000100040040000, 0x0000100000001000, 0x0800000000000080, 0x0000000040041000,
      0x0800100000001080, 0x0000000000000000, 0x0000100000000000, 0x0800000040040080,
      0x0000000000000000, 0x0800000040041080, 0x0000100040041000, 0x0000100000000000,
      0x0000000000001000, 0x0800100040041080, 0x0800100040040080, 0x0000000040040000,
      0x0800100040041080, 0x0800000000000080, 0x0000100000001000, 0x0800100040040080,
      0x0800000040040080, 0x0000100040040000, 0x0000000040041000, 0x0800100000001080,
      0x0800100000000080, 0x0000000000001000, 0x0800000000001080, 0x0000100040041000, ],
    [ 0x0000000000800800, 0x0000001000000000, 0x0040040000000000, 0x2040041000800800,
      0x2000001000800800, 0x0040040000800800, 0x2040041000000000, 0x0000001000800800,
      0x0000001000000000, 0x2000000000000000, 0x2000000000800800, 0x0040041000000000,
      0x2040040000800800, 0x2000001000800800, 0x0040041000800800, 0x0000000000000000,
      0x0040041000000000, 0x0000000000800800, 0x2000001000000000, 0x2040040000000000,
      0x0040040000800800, 0x2040041000000000, 0x0000000000000000, 0x2000000000800800,
      0x2000000000000000, 0x2040040000800800, 0x2040041000800800, 0x2000001000000000,
      0x0000001000800800, 0x0040040000000000, 0x2040040000000000, 0x0040041000800800,
      0x0040041000800800, 0x2040040000800800, 0x2000001000000000, 0x0000001000800800,
      0x0000001000000000, 0x2000000000000000, 0x2000000000800800, 0x0040040000800800,
      0x0000000000800800, 0x0040041000000000, 0x2040041000800800, 0x0000000000000000,
      0x2040041000000000, 0x0000000000800800, 0x0040040000000000, 0x2000001000000000,
      0x2040040000800800, 0x0040040000000000, 0x0000000000000000, 0x2040041000800800,
      0x2000001000800800, 0x0040041000800800, 0x2040040000000000, 0x0000001000000000,
      0x0040041000000000, 0x2000001000800800, 0x0040040000800800, 0x2040040000000000,
      0x2000000000000000, 0x2040041000000000, 0x0000001000800800, 0x2000000000800800, ],
    [ 0x4004000000008008, 0x4004000020000000, 0x0000000000000000, 0x0000200020008008,
      0x4004000020000000, 0x0000200000000000, 0x4004200000008008, 0x0000000020000000,
      0x4004200000000000, 0x4004200020008008, 0x0000200020000000, 0x0000000000008008,
      0x0000200000008008, 0x4004000000008008, 0x0000000020008008, 0x4004200020000000,
      0x0000000020000000, 0x4004200000008008, 0x4004000020008008, 0x0000000000000000,
      0x0000200000000000, 0x4004000000000000, 0x0000200020008008, 0x4004000020008008,
      0x4004200020008008, 0x0000000020008008, 0x0000000000008008, 0x4004200000000000,
      0x4004000000000000, 0x0000200020000000, 0x4004200020000000, 0x0000200000008008,
      0x4004200000000000, 0x0000000000008008, 0x0000200000008008, 0x4004200020000000,
      0x0000200020008008, 0x4004000020000000, 0x0000000000000000, 0x0000200000008008,
      0x0000000000008008, 0x0000200000000000, 0x4004000020008008, 0x0000000020000000,
      0x4004000020000000, 0x4004200020008008, 0x0000200020000000, 0x4004000000000000,
      0x4004200020008008, 0x0000200020000000, 0x0000000020000000, 0x4004200000008008,
      0x4004000000008008, 0x0000000020008008, 0x4004200020000000, 0x0000000000000000,
      0x0000200000000000, 0x4004000000008008, 0x4004200000008008, 0x0000200020008008,
      0x0000000020008008, 0x4004200000000000, 0x4004000000000000, 0x4004000020008008, ],
    [ 0x0000400400000000, 0x0020000000000000, 0x0020000000100000, 0x0400000000100040,
      0x0420400400100040, 0x0400400400000040, 0x0020400400000000, 0x0000000000000000,
      0x0000000000100000, 0x0420000000100040, 0x0420000000000040, 0x0000400400100000,
      0x0400000000000040, 0x0020400400100000, 0x0000400400100000, 0x0420000000000040,
      0x0420000000100040, 0x0000400400000000, 0x0400400400000040, 0x0420400400100040,
      0x0000000000000000, 0x0020000000100000, 0x0400000000100040, 0x0020400400000000,
      0x0400400400100040, 0x0420400400000040, 0x0020400400100000, 0x0400000000000040,
      0x0420400400000040, 0x0400400400100040, 0x0020000000000000, 0x0000000000100000,
      0x0420400400000040, 0x0000400400100000, 0x0400400400100040, 0x0420000000000040,
      0x0000400400000000, 0x0020000000000000, 0x0000000000100000, 0x0400400400100040,
      0x0420000000100040, 0x0420400400000040, 0x0020400400000000, 0x0000000000000000,
      0x0020000000000000, 0x0400000000100040, 0x0400000000000040, 0x0020000000100000,
      0x0000000000000000, 0x0420000000100040, 0x0020000000100000, 0x0020400400000000,
      0x0420000000000040, 0x0000400400000000, 0x0420400400100040, 0x0000000000100000,
      0x0020400400100000, 0x0400000000000040, 0x0400400400000040, 0x0420400400100040,
      0x0400000000100040, 0x0020400400100000, 0x0000400400100000, 0x0400400400000040, ],
    [ 0x8008000080082000, 0x0000002080082000, 0x8008002000000000, 0x0000000000000000,
      0x0000002000002000, 0x8008000080080000, 0x0000000080082000, 0x8008002080082000,
      0x8008000000000000, 0x0000000000002000, 0x0000002080080000, 0x8008002000000000,
      0x8008002080080000, 0x8008002000002000, 0x8008000000002000, 0x0000000080082000,
      0x0000002000000000, 0x8008002080080000, 0x8008000080080000, 0x0000002000002000,
      0x8008002080082000, 0x8008000000002000, 0x0000000000000000, 0x0000002080080000,
      0x0000000000002000, 0x0000000080080000, 0x8008002000002000, 0x8008000080082000,
      0x0000000080080000, 0x0000002000000000, 0x0000002080082000, 0x8008000000000000,
      0x0000000080080000, 0x0000002000000000, 0x8008000000002000, 0x8008002080082000,
      0x8008002000000000, 0x0000000000002000, 0x0000000000000000, 0x0000002080080000,
      0x8008000080082000, 0x8008002000002000, 0x0000002000002000, 0x8008000080080000,
      0x0000002080082000, 0x8008000000000000, 0x8008000080080000, 0x0000002000002000,
      0x8008002080082000, 0x0000000080080000, 0x0000000080082000, 0x8008000000002000,
      0x0000002080080000, 0x8008002000000000, 0x8008002000002000, 0x0000000080082000,
      0x8008000000000000, 0x0000002080082000, 0x8008002080080000, 0x0000000000000000,
      0x0000000000002000, 0x8008000080082000, 0x0000002000000000, 0x8008002080080000, ],
];

#[allow(non_snake_case)]
pub fn des_cipher(input: u64, keyword: u64, salt: u32, mut num_iter: u32) -> u64 {
    let salt = ((salt << 26) & 0xFC000000) | ((salt << 12) & 0xFC0000) | ((salt >> 2) & 0xFC00) | ((salt >> 16) & 0xFC);
    let mut L = input;
    let mut R = L;
    L &= 0x5555555555555555;
    R = (R & 0xAAAAAAAA00000000) | ((R >> 1) & 0x0000000055555555);
    L = (((L << 1) | (L << 32)) & 0xFFFFFFFF00000000) | ((R | (R >> 32)) & 0x00000000FFFFFFFF);

    fn perm3264(mut c: u32, p: &[[u64; 16]; 8]) -> u64 {
	let mut out = 0u64;
	let mut i = 3;
	while i >= 0 {
	    let t = (c & 0xFF) as u32;
	    c >>= 8;
	    let tp = p[(i << 1) as usize][(t & 0xF) as usize];
	    out |= tp;
	    let tp = p[(i << 1) as usize + 1][(t >> 4) as usize];
	    out |= tp;
	    i -= 1;
	}
	out
    }
    R = perm3264((L & 0xFFFFFFFF) as u32, &IE3264);
    L = perm3264((L >> 32) as u32, &IE3264);

    fn des_setkey(keyword: u64) -> [u64; 16] {
	let mut KS = [0u64; 16];
	let mut K = perm6464(keyword, &PC1ROT);
	KS[0] = K & !0x0303030300000000;
	for i in 1..16 {
	    K = perm6464(K, &PC2ROT[Rotates[i] - 1]);
	    KS[i] = K & !0x0303030300000000;
	}
	KS
    }
    let KS = des_setkey(keyword);

    fn perm6464(mut c: u64, p: &[[u64; 16]; 16]) -> u64 {
	let mut out = 0u64;
	let mut i = 7;
	while i >= 0 {
	    let t = (c & 0xFF) as u32;
	    c >>= 8;
	    let tp = p[(i << 1) as usize][(t & 0xF) as usize];
	    out |= tp;
	    let tp = p[(i << 1) as usize + 1][(t >> 4) as usize];
	    out |= tp;
	    i -= 1;
	}
	out
    }

    while num_iter > 0 {
	num_iter -= 1;
	for loop_count in 0..8 {
	    let kp = KS[loop_count << 1];
	    let mut k = ((R >> 32) ^ R) & salt as u64 & 0xFFFFFFFF;
	    k |= k << 32;
	    let B = k ^ R ^ kp;
	    L ^= SPE[0][((B >> 58) & 0x3F) as usize] ^ SPE[1][((B >> 50) & 0x3F) as usize] ^
		 SPE[2][((B >> 42) & 0x3F) as usize] ^ SPE[3][((B >> 34) & 0x3F) as usize] ^
		 SPE[4][((B >> 26) & 0x3F) as usize] ^ SPE[5][((B >> 18) & 0x3F) as usize] ^
		 SPE[6][((B >> 10) & 0x3F) as usize] ^ SPE[7][((B >> 2) & 0x3F) as usize];
	    let kp = KS[(loop_count << 1) + 1];
	    k = ((L >> 32) ^ L) & salt as u64 & 0xFFFFFFFF;
	    k |= k << 32;
	    let B = k ^ L ^ kp;
	    R ^= SPE[0][((B >> 58) & 0x3F) as usize] ^ SPE[1][((B >> 50) & 0x3F) as usize] ^
		 SPE[2][((B >> 42) & 0x3F) as usize] ^ SPE[3][((B >> 34) & 0x3F) as usize] ^
		 SPE[4][((B >> 26) & 0x3F) as usize] ^ SPE[5][((B >> 18) & 0x3F) as usize] ^
		 SPE[6][((B >> 10) & 0x3F) as usize] ^ SPE[7][((B >> 2) & 0x3F) as usize];
	}
	L ^= R;
	R ^= L;
	L ^= R;
    }
    L = (((L >> 35) & 0x0F0F0F0F) | (((L & 0xFFFFFFFF) << 1) & 0xF0F0F0F0)) << 32
      | (((R >> 35) & 0x0F0F0F0F) | (((R & 0xFFFFFFFF) << 1) & 0xF0F0F0F0));
    perm6464(L, &CF6464)
}

use std::iter;
use crate::enc_dec::{crypt_hash64_encode,decode_val,encode_val};

fn secret_to_key(key: &[u8]) -> u64 {
    key.iter().chain(iter::repeat(&0u8)).take(8).fold(0u64, |kw, b| (kw << 8) | (b << 1) as u64)
}

fn do_0_crypt(keyword: u64, salt: u32, rounds: u32) -> String {
    let mut result_block = des_cipher(0, keyword, salt, rounds);
    let mut result_array = [0u8; 8];
    for i in 0..8 {
	result_array[7-i] = (result_block & 0xFF) as u8;
	result_block >>= 8;
    }
    crypt_hash64_encode(&result_array)
}

use super::unix_crypt;
use super::Result;

const DES_ROUNDS: u32 = 25;

pub fn unix_crypt(key: &[u8], salt: &str) -> Result<String> {
    let keyword = secret_to_key(key);
    let salt_val = decode_val(salt, unix_crypt::SALT_LEN)?;
    Ok(format!("{}{}", encode_val(salt_val, unix_crypt::SALT_LEN), do_0_crypt(keyword, salt_val, DES_ROUNDS)))
}

use super::bsdi_crypt;
use std::cmp::min;

pub fn bsdi_crypt(key: &[u8], salt: &str, rounds: u32) -> Result<String> {
    let keylen = key.len();
    let mut keyword = secret_to_key(&key[..min(keylen, 8)]);
    let mut idx = 8;
    while idx < keylen {
	let next_keyword = secret_to_key(&key[idx..min(keylen, idx + 8)]);
	keyword = des_cipher(keyword, keyword, 0, 1) ^ next_keyword;
	idx += 8;
    }
    let salt_val = decode_val(salt, bsdi_crypt::SALT_LEN)?;
    Ok(format!("_{}{}{}", encode_val(rounds as u32, bsdi_crypt::SALT_LEN),
	encode_val(salt_val, bsdi_crypt::SALT_LEN), do_0_crypt(keyword, salt_val, rounds)))
}
