// Copyright (c) 2017 Martijn Rijkeboer <mrr@sru-systems.com>
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

/// Minimum number of lanes (degree of parallelism).
pub const MIN_LANES: u32 = 1;

/// Maximum number of lanes (degree of parallelism).
pub const MAX_LANES: u32 = 0x00FF_FFFF;

/// Number of synchronization points between lanes per pass.
pub const SYNC_POINTS: u32 = 4;

/// Minimum digest size in bytes.
pub const MIN_HASH_LENGTH: u32 = 4;

/// Maximum digest size in bytes.
pub const MAX_HASH_LENGTH: u32 = 0xFFFF_FFFF;

/// Minimum number of memory blocks (each of BLOCK_SIZE bytes).
pub const MIN_MEMORY: u32 = 2 * SYNC_POINTS;

/// Maximum number of memory blocks (each of BLOCK_SIZE bytes).
#[cfg(target_pointer_width = "32")]
pub const MAX_MEMORY: u32 = 0x200000;
#[cfg(target_pointer_width = "64")]
pub const MAX_MEMORY: u32 = 0xFFFF_FFFF;

/// Minimum number of passes
pub const MIN_TIME: u32 = 1;

/// Maximum number of passes.
pub const MAX_TIME: u32 = 0xFFFF_FFFF;

/// Minimum password length in bytes.
pub const MIN_PWD_LENGTH: u32 = 0;

/// Maximum password length in bytes.
pub const MAX_PWD_LENGTH: u32 = 0xFFFF_FFFF;

/// Minimum associated data length in bytes.
pub const MIN_AD_LENGTH: u32 = 0;

/// Maximum associated data length in bytes.
pub const MAX_AD_LENGTH: u32 = 0xFFFF_FFFF;

/// Minimum salt length in bytes.
pub const MIN_SALT_LENGTH: u32 = 8;

/// Maximum salt length in bytes.
pub const MAX_SALT_LENGTH: u32 = 0xFFFF_FFFF;

/// Minimum key length in bytes.
pub const MIN_SECRET_LENGTH: u32 = 0;

/// Maximum key length in bytes.
pub const MAX_SECRET_LENGTH: u32 = 0xFFFF_FFFF;

/// Memory block size in bytes.
pub const BLOCK_SIZE: usize = 1024;

/// Number of quad words in a block.
pub const QWORDS_IN_BLOCK: usize = BLOCK_SIZE / 8;

/// Number of pseudo-random values generated by one call to Blake in Argon2i
/// to generate reference block positions.
pub const ADDRESSES_IN_BLOCK: u32 = 128;

/// Pre-hashing digest length.
pub const PREHASH_DIGEST_LENGTH: usize = 64;

/// Pre-hashing digest length with extension.
pub const PREHASH_SEED_LENGTH: usize = 72;

/// Blake2b output length in bytes.
pub const BLAKE2B_OUT_LENGTH: usize = 64;
