static const byte kEoB2ChargenStartLevelsDOS[60] = {
	0x07, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x01,
	0x06, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x01,
	0x07, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x01,
	0x06, 0x06, 0x00, 0x02, 0x06, 0x06, 0x00, 0x02,
	0x06, 0x05, 0x00, 0x02, 0x05, 0x05, 0x06, 0x03,
	0x06, 0x05, 0x00, 0x02, 0x06, 0x06, 0x00, 0x02,
	0x05, 0x05, 0x05, 0x03, 0x05, 0x06, 0x00, 0x02,
	0x06, 0x05, 0x00, 0x02
};

static const ByteProvider kEoB2ChargenStartLevelsDOSProvider = { ARRAYSIZE(kEoB2ChargenStartLevelsDOS), kEoB2ChargenStartLevelsDOS };

static const byte kEoB2ChargenClassMinStatsDOS[90] = {
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00,
	0x0E, 0x0D, 0x0E, 0x00, 0x0C, 0x00, 0x0D, 0x00,
	0x09, 0x11, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09,
	0x00, 0x09, 0x00, 0x00, 0x00, 0x09, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x0D, 0x00,
	0x0E, 0x0D, 0x0E, 0x00, 0x00, 0x09, 0x09, 0x00,
	0x00, 0x00
};

static const ByteProvider kEoB2ChargenClassMinStatsDOSProvider = { ARRAYSIZE(kEoB2ChargenClassMinStatsDOS), kEoB2ChargenClassMinStatsDOS };

static const byte kEoB2ChargenRaceMinStatsDOS[36] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08,
	0x03, 0x07, 0x06, 0x08, 0x03, 0x04, 0x03, 0x06,
	0x06, 0x03, 0x08, 0x03, 0x03, 0x03, 0x0C, 0x02,
	0x06, 0x07, 0x02, 0x03, 0x08, 0x03, 0x07, 0x06,
	0x03, 0x08, 0x0A, 0x06
};

static const ByteProvider kEoB2ChargenRaceMinStatsDOSProvider = { ARRAYSIZE(kEoB2ChargenRaceMinStatsDOS), kEoB2ChargenRaceMinStatsDOS };

static const uint16 kEoB2ChargenRaceMaxStatsDOS[36] = {
	0x6412, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x6412, 0x0012,
	0x0012, 0x0013, 0x0011, 0x0012, 0x6412, 0x0012, 0x0012, 0x0012,
	0x0012, 0x0012, 0x6412, 0x0012, 0x0012, 0x0011, 0x0013, 0x0010,
	0x6412, 0x0013, 0x0011, 0x0012, 0x0012, 0x0012, 0x0011, 0x0012,
	0x0011, 0x0013, 0x0012, 0x0012
};

static const Uint16Provider kEoB2ChargenRaceMaxStatsDOSProvider = { ARRAYSIZE(kEoB2ChargenRaceMaxStatsDOS), kEoB2ChargenRaceMaxStatsDOS };

static const byte kEoB2SaveThrowTable1DOS[50] = {
	0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08, 0x07, 0x05,
	0x04, 0x03, 0x12, 0x10, 0x0F, 0x0D, 0x0C, 0x0A,
	0x09, 0x07, 0x06, 0x05, 0x11, 0x0F, 0x0E, 0x0C,
	0x0B, 0x09, 0x08, 0x06, 0x05, 0x04, 0x14, 0x11,
	0x10, 0x0D, 0x0C, 0x09, 0x08, 0x05, 0x04, 0x04,
	0x13, 0x11, 0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08,
	0x07, 0x06
};

static const ByteProvider kEoB2SaveThrowTable1DOSProvider = { ARRAYSIZE(kEoB2SaveThrowTable1DOS), kEoB2SaveThrowTable1DOS };

static const byte kEoB2SaveThrowTable2DOS[25] = {
	0x0E, 0x0D, 0x0B, 0x0A, 0x08, 0x0B, 0x09, 0x07,
	0x05, 0x03, 0x0D, 0x0B, 0x09, 0x07, 0x05, 0x0F,
	0x0D, 0x0B, 0x09, 0x07, 0x0C, 0x0A, 0x08, 0x06,
	0x04
};

static const ByteProvider kEoB2SaveThrowTable2DOSProvider = { ARRAYSIZE(kEoB2SaveThrowTable2DOS), kEoB2SaveThrowTable2DOS };

static const byte kEoB2SaveThrowTable3DOS[35] = {
	0x0A, 0x09, 0x07, 0x06, 0x05, 0x04, 0x02, 0x0E,
	0x0D, 0x0B, 0x0A, 0x09, 0x08, 0x06, 0x0D, 0x0C,
	0x0A, 0x09, 0x08, 0x07, 0x05, 0x10, 0x0F, 0x0D,
	0x0C, 0x0B, 0x0A, 0x08, 0x0F, 0x0E, 0x0C, 0x0B,
	0x0A, 0x09, 0x07
};

static const ByteProvider kEoB2SaveThrowTable3DOSProvider = { ARRAYSIZE(kEoB2SaveThrowTable3DOS), kEoB2SaveThrowTable3DOS };

static const byte kEoB2SaveThrowTable4DOS[30] = {
	0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x0E, 0x0C,
	0x0A, 0x08, 0x06, 0x07, 0x0C, 0x0B, 0x0A, 0x09,
	0x08, 0x04, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B,
	0x0F, 0x0D, 0x0B, 0x09, 0x07, 0x05
};

static const ByteProvider kEoB2SaveThrowTable4DOSProvider = { ARRAYSIZE(kEoB2SaveThrowTable4DOS), kEoB2SaveThrowTable4DOS };

static const byte kEoB2SaveThrwLvlIndexDOS[6] = {
	0x11, 0x15, 0x13, 0x15, 0x11, 0x11
};

static const ByteProvider kEoB2SaveThrwLvlIndexDOSProvider = { ARRAYSIZE(kEoB2SaveThrwLvlIndexDOS), kEoB2SaveThrwLvlIndexDOS };

static const byte kEoB2SaveThrwModDivDOS[6] = {
	0x02, 0x05, 0x03, 0x04, 0x02, 0x02
};

static const ByteProvider kEoB2SaveThrwModDivDOSProvider = { ARRAYSIZE(kEoB2SaveThrwModDivDOS), kEoB2SaveThrwModDivDOS };

static const byte kEoB2SaveThrwModExtDOS[6] = {
	0x0A, 0x05, 0x07, 0x06, 0x0A, 0x0A
};

static const ByteProvider kEoB2SaveThrwModExtDOSProvider = { ARRAYSIZE(kEoB2SaveThrwModExtDOS), kEoB2SaveThrwModExtDOS };

static const char *const kEoB2EnchantedStringDOS[1] = {
	"+%d %s"
};

static const StringListProvider kEoB2EnchantedStringDOSProvider = { ARRAYSIZE(kEoB2EnchantedStringDOS), kEoB2EnchantedStringDOS };

static const char *const kEoB2MenuStringsSpellNoDOS[3] = {
	"6",
	"7",
	"8"
};

static const StringListProvider kEoB2MenuStringsSpellNoDOSProvider = { ARRAYSIZE(kEoB2MenuStringsSpellNoDOS), kEoB2MenuStringsSpellNoDOS };

static const byte kEoB2SpellLevelsMageDOS[35] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x05, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x08,
	0x00, 0x01, 0x01
};

static const ByteProvider kEoB2SpellLevelsMageDOSProvider = { ARRAYSIZE(kEoB2SpellLevelsMageDOS), kEoB2SpellLevelsMageDOS };

static const byte kEoB2SpellLevelsClericDOS[29] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x06, 0x06, 0x08, 0x08, 0x00
};

static const ByteProvider kEoB2SpellLevelsClericDOSProvider = { ARRAYSIZE(kEoB2SpellLevelsClericDOS), kEoB2SpellLevelsClericDOS };

static const byte kEoB2NumSpellsClericDOS[136] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00,
	0x05, 0x04, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00,
	0x06, 0x05, 0x05, 0x03, 0x02, 0x02, 0x00, 0x00,
	0x06, 0x06, 0x06, 0x04, 0x02, 0x02, 0x00, 0x00,
	0x06, 0x06, 0x06, 0x05, 0x03, 0x02, 0x01, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x02, 0x01, 0x00,
	0x07, 0x07, 0x07, 0x06, 0x04, 0x03, 0x01, 0x00,
	0x07, 0x07, 0x07, 0x07, 0x05, 0x03, 0x02, 0x00
};

static const ByteProvider kEoB2NumSpellsClericDOSProvider = { ARRAYSIZE(kEoB2NumSpellsClericDOS), kEoB2NumSpellsClericDOS };

static const byte kEoB2NumSpellsWisAdjDOS[64] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2NumSpellsWisAdjDOSProvider = { ARRAYSIZE(kEoB2NumSpellsWisAdjDOS), kEoB2NumSpellsWisAdjDOS };

static const byte kEoB2NumSpellsPalDOS[136] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2NumSpellsPalDOSProvider = { ARRAYSIZE(kEoB2NumSpellsPalDOS), kEoB2NumSpellsPalDOS };

static const byte kEoB2NumSpellsMageDOS[276] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x00, 0x00,
	0x05, 0x05, 0x05, 0x04, 0x04, 0x02, 0x00, 0x00,
	0x05, 0x05, 0x05, 0x04, 0x04, 0x02, 0x01, 0x00,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x01, 0x00,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x02, 0x01,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x03, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2NumSpellsMageDOSProvider = { ARRAYSIZE(kEoB2NumSpellsMageDOS), kEoB2NumSpellsMageDOS };

static const uint32 kEoB2ExperienceTable0DOS[14] = {
	0x00000000, 0x000007D0, 0x00000FA0, 0x00001F40, 0x00003E80, 0x00007D00, 0x0000FA00, 0x0001E848,
	0x0003D090, 0x0007A120, 0x000B71B0, 0x000F4240, 0x001312D0, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable0DOSProvider = { ARRAYSIZE(kEoB2ExperienceTable0DOS), kEoB2ExperienceTable0DOS };

static const uint32 kEoB2ExperienceTable1DOS[14] = {
	0x00000000, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x0000EA60, 0x00015F90,
	0x00020F58, 0x0003D090, 0x0005B8D8, 0x000B71B0, 0x00112A88, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable1DOSProvider = { ARRAYSIZE(kEoB2ExperienceTable1DOS), kEoB2ExperienceTable1DOS };

static const uint32 kEoB2ExperienceTable2DOS[14] = {
	0x00000000, 0x000005DC, 0x00000BB8, 0x00001770, 0x000032C8, 0x00006B6C, 0x0000D6D8, 0x0001ADB0,
	0x00036EE8, 0x0006DDD0, 0x000A4CB8, 0x000DBBA0, 0x00112A88, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable2DOSProvider = { ARRAYSIZE(kEoB2ExperienceTable2DOS), kEoB2ExperienceTable2DOS };

static const uint32 kEoB2ExperienceTable3DOS[14] = {
	0x00000000, 0x000004E2, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x00011170,
	0x0001ADB0, 0x00027100, 0x00035B60, 0x0006B6C0, 0x000A1220, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable3DOSProvider = { ARRAYSIZE(kEoB2ExperienceTable3DOS), kEoB2ExperienceTable3DOS };

static const uint32 kEoB2ExperienceTable4DOS[14] = {
	0x00000000, 0x000008CA, 0x00001194, 0x00002328, 0x00004650, 0x00008CA0, 0x000124F8, 0x000249F0,
	0x000493E0, 0x000927C0, 0x000DBBA0, 0x00124F80, 0x0016E360, 0xFFFFFFFF
};

static const Uint32Provider kEoB2ExperienceTable4DOSProvider = { ARRAYSIZE(kEoB2ExperienceTable4DOS), kEoB2ExperienceTable4DOS };

static const byte kEoB2ExpObjectTlModeDOS[18] = {
	0x00, 0x00, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x02, 0x00
};

static const ByteProvider kEoB2ExpObjectTlModeDOSProvider = { ARRAYSIZE(kEoB2ExpObjectTlModeDOS), kEoB2ExpObjectTlModeDOS };

static const byte kEoB2ExpObjectTblIndexDOS[14] = {
	0x02, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2ExpObjectTblIndexDOSProvider = { ARRAYSIZE(kEoB2ExpObjectTblIndexDOS), kEoB2ExpObjectTblIndexDOS };

static const byte kEoB2ExpObjectShpStartDOS[4] = {
	0x07, 0x0C, 0x0F, 0x12
};

static const ByteProvider kEoB2ExpObjectShpStartDOSProvider = { ARRAYSIZE(kEoB2ExpObjectShpStartDOS), kEoB2ExpObjectShpStartDOS };

static const byte kEoB2ExpObjectTbl1DOS[13] = {
	0x0F, 0x05, 0x0F, 0x05, 0x06, 0x05, 0x06, 0x08,
	0x06, 0x08, 0x06, 0x08, 0x00
};

static const ByteProvider kEoB2ExpObjectTbl1DOSProvider = { ARRAYSIZE(kEoB2ExpObjectTbl1DOS), kEoB2ExpObjectTbl1DOS };

static const byte kEoB2ExpObjectTbl2DOS[10] = {
	0x0F, 0x09, 0x0F, 0x09, 0x02, 0x0A, 0x0B, 0x0A,
	0x0B, 0x00
};

static const ByteProvider kEoB2ExpObjectTbl2DOSProvider = { ARRAYSIZE(kEoB2ExpObjectTbl2DOS), kEoB2ExpObjectTbl2DOS };

static const byte kEoB2ExpObjectTbl3DOS[11] = {
	0x05, 0x03, 0x05, 0x03, 0x03, 0x03, 0x03, 0x0B,
	0x03, 0x0B, 0x00
};

static const ByteProvider kEoB2ExpObjectTbl3DOSProvider = { ARRAYSIZE(kEoB2ExpObjectTbl3DOS), kEoB2ExpObjectTbl3DOS };

static const byte kEoB2ExpObjectYDOS[4] = {
	0x77, 0x67, 0x4F, 0x3F
};

static const ByteProvider kEoB2ExpObjectYDOSProvider = { ARRAYSIZE(kEoB2ExpObjectYDOS), kEoB2ExpObjectYDOS };

static const byte kEoB2SparkDefStepsDOS[8] = {
	0x40, 0x90, 0xE4, 0xB9, 0x6E, 0x1B, 0x06, 0x01
};

static const ByteProvider kEoB2SparkDefStepsDOSProvider = { ARRAYSIZE(kEoB2SparkDefStepsDOS), kEoB2SparkDefStepsDOS };

static const byte kEoB2SparkDefSubStepsDOS[4] = {
	0xC0, 0x30, 0x0C, 0x03
};

static const ByteProvider kEoB2SparkDefSubStepsDOSProvider = { ARRAYSIZE(kEoB2SparkDefSubStepsDOS), kEoB2SparkDefSubStepsDOS };

static const byte kEoB2SparkDefShiftDOS[4] = {
	0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB2SparkDefShiftDOSProvider = { ARRAYSIZE(kEoB2SparkDefShiftDOS), kEoB2SparkDefShiftDOS };

static const byte kEoB2SparkDefAddDOS[8] = {
	0x08, 0x06, 0x1C, 0x14, 0x0D, 0x18, 0x0D, 0x0F
};

static const ByteProvider kEoB2SparkDefAddDOSProvider = { ARRAYSIZE(kEoB2SparkDefAddDOS), kEoB2SparkDefAddDOS };

static const byte kEoB2SparkDefXDOS[6] = {
	0x17, 0x20, 0x17, 0x20, 0x17, 0x20
};

static const ByteProvider kEoB2SparkDefXDOSProvider = { ARRAYSIZE(kEoB2SparkDefXDOS), kEoB2SparkDefXDOS };

static const byte kEoB2SparkDefYDOS[6] = {
	0x02, 0x02, 0x34, 0x34, 0x66, 0x66
};

static const ByteProvider kEoB2SparkDefYDOSProvider = { ARRAYSIZE(kEoB2SparkDefYDOS), kEoB2SparkDefYDOS };

static const uint32 kEoB2SparkOfFlags1DOS[11] = {
	0x40000000, 0x95000000, 0xEA550000, 0xBFAA5400, 0x6AFFA954, 0x15AAFEA9, 0x0055ABFE, 0x000056AB,
	0x00000156, 0x00000001, 0x00000000
};

static const Uint32Provider kEoB2SparkOfFlags1DOSProvider = { ARRAYSIZE(kEoB2SparkOfFlags1DOS), kEoB2SparkOfFlags1DOS };

static const uint32 kEoB2SparkOfFlags2DOS[16] = {
	0xC0000000, 0x30000000, 0x0C000000, 0x03000000, 0x00C00000, 0x00300000, 0x000C0000, 0x00030000,
	0x0000C000, 0x00003000, 0x00000C00, 0x00000300, 0x000000C0, 0x00000030, 0x0000000C, 0x00000003
};

static const Uint32Provider kEoB2SparkOfFlags2DOSProvider = { ARRAYSIZE(kEoB2SparkOfFlags2DOS), kEoB2SparkOfFlags2DOS };

static const byte kEoB2SparkOfShiftDOS[16] = {
	0x1E, 0x1C, 0x1A, 0x18, 0x16, 0x14, 0x12, 0x10,
	0x0E, 0x0C, 0x0A, 0x08, 0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB2SparkOfShiftDOSProvider = { ARRAYSIZE(kEoB2SparkOfShiftDOS), kEoB2SparkOfShiftDOS };

static const byte kEoB2SparkOfXDOS[16] = {
	0x50, 0x70, 0x30, 0x68, 0x20, 0x60, 0x38, 0x78,
	0x80, 0x48, 0x58, 0x28, 0x60, 0x40, 0x70, 0x48
};

static const ByteProvider kEoB2SparkOfXDOSProvider = { ARRAYSIZE(kEoB2SparkOfXDOS), kEoB2SparkOfXDOS };

static const byte kEoB2SparkOfYDOS[16] = {
	0x31, 0x2B, 0x48, 0x17, 0x16, 0x48, 0x35, 0x1B,
	0x43, 0x2E, 0x24, 0x28, 0x38, 0x1C, 0x16, 0x44
};

static const ByteProvider kEoB2SparkOfYDOSProvider = { ARRAYSIZE(kEoB2SparkOfYDOS), kEoB2SparkOfYDOS };

static const byte kEoB2SpellPropertiesDOS[1750] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFE, 0x2B, 0x16, 0x2B, 0x60, 0x00, 0xA7,
	0x13, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x5C, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x2C, 0x16, 0x2B, 0xC3, 0x00,
	0xA7, 0x13, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00,
	0x00, 0x21, 0x00, 0x12, 0x2C, 0x16, 0x2B, 0x9D,
	0x01, 0xA7, 0x13, 0x4C, 0x00, 0x00, 0x00, 0x95,
	0x29, 0xBB, 0x01, 0xA7, 0x13, 0x5F, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1F, 0x2C, 0x16, 0x2B,
	0xD9, 0x01, 0xA7, 0x13, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0xFA, 0x01, 0xA7, 0x13, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x2D, 0x2C, 0x16,
	0x2B, 0x00, 0x00, 0x00, 0x00, 0x8B, 0x00, 0x00,
	0x00, 0x96, 0x29, 0x00, 0x00, 0x00, 0x00, 0x5C,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x2C,
	0x16, 0x2B, 0x2D, 0x02, 0xA7, 0x13, 0x88, 0x04,
	0x00, 0x00, 0x97, 0x29, 0xE4, 0x02, 0xA7, 0x13,
	0x58, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x43,
	0x2C, 0x16, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x89,
	0x00, 0x00, 0x00, 0x98, 0x29, 0x00, 0x00, 0x00,
	0x00, 0x4B, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x2C, 0x16, 0x2B, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x00, 0x00, 0x00, 0x9A, 0x29, 0x00, 0x00,
	0x00, 0x00, 0x5F, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x5C, 0x2C, 0x16, 0x2B, 0x2C, 0x00, 0xA7,
	0x13, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x14, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6E, 0x2C, 0x16, 0x2B, 0x00, 0x00,
	0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x5E, 0x40, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7B, 0x2C, 0x16, 0x2B, 0x2B,
	0x03, 0xA7, 0x13, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x4D, 0x03, 0xA7, 0x13, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x11, 0x00, 0x8D, 0x2C, 0x16, 0x2B,
	0x02, 0x00, 0xA7, 0x13, 0x00, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x9A, 0x2C, 0x16,
	0x2B, 0x82, 0x03, 0xA7, 0x13, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0xA4, 0x03, 0xA7, 0x13, 0x63,
	0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0xA3, 0x2C,
	0x16, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x48, 0x02,
	0x00, 0x00, 0x99, 0x29, 0x00, 0x00, 0x00, 0x00,
	0x64, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xA9,
	0x2C, 0x16, 0x2B, 0xD3, 0x03, 0xA7, 0x13, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0xF5, 0x03, 0xA7,
	0x13, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xB5, 0x2C, 0x16, 0x2B, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x5E, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xCD, 0x2C, 0x16, 0x2B, 0xFA, 0x04, 0xA7,
	0x13, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x1C,
	0x05, 0xA7, 0x13, 0x47, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x00, 0xDC, 0x2C, 0x16, 0x2B, 0x4B, 0x05,
	0xA7, 0x13, 0x88, 0x04, 0x00, 0x00, 0x9B, 0x29,
	0x04, 0x06, 0xA7, 0x13, 0x66, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0xEB, 0x2C, 0x16, 0x2B, 0x2B,
	0x06, 0xA7, 0x13, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xF0, 0x2C, 0x16, 0x2B,
	0x89, 0x06, 0xA7, 0x13, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0xAB, 0x06, 0xA7, 0x13, 0x59, 0x00,
	0x00, 0x00, 0x00, 0x41, 0x00, 0xFA, 0x2C, 0x16,
	0x2B, 0x00, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00,
	0x00, 0x9C, 0x29, 0x00, 0x00, 0x00, 0x00, 0x08,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x2D,
	0x16, 0x2B, 0x3C, 0x07, 0xA7, 0x13, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D,
	0x2D, 0x16, 0x2B, 0x9F, 0x07, 0xA7, 0x13, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x76, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00,
	0x2A, 0x2D, 0x16, 0x2B, 0x94, 0x08, 0xA7, 0x13,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xB6, 0x08,
	0xA7, 0x13, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x37, 0x2D, 0x16, 0x2B, 0xD0, 0x09, 0xA7,
	0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4A, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x45, 0x2D, 0x16, 0x2B, 0x25, 0x0B,
	0xA7, 0x13, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x52, 0x2D, 0x16, 0x2B, 0x89,
	0x0B, 0xA7, 0x13, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x61, 0x2D, 0x16, 0x2B,
	0xF1, 0x0B, 0xA7, 0x13, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x2D, 0x16,
	0x2B, 0x0D, 0x0C, 0xA7, 0x13, 0x4C, 0x00, 0x00,
	0x00, 0x9D, 0x29, 0x1C, 0x0C, 0xA7, 0x13, 0x49,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x2D,
	0x16, 0x2B, 0x2B, 0x0C, 0xA7, 0x13, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x8C,
	0x2D, 0x16, 0x2B, 0x98, 0x0C, 0xA7, 0x13, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x9C, 0x2D, 0x16, 0x2B, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xB2, 0x2D, 0x16, 0x2B, 0x00, 0x00,
	0x00, 0x00, 0x5C, 0x00, 0x00, 0x00, 0x9E, 0x29,
	0x00, 0x00, 0x00, 0x00, 0x5B, 0x00, 0x04, 0x00,
	0x00, 0x00, 0x00, 0xB8, 0x2D, 0x16, 0x2B, 0xDE,
	0x0C, 0xA7, 0x13, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6B, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0xCB, 0x2D, 0x16, 0x2B,
	0xF6, 0x0C, 0xA7, 0x13, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xDD, 0x2D, 0x16,
	0x2B, 0x9D, 0x01, 0xA7, 0x13, 0x4C, 0x00, 0x00,
	0x00, 0x95, 0x29, 0xBB, 0x01, 0xA7, 0x13, 0x5F,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEA, 0x2D,
	0x16, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x29, 0x00,
	0x00, 0x00, 0x9F, 0x29, 0x00, 0x00, 0x00, 0x00,
	0x6E, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0xFF,
	0x2D, 0x16, 0x2B, 0x1A, 0x0D, 0xA7, 0x13, 0x39,
	0x00, 0x00, 0x00, 0xA0, 0x29, 0xC9, 0x0D, 0xA7,
	0x13, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x2E, 0x16, 0x2B, 0xEF, 0x0D, 0xA7, 0x13,
	0x08, 0x24, 0x00, 0x00, 0xA1, 0x29, 0xE4, 0x02,
	0xA7, 0x13, 0x63, 0x00, 0x00, 0x00, 0x00, 0x21,
	0x00, 0x0F, 0x2E, 0x16, 0x2B, 0xD3, 0x03, 0xA7,
	0x13, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xF5,
	0x03, 0xA7, 0x13, 0x65, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1B, 0x2E, 0x16, 0x2B, 0x99, 0x0E,
	0xA7, 0x13, 0x28, 0x00, 0x00, 0x00, 0xA2, 0x29,
	0xF2, 0x0E, 0xA7, 0x13, 0x6F, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x27, 0x2E, 0x16, 0x2B, 0x08,
	0x0F, 0xA7, 0x13, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x33, 0x2E, 0x16, 0x2B,
	0x02, 0x00, 0xA7, 0x13, 0x00, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x2E, 0x16,
	0x2B, 0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00,
	0x00, 0xA3, 0x29, 0x00, 0x00, 0x00, 0x00, 0x71,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x51, 0x2E,
	0x16, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x00,
	0x00, 0x00, 0xA4, 0x29, 0x00, 0x00, 0x00, 0x00,
	0x5B, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x58,
	0x2E, 0x16, 0x2B, 0x38, 0x0F, 0xA7, 0x13, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x69, 0x2E, 0x16, 0x2B, 0x95, 0x0F, 0xA7, 0x13,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x7E, 0x2E, 0x16, 0x2B, 0x71, 0x0F, 0xA7,
	0x13, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x92, 0x2E, 0x16, 0x2B, 0xAE, 0x0F,
	0xA7, 0x13, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xA4, 0x2E, 0x16, 0x2B, 0x00,
	0x00, 0x00, 0x00, 0x48, 0x02, 0x00, 0x00, 0x9F,
	0x29, 0x00, 0x00, 0x00, 0x00, 0x6E, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0xC4, 0x2E, 0x16, 0x2B,
	0xD1, 0x0F, 0xA7, 0x13, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0xDA, 0x2E, 0x16,
	0x2B, 0xEA, 0x0F, 0xA7, 0x13, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF, 0x2E,
	0x16, 0x2B, 0x0E, 0x10, 0xA7, 0x13, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0xA7, 0x13,
	0x62, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0xFC,
	0x2E, 0x16, 0x2B, 0x4F, 0x10, 0xA7, 0x13, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x2F, 0x16, 0x2B, 0x2B, 0x0C, 0xA7, 0x13,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x13, 0x2F, 0x16, 0x2B, 0x0D, 0x0C, 0xA7,
	0x13, 0x4C, 0x00, 0x00, 0x00, 0x9D, 0x29, 0x1C,
	0x0C, 0xA7, 0x13, 0x49, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x1F, 0x2F, 0x16, 0x2B, 0x84, 0x10,
	0xA7, 0x13, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x24, 0x2F, 0x16, 0x2B, 0x97,
	0x10, 0xA7, 0x13, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x29, 0x2F, 0x16, 0x2B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x2F, 0x16,
	0x2B, 0xA8, 0x13, 0xA7, 0x13, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x2F,
	0x16, 0x2B, 0xE6, 0x10, 0xA7, 0x13, 0x00, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F,
	0x2F, 0x16, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xCD, 0x13, 0xA7,
	0x13, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x2F, 0x16, 0x2B, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x00, 0x00, 0x00, 0xA5, 0x29, 0x00, 0x00,
	0x00, 0x00, 0x5B, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x5F, 0x2F, 0x16, 0x2B, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D,
	0x14, 0xA7, 0x13, 0x62, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x2F, 0x16, 0x2B, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6A, 0x12, 0xA7, 0x13, 0x65, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x61, 0x2F, 0x16, 0x2B, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF6, 0x11, 0xA7, 0x13, 0x65, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x62, 0x2F, 0x16, 0x2B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xE1, 0x12, 0xA7, 0x13, 0x65, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x2F, 0x16,
	0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x43, 0x13, 0xA7, 0x13, 0x65,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2SpellPropertiesDOSProvider = { ARRAYSIZE(kEoB2SpellPropertiesDOS), kEoB2SpellPropertiesDOS };

static const byte kEoB2MagicFlightPropsDOS[56] = {
	0x04, 0xFF, 0x41, 0x0C, 0x0B, 0xFF, 0x04, 0x06,
	0x0D, 0xFF, 0x7A, 0x09, 0x0F, 0xFF, 0x4A, 0x08,
	0x11, 0x06, 0x38, 0x0A, 0x14, 0x06, 0x7A, 0x0B,
	0x18, 0xFF, 0x4A, 0x08, 0x36, 0xFF, 0x4B, 0x09,
	0x3F, 0xFF, 0x4B, 0x09, 0x41, 0x06, 0x4B, 0x09,
	0x42, 0x06, 0x4B, 0x08, 0x43, 0x06, 0x4B, 0x08,
	0x44, 0x06, 0x4B, 0x08, 0x45, 0x06, 0x4B, 0x08
};

static const ByteProvider kEoB2MagicFlightPropsDOSProvider = { ARRAYSIZE(kEoB2MagicFlightPropsDOS), kEoB2MagicFlightPropsDOS };

static const byte kEoB2TurnUndeadEffectDOS[140] = {
	0x0A, 0x07, 0x04, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0D, 0x0A,
	0x07, 0x04, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x10, 0x0D, 0x0A, 0x07,
	0x04, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x13, 0x10, 0x0D, 0x0A, 0x07, 0x04,
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x14, 0x13, 0x10, 0x0D, 0x0A, 0x07, 0x04, 0x00,
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x63, 0x14,
	0x13, 0x10, 0x0D, 0x0A, 0x07, 0x04, 0x00, 0x00,
	0x00, 0xFF, 0xFF, 0x00, 0x63, 0x63, 0x14, 0x13,
	0x10, 0x0D, 0x0A, 0x07, 0x04, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10,
	0x0D, 0x0A, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00,
	0x63, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0D,
	0x0A, 0x07, 0x07, 0x04, 0x04, 0x00, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0D, 0x0A,
	0x0A, 0x07, 0x07, 0x04
};

static const ByteProvider kEoB2TurnUndeadEffectDOSProvider = { ARRAYSIZE(kEoB2TurnUndeadEffectDOS), kEoB2TurnUndeadEffectDOS };

static const byte kEoB2BurningHandsDestDOS[32] = {
	0x02, 0x03, 0x04, 0x01, 0x02, 0x05, 0x00, 0x00,
	0x00, 0x02, 0x04, 0x01, 0x03, 0x05, 0x00, 0x00,
	0x00, 0x01, 0x04, 0x02, 0x03, 0x05, 0x00, 0x00,
	0x01, 0x03, 0x04, 0x00, 0x02, 0x05, 0x00, 0x00
};

static const ByteProvider kEoB2BurningHandsDestDOSProvider = { ARRAYSIZE(kEoB2BurningHandsDestDOS), kEoB2BurningHandsDestDOS };

static const byte kEoB2ConeOfColdDest1DOS[7] = {
	0xE0, 0xC0, 0xC1, 0xBF, 0xA0, 0x9F, 0xA1
};

static const ByteProvider kEoB2ConeOfColdDest1DOSProvider = { ARRAYSIZE(kEoB2ConeOfColdDest1DOS), kEoB2ConeOfColdDest1DOS };

static const byte kEoB2ConeOfColdDest2DOS[7] = {
	0x01, 0x02, 0xE2, 0x22, 0x03, 0xE3, 0x23
};

static const ByteProvider kEoB2ConeOfColdDest2DOSProvider = { ARRAYSIZE(kEoB2ConeOfColdDest2DOS), kEoB2ConeOfColdDest2DOS };

static const byte kEoB2ConeOfColdDest3DOS[7] = {
	0x20, 0x40, 0x3F, 0x41, 0x60, 0x5F, 0x61
};

static const ByteProvider kEoB2ConeOfColdDest3DOSProvider = { ARRAYSIZE(kEoB2ConeOfColdDest3DOS), kEoB2ConeOfColdDest3DOS };

static const byte kEoB2ConeOfColdDest4DOS[7] = {
	0xFF, 0xFE, 0x1E, 0xDE, 0xFD, 0x1D, 0xDD
};

static const ByteProvider kEoB2ConeOfColdDest4DOSProvider = { ARRAYSIZE(kEoB2ConeOfColdDest4DOS), kEoB2ConeOfColdDest4DOS };

static const byte kEoB2ConeOfColdGfxTblDOS[8] = {
	0x0F, 0x09, 0x0F, 0x09, 0x02, 0x0A, 0x02, 0x00
};

static const ByteProvider kEoB2ConeOfColdGfxTblDOSProvider = { ARRAYSIZE(kEoB2ConeOfColdGfxTblDOS), kEoB2ConeOfColdGfxTblDOS };

static const byte kEoB2DscDoorShapeIndexDOS[53] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01
};

static const ByteProvider kEoB2DscDoorShapeIndexDOSProvider = { ARRAYSIZE(kEoB2DscDoorShapeIndexDOS), kEoB2DscDoorShapeIndexDOS };

static const byte kEoB2WllFlagPresetDOS[25] = {
	0x07, 0x00, 0x40, 0xA8, 0x88, 0x88, 0x88, 0x9F,
	0xA8, 0x88, 0x88, 0x88, 0x9F, 0xA8, 0x88, 0x88,
	0x88, 0x9F, 0xA8, 0x88, 0x88, 0x88, 0x9F, 0x03,
	0x03
};

static const ByteProvider kEoB2WllFlagPresetDOSProvider = { ARRAYSIZE(kEoB2WllFlagPresetDOS), kEoB2WllFlagPresetDOS };

static const uint16 kEoB2DscShapeCoordsDOS[180] = {
	0xFF91, 0xFFC1, 0xFFA1, 0xFFC1, 0xFF75, 0xFFC5, 0xFF8B, 0xFFC5,
	0xFF88, 0xFFC3, 0xFFB4, 0xFFC1, 0xFFC4, 0xFFC1, 0xFFA1, 0xFFC5,
	0xFFB6, 0xFFC5, 0xFFB0, 0xFFC3, 0xFFD5, 0xFFC1, 0xFFE5, 0xFFC1,
	0xFFCB, 0xFFC5, 0xFFE1, 0xFFC5, 0xFFD8, 0xFFC3, 0xFFF8, 0xFFC1,
	0x0008, 0xFFC1, 0xFFF6, 0xFFC5, 0x000A, 0xFFC5, 0x0000, 0xFFC3,
	0x001B, 0xFFC1, 0x002B, 0xFFC1, 0x001F, 0xFFC5, 0x0035, 0xFFC5,
	0x0028, 0xFFC3, 0x003C, 0xFFC1, 0x004C, 0xFFC1, 0x004A, 0xFFC5,
	0x005F, 0xFFC5, 0x0050, 0xFFC3, 0x005F, 0xFFC1, 0x006F, 0xFFC1,
	0x0075, 0xFFC5, 0x008B, 0xFFC5, 0x0078, 0xFFC3, 0xFF8A, 0xFFCB,
	0xFFA4, 0xFFCB, 0xFF68, 0xFFD3, 0xFF88, 0xFFD3, 0xFF8A, 0xFFCE,
	0xFFBE, 0xFFCB, 0xFFD8, 0xFFCB, 0xFFAC, 0xFFD3, 0xFFCD, 0xFFD3,
	0xFFC5, 0xFFCE, 0xFFF3, 0xFFCB, 0x000D, 0xFFCB, 0xFFF0, 0xFFD3,
	0x0010, 0xFFD3, 0x0000, 0xFFCE, 0x0028, 0xFFCB, 0x0042, 0xFFCB,
	0x0033, 0xFFD3, 0x0054, 0xFFD3, 0x003B, 0xFFCE, 0x005C, 0xFFCB,
	0x0076, 0xFFCB, 0x0078, 0xFFD3, 0x0098, 0xFFD3, 0x0076, 0xFFCE,
	0xFF92, 0xFFDD, 0xFFBD, 0xFFDD, 0xFF74, 0xFFEA, 0xFFAD, 0xFFEA,
	0xFF9E, 0xFFE2, 0xFFEA, 0xFFDD, 0x0016, 0xFFDD, 0xFFE5, 0xFFEA,
	0x001B, 0xFFEA, 0x0000, 0xFFE2, 0x0043, 0xFFDD, 0x006E, 0xFFDD,
	0x0053, 0xFFEA, 0x008C, 0xFFEA, 0x0062, 0xFFE2, 0xFF80, 0xFFFC,
	0x0080, 0xFFFC, 0xFF80, 0xFFBE, 0x0080, 0xFFBE, 0x0080, 0x0000,
	0xFFDA, 0xFFFC, 0x0026, 0xFFFC, 0xFFDA, 0xFFBE, 0x0026, 0xFFBE,
	0x0000, 0x0000, 0xFF80, 0xFFFC, 0x0080, 0xFFFC, 0xFF80, 0xFFBE,
	0x0080, 0xFFBE, 0x0080, 0x0000
};

static const Uint16Provider kEoB2DscShapeCoordsDOSProvider = { ARRAYSIZE(kEoB2DscShapeCoordsDOS), kEoB2DscShapeCoordsDOS };

static const byte kEoB2DscDoorScaleOffsDOS[53] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x33, 0x34
};

static const ByteProvider kEoB2DscDoorScaleOffsDOSProvider = { ARRAYSIZE(kEoB2DscDoorScaleOffsDOS), kEoB2DscDoorScaleOffsDOS };

static const byte kEoB2DscDoorScaleMult1DOS[4] = {
	0x08, 0x0C, 0x12, 0x00
};

static const ByteProvider kEoB2DscDoorScaleMult1DOSProvider = { ARRAYSIZE(kEoB2DscDoorScaleMult1DOS), kEoB2DscDoorScaleMult1DOS };

static const byte kEoB2DscDoorScaleMult2DOS[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB2DscDoorScaleMult2DOSProvider = { ARRAYSIZE(kEoB2DscDoorScaleMult2DOS), kEoB2DscDoorScaleMult2DOS };

static const byte kEoB2DscDoorScaleMult3DOS[4] = {
	0x05, 0x08, 0x0C, 0x00
};

static const ByteProvider kEoB2DscDoorScaleMult3DOSProvider = { ARRAYSIZE(kEoB2DscDoorScaleMult3DOS), kEoB2DscDoorScaleMult3DOS };

static const byte kEoB2DscDoorType5OffsDOS[6] = {
	0x05, 0x03, 0x01, 0x05, 0x03, 0x01
};

static const ByteProvider kEoB2DscDoorType5OffsDOSProvider = { ARRAYSIZE(kEoB2DscDoorType5OffsDOS), kEoB2DscDoorType5OffsDOS };

static const byte kEoB2DscDoorY1DOS[4] = {
	0x3B, 0x47, 0x56, 0x00
};

static const ByteProvider kEoB2DscDoorY1DOSProvider = { ARRAYSIZE(kEoB2DscDoorY1DOS), kEoB2DscDoorY1DOS };

static const byte kEoB2DscDoorY2DOS[4] = {
	0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB2DscDoorY2DOSProvider = { ARRAYSIZE(kEoB2DscDoorY2DOS), kEoB2DscDoorY2DOS };

static const byte kEoB2DscDoorFrameY1DOS[4] = {
	0x1E, 0x18, 0x10, 0x00
};

static const ByteProvider kEoB2DscDoorFrameY1DOSProvider = { ARRAYSIZE(kEoB2DscDoorFrameY1DOS), kEoB2DscDoorFrameY1DOS };

static const byte kEoB2DscDoorFrameY2DOS[4] = {
	0x3B, 0x47, 0x56, 0x78
};

static const ByteProvider kEoB2DscDoorFrameY2DOSProvider = { ARRAYSIZE(kEoB2DscDoorFrameY2DOS), kEoB2DscDoorFrameY2DOS };

static const byte kEoB2DscItemPosIndexDOS[16] = {
	0x00, 0x01, 0x02, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x03, 0x02, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02
};

static const ByteProvider kEoB2DscItemPosIndexDOSProvider = { ARRAYSIZE(kEoB2DscItemPosIndexDOS), kEoB2DscItemPosIndexDOS };

static const uint16 kEoB2DscItemShpXDOS[18] = {
	0xFFC8, 0xFFF8, 0x0028, 0x0058, 0x0088, 0x00B8, 0x00E8, 0xFFB8,
	0x0008, 0x0058, 0x00A8, 0x00F8, 0xFFD8, 0x0058, 0x00D8, 0xFFA8,
	0x0058, 0x0108
};

static const Uint16Provider kEoB2DscItemShpXDOSProvider = { ARRAYSIZE(kEoB2DscItemShpXDOS), kEoB2DscItemShpXDOS };

static const byte kEoB2DscItemScaleIndexDOS[18] = {
	0xFF, 0xFF, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF,
	0x25, 0x00
};

static const ByteProvider kEoB2DscItemScaleIndexDOSProvider = { ARRAYSIZE(kEoB2DscItemScaleIndexDOS), kEoB2DscItemScaleIndexDOS };

static const byte kEoB2DscItemTileIndexDOS[18] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x09, 0xFF, 0x0B,
	0x0C, 0x0D
};

static const ByteProvider kEoB2DscItemTileIndexDOSProvider = { ARRAYSIZE(kEoB2DscItemTileIndexDOS), kEoB2DscItemTileIndexDOS };

static const byte kEoB2DscItemShapeMapDOS[113] = {
	0x00, 0x00, 0x00, 0x05, 0x01, 0x02, 0x03, 0x04,
	0x03, 0x05, 0x06, 0x06, 0x12, 0x05, 0x0F, 0x12,
	0x14, 0x08, 0x13, 0x11, 0x15, 0x18, 0x07, 0x07,
	0x07, 0x1F, 0x09, 0x23, 0x09, 0x09, 0x09, 0x09,
	0x08, 0x1C, 0x1C, 0x1A, 0x1B, 0x21, 0x1D, 0x1D,
	0x22, 0x22, 0x22, 0x00, 0x16, 0x00, 0x00, 0x17,
	0x17, 0x17, 0x17, 0x17, 0x22, 0x21, 0x19, 0x23,
	0x10, 0x1E, 0x17, 0x25, 0x17, 0x26, 0x12, 0x21,
	0x17, 0x23, 0x1C, 0x00, 0x20, 0x25, 0x12, 0x18,
	0x1F, 0x07, 0x07, 0x15, 0x15, 0x0F, 0x03, 0x09,
	0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B,
	0x1B, 0x17, 0x17, 0x16, 0x16, 0x21, 0x08, 0x25,
	0x25, 0x25, 0x25, 0x28, 0x03, 0x04, 0x21, 0x00,
	0x17, 0x00, 0x20, 0x24, 0x27, 0x27, 0x1C, 0x27,
	0x00
};

static const ByteProvider kEoB2DscItemShapeMapDOSProvider = { ARRAYSIZE(kEoB2DscItemShapeMapDOS), kEoB2DscItemShapeMapDOS };

static const byte kEoB2DscTelptrShpCoordsDOS[156] = {
	0x0C, 0x07, 0x1A, 0x01, 0x3E, 0x03, 0x0C, 0x1A,
	0x2A, 0x13, 0x40, 0x18, 0x02, 0x2D, 0x16, 0x25,
	0x28, 0x32, 0x36, 0x27, 0x0A, 0x3E, 0x16, 0x49,
	0x3E, 0x44, 0x06, 0x06, 0x2A, 0x04, 0x37, 0x0A,
	0x04, 0x1B, 0x1A, 0x16, 0x37, 0x1D, 0x0E, 0x2A,
	0x1B, 0x35, 0x2E, 0x28, 0x42, 0x30, 0x06, 0x47,
	0x06, 0x47, 0x2D, 0x4C, 0x0A, 0x04, 0x14, 0x00,
	0x2E, 0x01, 0x0C, 0x10, 0x1F, 0x10, 0x2F, 0x10,
	0x12, 0x18, 0x28, 0x1D, 0x01, 0x21, 0x08, 0x2A,
	0x11, 0x32, 0x2F, 0x2E, 0x1F, 0x25, 0x02, 0x02,
	0x01, 0x11, 0x01, 0x2F, 0x08, 0x1E, 0x11, 0x0E,
	0x11, 0x26, 0x1C, 0x01, 0x1E, 0x19, 0x1F, 0x33,
	0x24, 0x11, 0x26, 0x05, 0x28, 0x2B, 0x2F, 0x22,
	0x00, 0x13, 0x05, 0x01, 0x06, 0x08, 0x09, 0x0C,
	0x04, 0x1A, 0x08, 0x1F, 0x12, 0x05, 0x12, 0x15,
	0x16, 0x10, 0x1A, 0x08, 0x1A, 0x1D, 0x0A, 0x00,
	0x0A, 0x00, 0x00, 0x09, 0x00, 0x1E, 0x04, 0x11,
	0x08, 0x16, 0x08, 0x06, 0x10, 0x00, 0x11, 0x0D,
	0x12, 0x20, 0x15, 0x02, 0x14, 0x09, 0x16, 0x1B,
	0x1A, 0x14, 0x1A, 0x14
};

static const ByteProvider kEoB2DscTelptrShpCoordsDOSProvider = { ARRAYSIZE(kEoB2DscTelptrShpCoordsDOS), kEoB2DscTelptrShpCoordsDOS };

static const byte kEoB2PortalSeqDataDOS[126] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x04, 0x00, 0x03, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04,
	0x00, 0x01, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02,
	0x02, 0x03, 0x01, 0x04, 0x00, 0x02, 0x01, 0x03,
	0x02, 0x04, 0x03, 0x02, 0x04, 0x03, 0x03, 0x04,
	0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x05, 0x04, 0x06, 0x03, 0x07,
	0x02, 0x08, 0x02, 0x08, 0x01, 0x09, 0x01, 0x09,
	0x01, 0x09, 0x00, 0x0A, 0xFF, 0xFF
};

static const ByteProvider kEoB2PortalSeqDataDOSProvider = { ARRAYSIZE(kEoB2PortalSeqDataDOS), kEoB2PortalSeqDataDOS };

static const byte kEoB2DscMonsterFrmOffsTbl1DOS[32] = {
	0x04, 0xFE, 0x01, 0x03, 0x03, 0x04, 0xFE, 0x01,
	0x01, 0x03, 0x04, 0xFE, 0xFE, 0x01, 0x03, 0x04,
	0xFC, 0xFD, 0xFF, 0x02, 0x02, 0xFC, 0xFD, 0xFF,
	0xFF, 0x02, 0xFC, 0xFD, 0xFD, 0xFF, 0x02, 0xFC
};

static const ByteProvider kEoB2DscMonsterFrmOffsTbl1DOSProvider = { ARRAYSIZE(kEoB2DscMonsterFrmOffsTbl1DOS), kEoB2DscMonsterFrmOffsTbl1DOS };

static const byte kEoB2DscMonsterFrmOffsTbl2DOS[32] = {
	0x04, 0xFE, 0x01, 0x03, 0x03, 0x04, 0xFE, 0x01,
	0x01, 0x03, 0x04, 0xFE, 0xFE, 0x01, 0x03, 0x04,
	0x04, 0xFD, 0x01, 0x02, 0x02, 0x04, 0xFD, 0x01,
	0x01, 0x02, 0x04, 0xFD, 0xFD, 0x01, 0x02, 0x04
};

static const ByteProvider kEoB2DscMonsterFrmOffsTbl2DOSProvider = { ARRAYSIZE(kEoB2DscMonsterFrmOffsTbl2DOS), kEoB2DscMonsterFrmOffsTbl2DOS };

static const uint16 kEoB2InvSlotXDOS[27] = {
	0x00E6, 0x0116, 0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7,
	0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7,
	0x00E1, 0x00E0, 0x00E1, 0x012A, 0x011F, 0x0115, 0x012C, 0x012C,
	0x012C, 0x00E4, 0x00F0
};

static const Uint16Provider kEoB2InvSlotXDOSProvider = { ARRAYSIZE(kEoB2InvSlotXDOS), kEoB2InvSlotXDOS };

static const byte kEoB2InvSlotYDOS[27] = {
	0x74, 0x74, 0x28, 0x28, 0x3A, 0x3A, 0x4C, 0x4C,
	0x5E, 0x5E, 0x70, 0x70, 0x82, 0x82, 0x94, 0x94,
	0x38, 0x4C, 0x60, 0x37, 0x4B, 0x89, 0x5E, 0x70,
	0x82, 0x88, 0x88
};

static const ByteProvider kEoB2InvSlotYDOSProvider = { ARRAYSIZE(kEoB2InvSlotYDOS), kEoB2InvSlotYDOS };

static const uint16 kEoB2SlotValidationFlagsDOS[27] = {
	0x0008, 0x0008, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0x0001, 0x0002, 0x0004, 0x0020, 0x0040, 0x0010, 0xFFFF, 0x0080,
	0x0080, 0x0100, 0x0100
};

static const Uint16Provider kEoB2SlotValidationFlagsDOSProvider = { ARRAYSIZE(kEoB2SlotValidationFlagsDOS), kEoB2SlotValidationFlagsDOS };

static const byte kEoB2ProjectileWeaponTypesDOS[15] = {
	0xFF, 0x01, 0xFF, 0x02, 0x04, 0x03, 0x05, 0x10,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x12
};

static const ByteProvider kEoB2ProjectileWeaponTypesDOSProvider = { ARRAYSIZE(kEoB2ProjectileWeaponTypesDOS), kEoB2ProjectileWeaponTypesDOS };

static const byte kEoB2WandTypesDOS[8] = {
	0x00, 0x11, 0x17, 0x31, 0x0D, 0xFF, 0x04, 0x0C
};

static const ByteProvider kEoB2WandTypesDOSProvider = { ARRAYSIZE(kEoB2WandTypesDOS), kEoB2WandTypesDOS };

static const byte kEoB2DrawObjPosIndexDOS[20] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x02, 0x00, 0x03,
	0x01, 0x04, 0x02, 0x03, 0x00, 0x01, 0x04, 0x01,
	0x03, 0x00, 0x02, 0x04
};

static const ByteProvider kEoB2DrawObjPosIndexDOSProvider = { ARRAYSIZE(kEoB2DrawObjPosIndexDOS), kEoB2DrawObjPosIndexDOS };

static const byte kEoB2FlightObjFlipIndexDOS[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB2FlightObjFlipIndexDOSProvider = { ARRAYSIZE(kEoB2FlightObjFlipIndexDOS), kEoB2FlightObjFlipIndexDOS };

static const byte kEoB2FlightObjShpMapDOS[45] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x02,
	0xFF, 0xFF, 0x04, 0xFF, 0x06, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2FlightObjShpMapDOSProvider = { ARRAYSIZE(kEoB2FlightObjShpMapDOS), kEoB2FlightObjShpMapDOS };

static const byte kEoB2FlightObjSclIndexDOS[72] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03,
	0xFF, 0xFF, 0x03, 0x03, 0xFF, 0xFF, 0x03, 0x03,
	0xFF, 0xFF, 0x03, 0x03, 0xFF, 0xFF, 0x03, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

static const ByteProvider kEoB2FlightObjSclIndexDOSProvider = { ARRAYSIZE(kEoB2FlightObjSclIndexDOS), kEoB2FlightObjSclIndexDOS };

static const uint16 kEoB2TransferPortraitFramesDOS[32] = {
	0x0004, 0x0018, 0x009D, 0x0038, 0x00A2, 0x0018, 0x013C, 0x0039,
	0x0004, 0x0040, 0x009D, 0x0060, 0x00A2, 0x0040, 0x013C, 0x0060,
	0x0004, 0x0068, 0x009D, 0x0089, 0x00A2, 0x0068, 0x013C, 0x0089,
	0x0004, 0x0094, 0x002E, 0x009E, 0x0110, 0x0094, 0x013A, 0x009E
};

static const Uint16Provider kEoB2TransferPortraitFramesDOSProvider = { ARRAYSIZE(kEoB2TransferPortraitFramesDOS), kEoB2TransferPortraitFramesDOS };

static const byte kEoB2TransferConvertTableDOS[49] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x00, 0x05, 0x06,
	0x0A, 0x00, 0x0B, 0x00, 0x0C, 0x0D, 0x00, 0x0E,
	0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x00, 0x00,
	0x17, 0x18, 0x22, 0x24, 0x23, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x31, 0x30, 0x32, 0x33, 0x00, 0x35, 0x34, 0x36,
	0x37
};

static const ByteProvider kEoB2TransferConvertTableDOSProvider = { ARRAYSIZE(kEoB2TransferConvertTableDOS), kEoB2TransferConvertTableDOS };

static const byte kEoB2TransferItemTableDOS[60] = {
	0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB2TransferItemTableDOSProvider = { ARRAYSIZE(kEoB2TransferItemTableDOS), kEoB2TransferItemTableDOS };

static const uint32 kEoB2TransferExpTableDOS[6] = {
	0x000F423F, 0x000B71AF, 0x000DBB9F, 0x0006B6BF, 0x000DBB9F, 0x000DBB9F
};

static const Uint32Provider kEoB2TransferExpTableDOSProvider = { ARRAYSIZE(kEoB2TransferExpTableDOS), kEoB2TransferExpTableDOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData00DOS[5] = {
	{ 0x01,   0, 208,  16,   1,   1,   0,   0,   0,   0 },
	{ 0x01,   0, 208,  16,   1,   1,   0,   0,   0,   0 },
	{ 0x00,   0, 216,  51,   8,   0,   0,   0,   0,   0 },
	{ 0x06,   3,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData00DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData00DOS), kEoB2IntroAnimData00DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData01DOS[5] = {
	{ 0x01,   1, 184,   8,   1,   1,   0,   0,   0,   0 },
	{ 0x01,   1, 184,   8,   1,   1,   0,   0,   0,   0 },
	{ 0x00,   0, 216,  51,   7,   0,   0,   0,   0,   0 },
	{ 0x06,   4,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData01DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData01DOS), kEoB2IntroAnimData01DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData02DOS[5] = {
	{ 0x01,   2, 216,  51,   1,   0,   0,   0,   0,   0 },
	{ 0x01,   2, 216,  51,   1,   0,   0,   0,   0,   0 },
	{ 0x00,   0, 216,  51,  18,   0,   0,   0,   0,   0 },
	{ 0x06,   6,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData02DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData02DOS), kEoB2IntroAnimData02DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData03DOS[4] = {
	{ 0x00,   0,   0,   0,   1,   2,   0,   0,   0,   0 },
	{ 0x06,   3,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   2,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData03DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData03DOS), kEoB2IntroAnimData03DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData04DOS[3] = {
	{ 0x01,   0, 282,   8,   1,   0,   0,   0,   0,   0 },
	{ 0x01,   0, 282,   8,   1,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData04DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData04DOS), kEoB2IntroAnimData04DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData05DOS[4] = {
	{ 0x00,   0,   0,   0,   1,   1,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   1,   0,   0,   0,   0 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData05DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData05DOS), kEoB2IntroAnimData05DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData06DOS[16] = {
	{ 0x01,  12, 170,  11,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 188,  38,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 203,  63,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 218,  85,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 232, 107,   2,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x01,   3, 242, 125,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   4, 240, 125,   3,   0,   0,   0,   0,   0 },
	{ 0x01,   5, 238, 124,   3,   0,   0,   0,   0,   0 },
	{ 0x01,   6, 236, 123,   3,   0,   0,   0,   0,   0 },
	{ 0x01,   7, 232, 121,   3,   0,   0,   0,   0,   0 },
	{ 0x01,   8, 226, 120,   4,   0,   0,   0,   0,   0 },
	{ 0x01,   9, 220, 119,   4,   0,   0,   0,   0,   0 },
	{ 0x01,  10, 241, 115,   4,   0,   0,   0,   0,   0 },
	{ 0x01,  11, 241, 115,   4,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData06DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData06DOS), kEoB2IntroAnimData06DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData07DOS[5] = {
	{ 0x01,  12,  54,  17,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12,  80,  53,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 104,  87,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 130, 124,   2,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData07DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData07DOS), kEoB2IntroAnimData07DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData08DOS[6] = {
	{ 0x01,  12, 112,   8,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 126,  34,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 142,  60,   2,   0,   0,   0,   0,   0 },
	{ 0x01,  12, 170, 109,   2,   0,   0,   0,   0,   0 },
	{ 0x06,   8,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData08DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData08DOS), kEoB2IntroAnimData08DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData09DOS[4] = {
	{ 0x05,   0, 184,  64,   6,   0,  30,   8,   3,  16 },
	{ 0x05,   0, 184,  64,   6,   0,  33,   8,   3,  16 },
	{ 0x05,   0, 184,  64,   6,   0,  36,   8,   3,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData09DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData09DOS), kEoB2IntroAnimData09DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData10DOS[10] = {
	{ 0x05,   0, 184,  64,   0,   0,  30,   8,   3,  16 },
	{ 0x05,   0, 128,  88,   3,   0,  30,  32,   4,  24 },
	{ 0x05,   0, 128,  88,   3,   0,  34,  32,   4,  24 },
	{ 0x05,   0, 184,  64,   0,   0,  33,   8,   3,  16 },
	{ 0x05,   0, 128,  88,   3,   0,  30,  32,   4,  24 },
	{ 0x05,   0, 128,  88,   3,   0,  34,  32,   4,  24 },
	{ 0x05,   0, 184,  64,   0,   0,  36,   8,   3,  16 },
	{ 0x05,   0, 128,  88,   3,   0,  30,  32,   4,  24 },
	{ 0x05,   0, 128,  88,   3,   0,  34,  32,   4,  24 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData10DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData10DOS), kEoB2IntroAnimData10DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData11DOS[16] = {
	{ 0x03,  15,  36,  48,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   3,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   4,   0,   0,   0,   0 },
	{ 0x06,  11,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   5,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   6,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,  90,   7,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   6,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   5,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   4,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   3,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  15,  36,  48,   1,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData11DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData11DOS), kEoB2IntroAnimData11DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData12DOS[3] = {
	{ 0x02,  15,  36,  48,  90,   0,   0,   0,   0,   0 },
	{ 0x07,  15,  36,  48,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData12DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData12DOS), kEoB2IntroAnimData12DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData13DOS[4] = {
	{ 0x06,  10,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 104,  24,   5,   0,   0,   8,  15, 112 },
	{ 0x05,   0, 104,  24,   5,   0,  15,   8,  15, 112 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData13DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData13DOS), kEoB2IntroAnimData13DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData14DOS[6] = {
	{ 0x05,   0, 184,  64,   0,   0,  30,   8,   3,  16 },
	{ 0x05,   0, 104,  72,   5,   0,  10, 120,  10,  64 },
	{ 0x05,   0, 184,  64,   0,   0,  33,   8,   3,  16 },
	{ 0x05,   0, 104,  72,   5,   0,  20, 120,  10,  64 },
	{ 0x05,   0, 184,  64,   0,   0,  36,   8,   3,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData14DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData14DOS), kEoB2IntroAnimData14DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData15DOS[4] = {
	{ 0x05,   0, 104,   0,   8,   0,   0,   0,  13, 200 },
	{ 0x05,   0, 104,   0,   8,   0,  13,   0,  13, 200 },
	{ 0x05,   0, 104,   0,   8,   0,  26,   0,  13, 200 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData15DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData15DOS), kEoB2IntroAnimData15DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData16DOS[11] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   6, 112,  72,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   7, 112,  72,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   8, 112,  72,   6,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData16DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData16DOS), kEoB2IntroAnimData16DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData17DOS[12] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData17DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData17DOS), kEoB2IntroAnimData17DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData18DOS[8] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   6,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData18DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData18DOS), kEoB2IntroAnimData18DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData19DOS[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  10, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  11, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  12, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  10, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData19DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData19DOS), kEoB2IntroAnimData19DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData20DOS[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  11, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  10, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  12, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  11, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  13, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData20DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData20DOS), kEoB2IntroAnimData20DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData21DOS[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  14, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   9, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  15, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  16, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   4, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  17, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  14, 136,  40,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 224,  72,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   5, 240,  40,   3,   0,   0,   0,   0,   0 },
	{ 0x02,  17, 136,  40,   3,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData21DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData21DOS), kEoB2IntroAnimData21DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData22DOS[2] = {
	{ 0x05,   0, 104,  32,   0,   0,  10,   0,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData22DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData22DOS), kEoB2IntroAnimData22DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData23DOS[2] = {
	{ 0x05,   0, 104,  32,   3,   0,  20,   0,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData23DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData23DOS), kEoB2IntroAnimData23DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData24DOS[2] = {
	{ 0x05,   0, 104,  32,   0,   0,  30,   0,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData24DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData24DOS), kEoB2IntroAnimData24DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData25DOS[2] = {
	{ 0x05,   0, 104,  32,   0,   0,   0,  96,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData25DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData25DOS), kEoB2IntroAnimData25DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData26DOS[2] = {
	{ 0x05,   0, 104,  32,   3,   0,  10,  96,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData26DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData26DOS), kEoB2IntroAnimData26DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData27DOS[2] = {
	{ 0x05,   0, 104,  32,   0,   0,  20,  96,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData27DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData27DOS), kEoB2IntroAnimData27DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData28DOS[2] = {
	{ 0x05,   0, 104,  32,   0,   0,   0,   0,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData28DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData28DOS), kEoB2IntroAnimData28DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData29DOS[2] = {
	{ 0x05,   0, 104,  32,   3,   0,   0,   0,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData29DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData29DOS), kEoB2IntroAnimData29DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData30DOS[2] = {
	{ 0x05,   0, 104,  32,   4,   0,  10,   0,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData30DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData30DOS), kEoB2IntroAnimData30DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData31DOS[2] = {
	{ 0x05,   0, 104,  32,   8,   0,  20,   0,  10,  96 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData31DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData31DOS), kEoB2IntroAnimData31DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData32DOS[5] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 176,  56,   3,   0,  19, 136,   2,   8 },
	{ 0x05,   0, 176,  56,   3,   0,  21, 136,   2,   8 },
	{ 0x05,   0, 176,  56,   3,   0,  23, 136,   2,   8 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData32DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData32DOS), kEoB2IntroAnimData32DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData33DOS[14] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 176,  56,   0,   0,  19, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   5,   0,   1, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  21, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,   7, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   2,   0,  23, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,  13, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  19, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   6,   0,   1, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  21, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,   7, 136,   6,  40 },
	{ 0x05,   0, 176,  56,   0,   0,  23, 136,   2,   8 },
	{ 0x05,   0, 144,  88,   3,   0,   1, 136,   6,  40 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData33DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData33DOS), kEoB2IntroAnimData33DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData34DOS[8] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0,  80,  64,   0,   0,   1, 136,   2,  16 },
	{ 0x05,   0, 248,  64,   3,   0,   7, 136,   2,  16 },
	{ 0x05,   0,  80,  64,   0,   0,   3, 136,   2,  16 },
	{ 0x05,   0, 248,  64,   3,   0,   9, 136,   2,  16 },
	{ 0x05,   0,  80,  64,   0,   0,   5, 136,   2,  16 },
	{ 0x05,   0, 248,  64,   3,   0,  11, 136,   2,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData34DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData34DOS), kEoB2IntroAnimData34DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData35DOS[5] = {
	{ 0x06, 255,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0,  16,  48,   0,   0,   0, 152,  14,  48 },
	{ 0x05,   0, 192,  48,   4,   0,  14, 128,  13,  48 },
	{ 0x05,   0,  16,  48,   0,   0,   1,  40,  35,  48 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData35DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData35DOS), kEoB2IntroAnimData35DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData36DOS[6] = {
	{ 0x06,   1,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  24,   3,   0,   0, 128,   2,  32 },
	{ 0x05,   0, 152,  16,   3,   0,   0,  88,   5,  40 },
	{ 0x05,   0, 128,   0,   3,   0,   0,   0,  10,  88 },
	{ 0x05,   0, 104,   0,   3,   0,  13,   0,  14,  88 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData36DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData36DOS), kEoB2IntroAnimData36DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData37DOS[2] = {
	{ 0x05,   0, 104,   0,   0,   0,  13,   0,  13, 200 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData37DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData37DOS), kEoB2IntroAnimData37DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData38DOS[43] = {
	{ 0x03,  17,  36,  48,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   3,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   4,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   5,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   5,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   5,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   6,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   6,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   6,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   7,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   7,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,  54,   7,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   6,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   6,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   6,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   5,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   5,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   5,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   4,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   3,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  17,  36,  48,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  16, 142,  80,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  19, 151,  28,   1,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData38DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData38DOS), kEoB2IntroAnimData38DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData39DOS[7] = {
	{ 0x02,  17,  36,  48,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  16, 142,  80,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  19, 151,  28,  54,   0,   0,   0,   0,   0 },
	{ 0x07,  17,  36,  48,   0,   0,   0,   0,   0,   0 },
	{ 0x07,  16, 142,  80,   0,   0,   0,   0,   0,   0 },
	{ 0x07,  19, 151,  28,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData39DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData39DOS), kEoB2IntroAnimData39DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData40DOS[32] = {
	{ 0x03,  22,  21,  32,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   3,   0,   0,   0,   0 },
	{ 0x06,  11,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   5,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   4,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   6,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   5,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   7,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,  18,   6,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   7,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,  90,   6,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   6,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   5,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   5,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   4,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   4,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   3,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   3,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   2,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   2,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   1,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   1,   0,   0,   0,   0 },
	{ 0x03,  22,  21,  32,   0,   0,   0,   0,   0,   0 },
	{ 0x03,  23,  67,  80,   1,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData40DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData40DOS), kEoB2IntroAnimData40DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData41DOS[5] = {
	{ 0x02,  22,  21,  32,   0,   0,   0,   0,   0,   0 },
	{ 0x02,  23,  67,  80,  90,   0,   0,   0,   0,   0 },
	{ 0x07,  22,  21,  32,   0,   0,   0,   0,   0,   0 },
	{ 0x07,  23,  67,  80,   0,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData41DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData41DOS), kEoB2IntroAnimData41DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData42DOS[3] = {
	{ 0x06,   3,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   2,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData42DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData42DOS), kEoB2IntroAnimData42DOS };

static const DarkMoonAnimCommand kEoB2IntroAnimData43DOS[5] = {
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0x00,   0,   0,   0,   1,   3,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2IntroAnimData43DOSProvider = { ARRAYSIZE(kEoB2IntroAnimData43DOS), kEoB2IntroAnimData43DOS };

static const DarkMoonShapeDef kEoB2IntroShapes00DOS[15] = {
	{   0,   1, 137,   4,  43 },
	{   1,   5, 137,   4,  54 },
	{   2,   9, 140,   4,   8 },
	{   3,   1, 181,   1,   3 },
	{   4,   9, 154,   1,   3 },
	{   5,   9, 158,   2,   5 },
	{   6,   9, 164,   3,   7 },
	{   7,   9, 172,   3,  11 },
	{   8,   9, 184,   5,  13 },
	{   9,  15, 137,   6,  15 },
	{  10,  15, 153,   2,  21 },
	{  11,  17, 153,   2,  21 },
	{  12,   1, 185,   1,   4 },
	{  13,   1, 190,   1,   1 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes00DOSProvider = { ARRAYSIZE(kEoB2IntroShapes00DOS), kEoB2IntroShapes00DOS };

static const DarkMoonShapeDef kEoB2IntroShapes01DOS[2] = {
	{   0,   1, 137,   1,  16 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes01DOSProvider = { ARRAYSIZE(kEoB2IntroShapes01DOS), kEoB2IntroShapes01DOS };

static const DarkMoonShapeDef kEoB2IntroShapes04DOS[10] = {
	{  15,   2,   0,  32,  14 },
	{  16,   5,  16,   5,   8 },
	{  17,   2,  27,  32,  18 },
	{  18,   0, 140,  35,  10 },
	{  19,  21,  16,   3,   8 },
	{  20,   0,  47,  22,  10 },
	{  21,   0,  59,  31,  10 },
	{  22,   0,  71,  35,  39 },
	{  23,   0, 119,  24,  15 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes04DOSProvider = { ARRAYSIZE(kEoB2IntroShapes04DOS), kEoB2IntroShapes04DOS };

static const DarkMoonShapeDef kEoB2IntroShapes07DOS[18] = {
	{  -9,   1, 136,   6,  40 },
	{  -1,   7, 136,   6,  40 },
	{  -2,  13, 136,   6,  40 },
	{   3,  19, 136,   2,  16 },
	{   4,  21, 136,   2,  16 },
	{   5,  23, 136,   2,  16 },
	{   6,  19, 152,   1,   8 },
	{   7,  20, 152,   1,   8 },
	{   8,  21, 152,   1,   8 },
	{ -10,  25, 136,   2,  16 },
	{ -11,  27, 136,   2,  16 },
	{ -12,  29, 136,   2,  16 },
	{ -13,  31, 136,   2,  16 },
	{ -14,  25, 152,   2,  16 },
	{ -15,  27, 152,   2,  16 },
	{ -16,  29, 152,   2,  16 },
	{ -17,  31, 152,   2,  16 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2IntroShapes07DOSProvider = { ARRAYSIZE(kEoB2IntroShapes07DOS), kEoB2IntroShapes07DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData00DOS[11] = {
	{ 0x06,   4,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 136,   8,   8,   0,   5, 136,  11,  48 },
	{ 0x02,   1, 136,   8,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0,  80,   8,   0,   0,   0, 136,   5,  40 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232,  88,   4,   0,   0,  88,   8,  48 },
	{ 0x02,   3,  80,   8,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232,  88,   4,   0,   8,  88,   8,  48 },
	{ 0x05,   0, 232,  88,   4,   0,  16,  88,   8,  48 },
	{ 0x02,   2, 232,  88,   4,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData00DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData00DOS), kEoB2FinaleAnimData00DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData01DOS[9] = {
	{ 0x06,   4,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 136,   8,  12,   0,   5, 136,  11,  48 },
	{ 0x02,   1, 136,   8,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   5,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232,  88,   6,   0,   0,  88,   8,  48 },
	{ 0x05,   0, 232,  88,   6,   0,   8,  88,   8,  48 },
	{ 0x05,   0, 232,  88,   6,   0,  16,  88,   8,  48 },
	{ 0x02,   2, 232,  88,   6,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData01DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData01DOS), kEoB2FinaleAnimData01DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData02DOS[4] = {
	{ 0x05,   0, 232, 112,   6,   0,  24, 176,   3,  16 },
	{ 0x05,   0, 232, 112,   6,   0,  27, 176,   3,  16 },
	{ 0x05,   0, 232, 112,   6,   0,  30, 176,   3,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData02DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData02DOS), kEoB2FinaleAnimData02DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData03DOS[6] = {
	{ 0x05,   0,  80,   8,   0,   0,   0, 136,   5,  40 },
	{ 0x05,   0, 232, 112,   3,   0,  24, 176,   3,  16 },
	{ 0x02,   3,  80,   8,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 232, 112,   3,   0,  27, 176,   3,  16 },
	{ 0x05,   0, 232, 112,   3,   0,  30, 176,   3,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData03DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData03DOS), kEoB2FinaleAnimData03DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData04DOS[8] = {
	{ 0x06,   6,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 104,  40,   3,   0,  32,  88,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  32,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  24,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  16,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,   0,   0,   8,  88 },
	{ 0x05,   0, 104,  40,   3,   0,  24,  88,   8,  88 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData04DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData04DOS), kEoB2FinaleAnimData04DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData05DOS[7] = {
	{ 0x05,   0, 232, 112,   0,   0,  24, 176,   3,  16 },
	{ 0x05,   0, 128,  40,   4,   0,  33, 176,   2,  16 },
	{ 0x05,   0, 232, 112,   0,   0,  27, 176,   3,  16 },
	{ 0x05,   0, 128,  40,   4,   0,  35, 176,   2,  16 },
	{ 0x05,   0, 232, 112,   0,   0,  30, 176,   3,  16 },
	{ 0x05,   0, 128,  40,   4,   0,  37, 176,   2,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData05DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData05DOS), kEoB2FinaleAnimData05DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData06DOS[2] = {
	{ 0x05,   0, 104,  40,   0,   0,  16, 136,   8,  48 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData06DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData06DOS), kEoB2FinaleAnimData06DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData07DOS[6] = {
	{ 0x05,   0, 208,  80,   4,   0,   0, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,   6, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,  12, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,  18, 128,   6,  56 },
	{ 0x05,   0, 208,  80,   4,   0,  24, 128,   6,  56 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData07DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData07DOS), kEoB2FinaleAnimData07DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData08DOS[3] = {
	{ 0x05,   0, 224,  56,   3,   0,   0, 184,   4,  16 },
	{ 0x05,   0, 224,  56,   0,   0,   4, 184,   4,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData08DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData08DOS), kEoB2FinaleAnimData08DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData09DOS[8] = {
	{ 0x01,   1, -10,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,   0,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  10,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  20,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  30,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x01,   1,  40,  40,   2,   0,   0,   0,   0,   0 },
	{ 0x02,   2,  48,  40,   2,   0,   0,   0,   0,   0 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData09DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData09DOS), kEoB2FinaleAnimData09DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData10DOS[14] = {
	{ 0x05,   1,   8,  40,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  24, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  12,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  32,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  28, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  13,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  14,  80,   1,  16 },
	{ 0x06,   8,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData10DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData10DOS), kEoB2FinaleAnimData10DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData11DOS[18] = {
	{ 0x05,   1,  40,  32,   0,   0,  16,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  18, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   0,   0,   0, 152,  12,  24 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   0,   0,  14,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  14,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  24, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  12,  80,   1,  16 },
	{ 0x05,   1,   8,  40,   0,   0,  16,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  36, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  15,  80,   1,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData11DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData11DOS), kEoB2FinaleAnimData11DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData12DOS[23] = {
	{ 0x05,   1,  40,  32,   0,   0,  16,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  18, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   0,   0,   0, 152,  12,  24 },
	{ 0x05,   1,   8,  40,   0,   0,  24,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  32, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   0,   0,  14,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,   8,  40,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  24, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  12,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,   8,  40,   0,   0,  16,  80,   8,  80 },
	{ 0x05,   1, 280,  96,   0,   0,  36, 160,   4,  40 },
	{ 0x05,   1,  96,  96,   3,   0,  15,  80,   1,  16 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData12DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData12DOS), kEoB2FinaleAnimData12DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData13DOS[23] = {
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   0, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0,  80,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,  16,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   6, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 104,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData13DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData13DOS), kEoB2FinaleAnimData13DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData14DOS[24] = {
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   0, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0,  80,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,  16,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   6, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 104,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData14DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData14DOS), kEoB2FinaleAnimData14DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData15DOS[19] = {
	{ 0x05,   1,  40,  32,   0,   0,   0,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   0, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0,  80,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,  16,   0,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,   6, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 104,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,   9,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   1,  40,  32,   0,   0,   0,  40,  16,  40 },
	{ 0x05,   1, 248,  88,   0,   0,  12, 176,   6,  24 },
	{ 0x05,   1,  96,  80,   3,   0,   0, 128,  12,  24 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData15DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData15DOS), kEoB2FinaleAnimData15DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData16DOS[13] = {
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   1, 168,  16,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   2, 168,  16,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0x06,  15,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x02,   3, 168,  16,   3,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   0,   0,  32,   0,   8,  80 },
	{ 0x05,   0, 232,  16,   0,   0,  32,  80,   8,  80 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData16DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData16DOS), kEoB2FinaleAnimData16DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData17DOS[20] = {
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x06,  10,   0,   0,   0,   0,   0,   0,   0,   0 },
	{ 0x05,   0, 168,  16,   3,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData17DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData17DOS), kEoB2FinaleAnimData17DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData18DOS[28] = {
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   3,   0,  16,   0,  16,  80 },
	{ 0x05,   0, 168,  16,   1,   0,   0,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   2,   0,  16,  80,  16,  80 },
	{ 0x05,   0, 168,  16,   0,   0,  16,  80,  16,  80 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData18DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData18DOS), kEoB2FinaleAnimData18DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData19DOS[7] = {
	{ 0x05,   0,  80,  80,   4,   0,   0, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,   6, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  12, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  18, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  24, 128,   6,  56 },
	{ 0x05,   0,  80,  80,   4,   0,  30, 128,   6,  56 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData19DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData19DOS), kEoB2FinaleAnimData19DOS };

static const DarkMoonAnimCommand kEoB2FinaleAnimData20DOS[3] = {
	{ 0x05,   0,  96,  56,   3,   0,   0, 184,   4,  16 },
	{ 0x05,   0,  96,  56,   0,   0,   4, 184,   4,  16 },
	{ 0xFF,   0,   0,   0,   0,   0,   0,   0,   0,   0 }
};

static const DarkMoonAnimCommandProvider kEoB2FinaleAnimData20DOSProvider = { ARRAYSIZE(kEoB2FinaleAnimData20DOS), kEoB2FinaleAnimData20DOS };

static const DarkMoonShapeDef kEoB2FinaleShapes00DOS[4] = {
	{  -1,  16,   0,  11,  48 },
	{  -2,  28,  80,   8,  48 },
	{  -3,   9,   0,   5,  40 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes00DOSProvider = { ARRAYSIZE(kEoB2FinaleShapes00DOS), kEoB2FinaleShapes00DOS };

static const DarkMoonShapeDef kEoB2FinaleShapes03DOS[3] = {
	{  -1,  30,   0,   8,  96 },
	{  -2,  30, 104,  10,  96 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes03DOSProvider = { ARRAYSIZE(kEoB2FinaleShapes03DOS), kEoB2FinaleShapes03DOS };

static const DarkMoonShapeDef kEoB2FinaleShapes07DOS[4] = {
	{   1,   0,   0,  16,  72 },
	{   2,  16,   0,  16,  72 },
	{   3,   0,  72,  16,  72 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes07DOSProvider = { ARRAYSIZE(kEoB2FinaleShapes07DOS), kEoB2FinaleShapes07DOS };

static const DarkMoonShapeDef kEoB2FinaleShapes09DOS[9] = {
	{   0,   0,   0,  32,  16 },
	{   2,   0,  36,  35,  41 },
	{   3,   0,  77,  24,  17 },
	{   4,   0,  94,  15,  33 },
	{   5,  24,  77,  10,  17 },
	{   6,  16,  99,  23,  69 },
	{ -10,   0, 136,   8,  64 },
	{ -11,   8, 136,   8,  64 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes09DOSProvider = { ARRAYSIZE(kEoB2FinaleShapes09DOS), kEoB2FinaleShapes09DOS };

static const DarkMoonShapeDef kEoB2FinaleShapes10DOS[4] = {
	{   1,   0,   0,  40,  30 },
	{  15,   9,  37,  21,  48 },
	{  16,  16,  88,   6,  56 },
	{   0,   0,   0,   0,   0 }
};

static const DarkMoonShapeDefProvider kEoB2FinaleShapes10DOSProvider = { ARRAYSIZE(kEoB2FinaleShapes10DOS), kEoB2FinaleShapes10DOS };

static const byte kEoB2NpcShapeDataDOS[24] = {
	0x00, 0x00, 0x00, 0x05, 0x39, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x64, 0x05, 0x4F, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x39, 0x06, 0x2B, 0x00, 0x00, 0xFF
};

static const ByteProvider kEoB2NpcShapeDataDOSProvider = { ARRAYSIZE(kEoB2NpcShapeDataDOS), kEoB2NpcShapeDataDOS };

static const byte kEoB2ClassModifierFlagsDOS[15] = {
	0x01, 0x20, 0x10, 0x02, 0x04, 0x08, 0x05, 0x09,
	0x03, 0x0B, 0x0A, 0x0C, 0x07, 0x05, 0x06
};

static const ByteProvider kEoB2ClassModifierFlagsDOSProvider = { ARRAYSIZE(kEoB2ClassModifierFlagsDOS), kEoB2ClassModifierFlagsDOS };

static const byte kEoB2MonsterStepTable02DOS[8] = {
	0xE0, 0xE1, 0x01, 0x21, 0x20, 0x1F, 0xFF, 0xDF
};

static const ByteProvider kEoB2MonsterStepTable02DOSProvider = { ARRAYSIZE(kEoB2MonsterStepTable02DOS), kEoB2MonsterStepTable02DOS };

static const byte kEoB2MonsterStepTable1DOS[16] = {
	0x01, 0xE0, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00,
	0x00, 0x00, 0xFF, 0x20, 0xFF, 0x00, 0x00, 0xE0
};

static const ByteProvider kEoB2MonsterStepTable1DOSProvider = { ARRAYSIZE(kEoB2MonsterStepTable1DOS), kEoB2MonsterStepTable1DOS };

static const byte kEoB2MonsterStepTable2DOS[8] = {
	0x07, 0xFA, 0x05, 0xFC, 0x03, 0xFE, 0x01, 0x00
};

static const ByteProvider kEoB2MonsterStepTable2DOSProvider = { ARRAYSIZE(kEoB2MonsterStepTable2DOS), kEoB2MonsterStepTable2DOS };

static const byte kEoB2MonsterStepTable3DOS[8] = {
	0xF9, 0x06, 0xFB, 0x04, 0xFD, 0x02, 0xFF, 0x00
};

static const ByteProvider kEoB2MonsterStepTable3DOSProvider = { ARRAYSIZE(kEoB2MonsterStepTable3DOS), kEoB2MonsterStepTable3DOS };

static const byte kEoB2MonsterCloseAttPosTable1DOS[4] = {
	0x00, 0x01, 0x03, 0x02
};

static const ByteProvider kEoB2MonsterCloseAttPosTable1DOSProvider = { ARRAYSIZE(kEoB2MonsterCloseAttPosTable1DOS), kEoB2MonsterCloseAttPosTable1DOS };

static const byte kEoB2MonsterCloseAttPosTable22DOS[16] = {
	0x00, 0x01, 0x02, 0x03, 0x00, 0x02, 0x01, 0x03,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x01, 0x02, 0x00
};

static const ByteProvider kEoB2MonsterCloseAttPosTable22DOSProvider = { ARRAYSIZE(kEoB2MonsterCloseAttPosTable22DOS), kEoB2MonsterCloseAttPosTable22DOS };

static const byte kEoB2MonsterCloseAttUnkTableDOS[12] = {
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x02, 0xFF, 0x01
};

static const ByteProvider kEoB2MonsterCloseAttUnkTableDOSProvider = { ARRAYSIZE(kEoB2MonsterCloseAttUnkTableDOS), kEoB2MonsterCloseAttUnkTableDOS };

static const byte kEoB2MonsterCloseAttChkTable1DOS[16] = {
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00
};

static const ByteProvider kEoB2MonsterCloseAttChkTable1DOSProvider = { ARRAYSIZE(kEoB2MonsterCloseAttChkTable1DOS), kEoB2MonsterCloseAttChkTable1DOS };

static const byte kEoB2MonsterCloseAttChkTable2DOS[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB2MonsterCloseAttChkTable2DOSProvider = { ARRAYSIZE(kEoB2MonsterCloseAttChkTable2DOS), kEoB2MonsterCloseAttChkTable2DOS };

static const byte kEoB2MonsterCloseAttDstTable1DOS[16] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB2MonsterCloseAttDstTable1DOSProvider = { ARRAYSIZE(kEoB2MonsterCloseAttDstTable1DOS), kEoB2MonsterCloseAttDstTable1DOS };

static const byte kEoB2MonsterCloseAttDstTable2DOS[48] = {
	0x01, 0x00, 0x03, 0x02, 0x05, 0x04, 0x00, 0x01,
	0x02, 0x03, 0x04, 0x05, 0x05, 0x03, 0x01, 0x04,
	0x02, 0x00, 0x01, 0x03, 0x05, 0x00, 0x02, 0x04,
	0x04, 0x05, 0x02, 0x03, 0x00, 0x01, 0x05, 0x04,
	0x03, 0x02, 0x01, 0x00, 0x00, 0x02, 0x04, 0x01,
	0x03, 0x05, 0x04, 0x02, 0x00, 0x05, 0x03, 0x01
};

static const ByteProvider kEoB2MonsterCloseAttDstTable2DOSProvider = { ARRAYSIZE(kEoB2MonsterCloseAttDstTable2DOS), kEoB2MonsterCloseAttDstTable2DOS };

static const byte kEoB2MonsterProximityTableDOS[32] = {
	0x02, 0x03, 0x00, 0x01, 0x03, 0x02, 0x01, 0x00,
	0x00, 0x02, 0x01, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x01, 0x00, 0x03, 0x02, 0x00, 0x01, 0x02, 0x03,
	0x03, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02, 0x00
};

static const ByteProvider kEoB2MonsterProximityTableDOSProvider = { ARRAYSIZE(kEoB2MonsterProximityTableDOS), kEoB2MonsterProximityTableDOS };

static const byte kEoB2FindBlockMonstersTableDOS[64] = {
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00,
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00
};

static const ByteProvider kEoB2FindBlockMonstersTableDOSProvider = { ARRAYSIZE(kEoB2FindBlockMonstersTableDOS), kEoB2FindBlockMonstersTableDOS };

static const byte kEoB2MonsterDirChangeTableDOS[48] = {
	0xFF, 0x06, 0x02, 0xFF, 0x04, 0x05, 0x03, 0xFF,
	0x00, 0x07, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xDF, 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF,
	0x01, 0x00, 0x1F, 0x00, 0x20, 0x00, 0x21, 0x00,
	0xC0, 0xFF, 0xA0, 0xFF, 0x02, 0x00, 0x03, 0x00,
	0x40, 0x00, 0x60, 0x00, 0xFE, 0xFF, 0xFD, 0xFF
};

static const ByteProvider kEoB2MonsterDirChangeTableDOSProvider = { ARRAYSIZE(kEoB2MonsterDirChangeTableDOS), kEoB2MonsterDirChangeTableDOS };

static const uint16 kEoB2EncodeMonsterDefsDOS[168] = {
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0028, 0x000C, 0x0038,
	0x0013, 0x0028, 0x000C, 0x0038, 0x001F, 0x0000, 0x0007, 0x0060,
	0x0000, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060,
	0x000E, 0x0060, 0x0005, 0x0038, 0x0007, 0x0000, 0x0007, 0x0028,
	0x000E, 0x0000, 0x0007, 0x0028, 0x0013, 0x0060, 0x0005, 0x0038,
	0x0018, 0x0060, 0x0005, 0x0038, 0x001D, 0x0060, 0x0005, 0x0038,
	0x000E, 0x0098, 0x0003, 0x0020, 0x0011, 0x00A0, 0x0004, 0x0018,
	0x0015, 0x00A0, 0x0004, 0x0018, 0x0019, 0x0098, 0x0003, 0x0020,
	0x001C, 0x0098, 0x0003, 0x0020, 0x001F, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0000, 0x0007, 0x0060,
	0x000E, 0x0000, 0x0007, 0x0060, 0x0015, 0x0000, 0x0007, 0x0060,
	0x001C, 0x0000, 0x0007, 0x0060, 0x0000, 0x0060, 0x0007, 0x0060,
	0x0007, 0x0060, 0x0005, 0x0038, 0x000C, 0x0060, 0x0005, 0x0038,
	0x0011, 0x0060, 0x0005, 0x0038, 0x0016, 0x0060, 0x0005, 0x0038,
	0x001B, 0x0060, 0x0005, 0x0038, 0x0020, 0x0060, 0x0005, 0x0038,
	0x0007, 0x0098, 0x0003, 0x0020, 0x000A, 0x0098, 0x0003, 0x0020,
	0x000D, 0x0098, 0x0003, 0x0020, 0x0010, 0x0098, 0x0003, 0x0020,
	0x0013, 0x0098, 0x0003, 0x0020, 0x0016, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x000A, 0x0058, 0x000A, 0x0000, 0x000A, 0x0058,
	0x0014, 0x0000, 0x000A, 0x0058, 0x001E, 0x0000, 0x000A, 0x0058,
	0x0000, 0x0058, 0x000A, 0x0058, 0x000A, 0x0058, 0x000A, 0x0058
};

static const Uint16Provider kEoB2EncodeMonsterDefsDOSProvider = { ARRAYSIZE(kEoB2EncodeMonsterDefsDOS), kEoB2EncodeMonsterDefsDOS };

static const EoBCharacter kEoB2NpcPresetsDOS[6] = {
	{ 0x00, 0x01,
	  15, 15,  0,  0, 13, 13, 11, 11, 17, 17, 16, 16,  9,  9,
	     3,   39, 10, 0, 10, 5, 5, -1, 8, { 6, 0, 0 },
	  { 0x00006ADA, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  18, 18, 36, 36, 13, 13,  8,  8, 15, 15, 16, 16, 14, 14,
	     4,   76, 10, 0, 1, 0, 2, -2, 12, { 9, 0, 0 },
	  { 0x0003DF35, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  15, 15,  0,  0, 14, 14, 13, 13, 14, 14, 13, 13, 16, 16,
	    40,   40, 10, 0, 6, 4, 3, -3, 100, { 8, 0, 0 },
	  { 0x00021730, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  11, 11,  0,  0, 18, 18, 13, 13, 14, 14, 16, 16,  9,  9,
	    28,   28, 10, 0, 2, 3, 5, -4, 100, { 8, 0, 0 },
	  { 0x00017AF0, 0x00000000, 0x00000000 }, 0x096B4566,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  16, 16,  0,  0, 13, 13, 16, 16, 15, 15, 11, 11, 12, 12,
	    53,   53,  9, 0, 4, 6, 1, -5, 100, { 7, 7, 0 },
	  { 0x00010FC2, 0x00010FC2, 0x00000000 }, 0xFFFFFFFF,
	  { 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  14, 14,  0,  0, 17, 17, 12, 12, 18, 18,  9,  9, 17, 17,
	    36,   36, 10, 0, 3, 10, 1, -6, 100, { 7, 7, 0 },
	  { 0x0000FAE6, 0x0000FAE6, 0x00000000 }, 0x00294566,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } }
};

static const EoBCharacterProvider kEoB2NpcPresetsDOSProvider = { ARRAYSIZE(kEoB2NpcPresetsDOS), kEoB2NpcPresetsDOS };

static const byte kEoB2DreamStepsDOS[14] = {
	0x01, 0x02, 0x03, 0x02, 0x01, 0x00, 0x01, 0x02,
	0x03, 0x03, 0x02, 0x01, 0x00, 0xFF
};

static const ByteProvider kEoB2DreamStepsDOSProvider = { ARRAYSIZE(kEoB2DreamStepsDOS), kEoB2DreamStepsDOS };

static const byte kEoB2HornSoundsDOS[4] = {
	0x40, 0x41, 0x42, 0x43
};

static const ByteProvider kEoB2HornSoundsDOSProvider = { ARRAYSIZE(kEoB2HornSoundsDOS), kEoB2HornSoundsDOS };

static const uint16 kEoB2WallOfForceDsXDOS[18] = {
	0xFFCC, 0xFFF4, 0x001C, 0x0044, 0x006C, 0x0094, 0x00BC, 0xFFB8,
	0xFFF8, 0x0038, 0x0078, 0x00B8, 0xFFC8, 0x0028, 0x0088, 0x0000,
	0x0000, 0x0000
};

static const Uint16Provider kEoB2WallOfForceDsXDOSProvider = { ARRAYSIZE(kEoB2WallOfForceDsXDOS), kEoB2WallOfForceDsXDOS };

static const byte kEoB2WallOfForceDsYDOS[3] = {
	0x20, 0x18, 0x10
};

static const ByteProvider kEoB2WallOfForceDsYDOSProvider = { ARRAYSIZE(kEoB2WallOfForceDsYDOS), kEoB2WallOfForceDsYDOS };

static const byte kEoB2WallOfForceNumWDOS[3] = {
	0x01, 0x02, 0x03
};

static const ByteProvider kEoB2WallOfForceNumWDOSProvider = { ARRAYSIZE(kEoB2WallOfForceNumWDOS), kEoB2WallOfForceNumWDOS };

static const byte kEoB2WallOfForceNumHDOS[3] = {
	0x02, 0x06, 0x09
};

static const ByteProvider kEoB2WallOfForceNumHDOSProvider = { ARRAYSIZE(kEoB2WallOfForceNumHDOS), kEoB2WallOfForceNumHDOS };

static const byte kEoB2WallOfForceShpIdDOS[3] = {
	0x04, 0x02, 0x00
};

static const ByteProvider kEoB2WallOfForceShpIdDOSProvider = { ARRAYSIZE(kEoB2WallOfForceShpIdDOS), kEoB2WallOfForceShpIdDOS };

static const byte kEoB2DscShapeIndexDOS[36] = {
	0x01, 0x01, 0x04, 0x0A, 0x04, 0x08, 0x04, 0x01,
	0x04, 0xF8, 0x04, 0xF6, 0x00, 0x00, 0x03, 0x09,
	0x03, 0x07, 0x03, 0x01, 0x03, 0xF9, 0x03, 0xF7,
	0x02, 0x06, 0x02, 0x01, 0x02, 0xFA, 0x01, 0x05,
	0x01, 0x01, 0x01, 0xFB
};

static const ByteProvider kEoB2DscShapeIndexDOSProvider = { ARRAYSIZE(kEoB2DscShapeIndexDOS), kEoB2DscShapeIndexDOS };

static const uint16 kEoB2DscXDOS[18] = {
	0xFF70, 0xFFA0, 0xFFD0, 0x0000, 0x0030, 0x0060, 0x0090, 0xFF60,
	0xFFB0, 0x0000, 0x0050, 0x00A0, 0xFF80, 0x0000, 0x0080, 0x0000,
	0x0000, 0x0000
};

static const Uint16Provider kEoB2DscXDOSProvider = { ARRAYSIZE(kEoB2DscXDOS), kEoB2DscXDOS };

static const byte kEoB2DscTileIndexDOS[18] = {
	0x00, 0x06, 0x01, 0x05, 0x02, 0x04, 0x03, 0x07,
	0x0B, 0x08, 0x0A, 0x09, 0x0C, 0x0E, 0x0D, 0x0F,
	0x11, 0x10
};

static const ByteProvider kEoB2DscTileIndexDOSProvider = { ARRAYSIZE(kEoB2DscTileIndexDOS), kEoB2DscTileIndexDOS };

static const byte kEoB2DscDimData1DOS[324] = {
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD8, 0xD7, 0xD8, 0xD8, 0x02, 0xD8, 0xD8, 0xD8,
	0xD8, 0xFE, 0xD7, 0xD8, 0xD8, 0xD8, 0xD7, 0x03,
	0xD8, 0xFD, 0xD8, 0xD8, 0xD8, 0xFE, 0xD8, 0x08,
	0xD8, 0xD8, 0xD8, 0xFE, 0xD7, 0x06, 0xD8, 0xD8,
	0xFA, 0x03, 0xD8, 0xFD, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xFA, 0xD7,
	0x10, 0xD8, 0xFD, 0xD7, 0x13, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xF2, 0xD8, 0x14, 0xD8, 0xD8,
	0xD8, 0xF0, 0xD7, 0x14, 0xD8, 0xED, 0x10, 0xD8,
	0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8, 0xEC, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD7, 0x14, 0xD8, 0xED,
	0xD7, 0xD8, 0xD8, 0x13, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0x06, 0xD8, 0xD8, 0xFA, 0x03, 0xD8, 0xFD,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xFA, 0xD8, 0x10, 0xD8, 0xFD, 0xD7,
	0x13, 0xFD, 0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xF0, 0xD8, 0xD8,
	0xD8, 0xED, 0x10, 0xD8, 0xD8, 0x13, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0x03, 0xD8, 0xFD,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xFD, 0xD8,
	0x13, 0xFD, 0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xED, 0xD8, 0xD8, 0xD8, 0x13, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8
};

static const ByteProvider kEoB2DscDimData1DOSProvider = { ARRAYSIZE(kEoB2DscDimData1DOS), kEoB2DscDimData1DOS };

static const byte kEoB2DscDimData2DOS[648] = {
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x02, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x04, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x16, 0x00, 0x00, 0x03,
	0x00, 0x16, 0x03, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x16, 0x00, 0x08,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x02,
	0x16, 0x00, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x08, 0x0E,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x06, 0x10,
	0x00, 0x13, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x0E, 0x16,
	0x00, 0x16, 0x00, 0x14, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x16, 0x00, 0x00, 0x14,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x14, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x12, 0x16, 0x14, 0x16, 0x00, 0x16, 0x13, 0x16,
	0x16, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x00, 0x16,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x07, 0x0F,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x03, 0x16, 0x00, 0x16,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16
};

static const ByteProvider kEoB2DscDimData2DOSProvider = { ARRAYSIZE(kEoB2DscDimData2DOS), kEoB2DscDimData2DOS };

static const byte kEoB2DscBlockMapDOS[12] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB2DscBlockMapDOSProvider = { ARRAYSIZE(kEoB2DscBlockMapDOS), kEoB2DscBlockMapDOS };

static const byte kEoB2DscDimMapDOS[18] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03,
	0x03, 0x03
};

static const ByteProvider kEoB2DscDimMapDOSProvider = { ARRAYSIZE(kEoB2DscDimMapDOS), kEoB2DscDimMapDOS };

static const byte kEoB2DscBlockIndexDOS[72] = {
	0x9D, 0x9E, 0x9F, 0xA0, 0xA1, 0xA2, 0xA3, 0xBE,
	0xBF, 0xC0, 0xC1, 0xC2, 0xDF, 0xE0, 0xE1, 0xFF,
	0x00, 0x01, 0xA3, 0xC3, 0xE3, 0x03, 0x23, 0x43,
	0x63, 0xC2, 0xE2, 0x02, 0x22, 0x42, 0xE1, 0x01,
	0x21, 0xE0, 0x00, 0x20, 0x63, 0x62, 0x61, 0x60,
	0x5F, 0x5E, 0x5D, 0x42, 0x41, 0x40, 0x3F, 0x3E,
	0x21, 0x20, 0x1F, 0x01, 0x00, 0xFF, 0x5D, 0x3D,
	0x1D, 0xFD, 0xDD, 0xBD, 0x9D, 0x3E, 0x1E, 0xFE,
	0xDE, 0xBE, 0x1F, 0xFF, 0xDF, 0x20, 0x00, 0xE0
};

static const ByteProvider kEoB2DscBlockIndexDOSProvider = { ARRAYSIZE(kEoB2DscBlockIndexDOS), kEoB2DscBlockIndexDOS };

static const char *const kEoB2SoundFilesIntroDOS[1] = {
	"INTRO"
};

static const StringListProvider kEoB2SoundFilesIntroDOSProvider = { ARRAYSIZE(kEoB2SoundFilesIntroDOS), kEoB2SoundFilesIntroDOS };

static const char *const kEoB2SoundFilesFinaleDOS[2] = {
	"FINALE1",
	"FINALE2"
};

static const StringListProvider kEoB2SoundFilesFinaleDOSProvider = { ARRAYSIZE(kEoB2SoundFilesFinaleDOS), kEoB2SoundFilesFinaleDOS };
