/*
 * format.cpp - log files format selection
 * $Id: format.cpp 151 2004-06-05 15:15:18Z rdenisc $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <string.h> /* strcmp() */

#include "gettext.h"

#include "basiclog.h"

#include "format.h"

extern DataLog *PasswordLogMaker (void);

static struct format_info
{
	const char *f_name;
	DataLogMaker f_logmaker;
} format_list[] =
{
	// aliases MUST be put just after the canonical format name
	{ "C",		CDataLogMaker },
	{ "c",		CDataLogMaker },
	{ "hex",	HexDataLogMaker },
	{ "hexa",	HexDataLogMaker },
	{ "count",	CountDataLogMaker },
	{ "null",	NullDataLogMaker },
	{ "raw",	RawDataLogMaker },
	{ "password",	PasswordLogMaker },
	{ "pass",	PasswordLogMaker },
	{ "pw",		PasswordLogMaker },
	{ "strip",	StrippedDataLogMaker },
	{ "stripped",	StrippedDataLogMaker },
	{ NULL,		NULL }
};
#define MAX_PROTONAME 8 /* bytes */

DataLogMaker findlogmakerbyname (const char *name)
{
	struct format_info *info;

	for (info = format_list; info->f_logmaker != NULL; info++)
		if (strcmp (info->f_name, name) == 0)
			return info->f_logmaker;

	return NULL;
}


void fprint_format_list (FILE *stream)
{
	struct format_info *info = format_list;
	DataLogMaker previous = NULL, current;

	fputs (_("List of available log formats:"), stream);
	// Only show the first alias for each format ("canonical format name")
	while ((current = info->f_logmaker) != NULL)
	{
		if (previous != current)
		{
			fputc (' ', stream);
			fputs (info->f_name, stream);

			previous = current;
		}
		info++;
	}
	fputc ('\n', stream);
}


DataLogMaker default_format (int verbose)
{
	return verbose ? CDataLogMaker : NullDataLogMaker;
}
