## TFSA-2022-051: Integer overflow in Grappler cost estimation of crop and resize operation

### CVE Number
CVE-2022-23587

### Impact
Under certain scenarios, Grappler component of TensorFlow is vulnerable to an integer overflow during [cost estimation for crop and resize](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/grappler/costs/op_level_cost_estimator.cc#L2621-L2689). Since the cropping parameters are user controlled, a malicious person can trigger undefined behavior.

### Patches
We have patched the issue in GitHub commit [0aaaae6eca5a7175a193696383f582f53adab23f](https://github.com/tensorflow/tensorflow/commit/0aaaae6eca5a7175a193696383f582f53adab23f).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
