.PS
# ColdControl1.m4
#https://www.researchgate.net/journal/Sensors-1424-8220/publication/361484962_Design_of_a_Smart_IoT-Based_Control_System_for_Remotely_Managing_Cold_Storage_Facilities/links/6806de36df0e3f544f442241/Design-of-a-Smart-IoT-Based-Control-System-for-Remotely-Managing-Cold-Storage-Facilities.pdf

log_init
sinclude(ics.m4)
sinclude(../ics.m4)
sinclude(UNO.m4def)
sinclude(../UNO.m4def)
sinclude(tst.dim)
s_init(ColdControl)
divert(-1)

define(`ESP8266',`[ Chip: box wid 9*lg_pinsep ht 16*lg_pinsep
  foreach_(`x',`Pin`'eval(m4Lx+15): line from Chip.ne+(0,(m4Lx-16)*lg_pinsep) \
    right pinlen "eval(m4Lx+15)" above; "x" rjust at last line.start',
    3V3,GND,TX(GPIO1),RX(GPIO3),D8(GPIO15),D7(GPIO13),D6(GPIO12),
    D5(GPIO14),GND,3V3,D4(GPIO2),D3(GPIO0),D2(GPIO4),D1(GPIO5),D0(GPIO16))
  foreach_(`x',`Pin`'m4Lx: line from Chip.nw+(0,-m4Lx*lg_pinsep) \
    left pinlen "m4Lx" above; "x" ljust at last line.start',
    AO(ADC0),RSV,RSV,SD3(GPIO10),SD2(GPIO9),SD1(MOSI), CMD(CS),SDO(MISO),
    CLK(SCLK),GND,3V3,EN,RST,GND,VIN) ]')

define(`LEDQ',`[ B:dot; resistor(up_ dimen_,,E); rlabel(,R)
  diode(up_ dimen_/2 from Here+(0,-dimen_/5),L)
  { em_arrows(,135,dimen_/3) with .Tail at last [].nw}; dot
  {ground(,,S,0); "GND" at last line.s below ljust}
 Q: bi_tr(up_ dimen_*5/4,,,E) with .E at Here; "BC547" at last [].e ljust
  line from Q.B left_ dimen_/3
  resistor(down_ to (Here,B),,E); llabel(,R); line to B
 T: Q.C ]')

define(`Relay',`[
 C: relaycoil(S,,,ifelse(`$2',,U,D))
 B: box wid elen_ ht C.ht at C ifelse(`$2',,+,-)(elen_/4,0)
  `"Relay"' at B.n above
 ifelse(`$2',,`C1: 1/4 < B.nw, B.ne >; C2: 1/4 < B.sw, B.se >
               S1: 5/6 < B.nw, B.ne >; S2: 5/6 < B.sw, B.se >
 S: dswitch(ifinstr(`$1',R,`down_ from S1 to S2,R',`up_ from S2 to S1,'),WBCD)',
              `C1: 3/4 < B.nw, B.ne >; C2: 3/4 < B.sw, B.se >
               S1: 1/6 < B.nw, B.ne >; S2: 1/6 < B.sw, B.se >
 S: dswitch(ifinstr(`$1',R,`up_ from S2 to S1,R',`down_ from S1 to S2,'),WBCD)')
   "G5Q-1A" at 1/2<C2,S2> below
]')

define(`Fan',`[
 C: circle at (0,0) ifelse(`$1',,,`diam `$1'')
 arc from (Rect_(C.rad,-30)) to (Rect_(C.rad,210)) with .c at (0,-C.rad) 
 arc to (Rect_(C.rad,90)) with .c at (Rect_(C.rad,150))
 arc to (Rect_(C.rad,-30)) with .c at (Rect_(C.rad,30))
 ]')

define(`pins',`for_(1,`$1',1,
`ifinstr(`$2',L,
  `L`'m4x:line left_ del from ((m4x*2-1)/(2*(`$1')))<last box.nw, last box.sw>')
 ifinstr(`$2',R,
  `R`'m4x:line right_ del from ((m4x*2-1)/(2*(`$1')))<last box.ne,last box.se>')
')')

define(`thermometer',`[eleminit_(`$1')
   tx = rp_len; ty = tx/6
  {box ht_ ty rad ty/2 wid_ rp_len-ty}
  {circle diam 2*ty fill_(0) at rvec_(rp_len-ty,0)}
  {box ht_ last box.ht_ wid_ last box.wid_/4 \
     at rvec_(rp_len-ty*5/2,0) fill_(0)}
  for i=1 to 5 do {{ move to rvec_(ty*i/2,0)
    line from rvec_(0,-ty/2) to Here }}
]')

define(`thsen',`[
 B: box ht boxwid*5/6
   pins(4,L)
   "T \& RH" above at B.n;  "DHT22" below rjust at B.se
 for j=1 to 5 do {
   box wid B.wid/10 ht B.wid/15 at B.nw+((j-1/2)*B.wid/5,-(1/2)*B.ht/4)
   for i=2 to 4 do {
     box wid B.wid/10 ht B.wid/12 at B.nw+((j-1/2)*B.wid/5,-(i-1/2)*B.ht/4)
     }
   }
 ]')

define(`S8',`[
 B: box wid dimen_*3.2 ht dimen_*2
 foreach_(`x',`move to B.nw-(0,(m4Lx-1/2)*B.ht/5)
   ifelse(x,nul,,{"x" ljust}; L`'m4Lx: line left_ del)',
   UART\_R/T,UART\_TXD,UART\_RXD,nul,BCAL\_IN)
 foreach_(`x',`move to B.ne-(0,(m4Lx-1/2)*B.ht/5)
   ifelse(x,nul,,{"x" rjust}; R`'m4Lx: line right_ del)',
   ALARMLOC,nul,PWM\_1KHZ,nul,DVCC\_OUT) ]')

define(`s_pin',
 `Pin`$2': line from Chip.se-(`$1'*lg_pinsep,0) down_ pinlen
   rs_box(`$2') with .e at last line.c-(textoffset,0)
   rs_box(`$3') with .s at last line.start+(0,textoffset)')

 define(`RC1602A',`[ Chip: box ht 6*lg_pinsep wid 14*lg_pinsep
  foreach_(`x',`Pin`'eval(m4Lx+1): line from Chip.ne-(m4Lx*lg_pinsep,0) \
    up_ pinlen 
    rs_box(eval(m4Lx+3)) with .e at last line.c-(textoffset,0)
    rs_box(x) with .n at last line.start-(0,textoffset)', RS,R/W,E)
    line from 3rd last"".nw+(-1bp__,0) down_ 3rd last "".ht/2
    line from last"".nw+(-1bp__,0) down_ last "".ht
  Pin3: line from Chip.ne-(4*lg_pinsep,0) up_ pinlen
    rs_box(3) with .e at last line.c-(textoffset,0)
    rs_box(Vo) with .n at last line.start-(0,textoffset)
  foreach_(`x',`Pin`'eval(m4Lx+6): line from Chip.ne-((m4Lx+5)*lg_pinsep,0) \
    up_ pinlen
    rs_box(eval(m4Lx+6)) with .e at last line.c-(textoffset,0)
    rs_box(x) with .n at last line.start-(0,textoffset)',
    DB0,DB1,DB2,DB3,DB4,DB5,DB6,DB7)
  Pin1: line from Chip.w left_ pinlen
    rs_box(1) with .s at last line.c+(0,textoffset)
    rs_box(VSS) with .w at Chip.w+(textoffset,0)
  Pin2: line from Chip.e right_ pinlen
    rs_box(2) with .s at last line.c+(0,textoffset)
    rs_box(VDD) with .e at Chip.e-(textoffset,0)
  foreach_(`trm',`s_pin(patsubst(trm,:,`,'))',6:16:K,7:15:A/VEE,8:A:A1,9:K1:K)
 ]')

define(`Ammonia',`[
 B: box; "MQ-3" at B.se rjust below
  line left_ del then up_ del from 3/4<B.sw,B.nw>; "5 V" above
  "VCC" at last line.start ljust
  line left_ del from 1/4<B.sw,B.nw>
  {"GND" at last line.start ljust}
  ground(,,S); "GND" at last line.s ljust
 C: circle diam B.ht*7/8 at B.e-(B.ht/2,0)
  circle diam B.ht*5/8 at C
  circle diam B.ht*3/8 at C
  circle diam B.ht/4 at C
 Out: 1/6<B.se,B.ne>; "out" at Out below ljust
  "C${}_2$H${}_4$" at B.n+(0,2bp__) above
  ]')

divert(0)dnl

  finalscale = 0.72
  textht = 0.1/finalscale
  textoffset = 1.5bp__ * 2
  ifpostscript(,latexcommand({\scriptsize\sf))

 define(`pinlen',`20bp__')
 define(`lg_pinsep',(1.2*lg_pinsep))
 del = lg_pinsep

 ESP: ESP8266; `"ESP8266"' at ESP.Chip.se below rjust
  line from ESP.Pin24.end right del then down ESP.Pin24.y-ESP.Pin16.y
  ground(,,S); "GND" at last line.s below
  dot(at ESP.Pin17.end+(del,0)); line to ESP.Pin17.end
  "3.3 V" at ESP.Pin25.end ljust
 LEQ1: LEDQ with .B at ESP.Chip.nw+(dimen_+del,dimen_/2)
  line from LEQ1.B to (ESP.Pin30.end,LEQ1.B) then to ESP.Pin30.end 
 LEQ2: LEDQ with .B at ESP.Chip.ne+(del*3/2,dimen_/2+del)
  line from LEQ2.B to (ESP.Pin29.end.x+del,LEQ1.B.y+del)
    continue to (Here,ESP.Pin29) then to ESP.Pin29.end
  line from LEQ1.T up 2*del then right_ ESP.Pin30.end.x-LEQ1.T.x +6*del \
    then down_ del; right_
 R1: Relay(R) with .C1 at Here
 R2: Relay with .B.n at R1.B.s+(0,-dimen_)
  line from R1.S.end to R2.S.end; dot(at last line.c); line right_ del
  "220 V" ljust
  line from R1.C.V1 to R2.C.V2; dot(at last line.c); line left_ del
  "5 V" rjust
  line from LEQ2.T right_ R2.C2.x-LEQ2.T.x-3*del
  continue to (Here.x,R2.C2.y-del) then right_ R2.C2.x-Here.x then to R2.C2
  line from R1.S1 up del then right_ 2*del

 Hum: [F: Fan; box wid F.wid ht F.ht at F; pins(3,LR)] with .L1.end at Here
  "Hum. unit" at Hum.s below
  line from R2.S2 down del then right_ 2*del

 Con: [B: box; pins(3,LR)
       circle diam B.ht/3 with .n at 1/4 < B.nw, B.ne >
       circle diam B.ht/3 with .n at 3/4 < B.nw, B.ne >
       circle diam B.ht/3 with .s at 3/4 < B.sw, B.se >
       circle diam B.ht/3 with .s at 1/4 < B.sw, B.se > ] \
     with .L3.end at Here
    "Control unit" at Con.s below

   line from ESP.Pin23.end to (R2.w.x+4*del,ESP.Pin23.y)
 T1: box wid boxht with .w at Here; "T1" at T1.e ljust "DS1822" ljust
   "out" at T1.w ljust
 T2: box wid boxht with .w at (T1.w,ESP.Pin28)
   "T2" at T2.e ljust "DS1822" ljust; "out" at T2.w ljust
   line from ESP.Pin26.end right del then up T2.w.y-ESP.Pin26.y then to T2.w
   line from T2.s to T1.n; dot(at last line.c); ground(,,S,0)
    "GND" at Here+(dimen_*5/6,0)
   line from 1/4 <T2.nw,T2.sw> left del; "5 V" above
   line from 1/4 <T1.nw,T1.sw> left del; "5 V" above

   thermometer(up_ T2.ht*3/4) at 3/4<T2.w,T2.e>
   thermometer(down_ T1.ht*3/4) at 3/4<T1.w,T1.e>

 M1: thsen with .L2.start at (T1.w.x,ESP.Pin21.y-2*del)
   ground(at M1.L4.end,,S); "GND" at last line.s below
   "5 V" above at M1.L1.end
   line from M1.L2.end left del
   continue to (Here,ESP.Pin22) then to ESP.Pin22.end
 M2: thsen with .n at M1.s+(0,-2*del)
   ground(at M2.L4.end,,S); "GND" at last line.s below
   "5 V" rjust at M2.L1.end
   line from M2.L2.end left 2*del
   continue to (Here,ESP.Pin21) then to ESP.Pin21.end

 CO2: S8 with .B.nw at (M2.L1.end.x-2*del,M2.s.y-dimen_)
   "G0" at CO2.s above; "G$+$" at CO2.n below
  `"Senseair S8"' at CO2.B.se rjust below
   line up del from CO2.n; "5 V" above
   line down del from CO2.s; ground(,T,S); "GND" at last line.s below
   line from CO2.R1.end up del
 Spkr:speaker(U,dimen_*2/3) with .In1 at Here
   "CO${}_2$" at Spkr.n+(0,10bp__) "Alarm"
   line down del*3/2 from Spkr.In3; ground(,T,S)
   "GND" at last line.s below
   line from CO2.L1.end to (CO2.L1.end,ESP.Pin20) then to ESP.Pin20.end
   line from CO2.L2.end left del
   continue to (Here,ESP.Pin19) then to ESP.Pin19.end
   line from CO2.L3.end left 2*del
   continue to (Here,ESP.Pin18) then to ESP.Pin18.end

 LCD: RC1602A with .Pin14.start \
   at (ESP.Pin7.end.x-4*del,ESP.s.y-dimen_-del*3/2)
   {"LCD" at 1/2<LCD.Chip.sw,LCD.PinK1.start> below
   `"RC1602A-GHW-ESX"' at LCD.Chip.se+(10bp__,0) rjust below}
 RV: potentiometer(right_ dimen_) with .T1 at LCD.Pin15.end
   {"RV" at RV.R.c+(0,-dimen_/12) below
    "1" at RV.R.c+(dimen_/4,0) above ljust} 
   line from RV.End to (LCD.Pin2.end,RV.End); dot 
   line from LCD.Pin2.end to Here chop 0 chop -del; "5 V" ljust
   line from RV.Start to (LCD.Pin1.end,RV.Start); dot 
   line from LCD.Pin1.end to Here; ground(,,S); "GND" at last line.s below

   line from ESP.Pin27.end right_ 2*del;continue to (Here.x,LCD.Pin12.end.y+del)
   continue to (LCD.Pin12,Here) then to LCD.Pin12.end
   line from ESP.Pin11.end left del then down ESP.Pin11.y-ESP.s.y; "3.3 V" ljust
   line from ESP.Pin15.end left del; dot
   line from ESP.Pin10.end left 2*del then down ESP.Pin10.y-ESP.s.y
   ground(,T,S); "GND" at last line.s below
   line from ESP.Pin14.end left 2*del; dot
   line from ESP.Pin9.end to (LCD.Pin13,ESP.Pin9) then to LCD.Pin13.end
   line from ESP.Pin7.end to (LCD.Pin14,ESP.Pin7) then to LCD.Pin14.end

 LEQ3: LEDQ with .B at (ESP.Pin1.end.x-del,LEQ1.B.y)
   line from LEQ3.B to (LEQ3.B,ESP.Pin4) then to ESP.Pin4.end
 R3: Relay(,R) with .se at LEQ3.Q.B-(2*del,0)
   line from R3.C1 up del; continue to (LEQ3.T,Here) then to LEQ3.T
   line from R3.S2 down_ del; "220 V" below
   line from R3.C2 down_ del; "5 V" below
   line from R3.S1 up_ del then left_ R3.S1.x-R3.w.x+del then down R3.ht+3*del
 F1: Fan with .n at Here
   ground(at F1.s,,S); "GND" at last line.s below
   "Ventilation" at F1.e ljust "unit" ljust

   line from ESP.Pin5.end left_ 7*del
 A1: Ammonia with .Out at Here
 A2: Ammonia with .Out at A1.Out-(0,dimen_*2)
   line from A2.Out right_ del; continue to (Here,ESP.Pin6) then to ESP.Pin6.end

   line from ESP.Pin8.end left_ 5*del; continue to (Here,ESP.s) \
     then left_ del
 LightS: [ B: box ht boxwid; "BH1750" at B.se rjust below
   circle diam B.ht/5 at B.nw+(B.ht/5,-B.ht/5)
   circle diam B.ht/5 at B.sw+(B.ht/5, B.ht/5)
  foreach_(`x',
   `Pin`'m4Lx: line right_ pinlen from B.se+(0,(m4Lx-1/2)*B.ht/5) "m4Lx" above
   "x" at last line.start rjust',ADDR,SDA,SCL,GND,VCC)
  ] with .Pin2.end at Here
   {"Light" at LightS.B.n above}
   line from LightS.Pin3.end to (LCD.Pin13,LightS.Pin3); dot
   line from LightS.Pin5.end up del; "5 V" above
   line from LightS.Pin4.end down LightS.Pin4.y-LightS.s.y
   {dot(at (Here,LightS.Pin1))}
   ground(,,S); "GND" at last line.s below

ifpostscript(,latexcommand(}%))
.PE
