/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef PANED_H
#define PANED_H
#include <vdk/vdkobj.h>
#include <vdk/widcontain.h>
/*!
  \class VDKPaned
  \brief Provides a paned widget
  \par EXAMPLES
  Into ./testvdk/panedwin.cc
 */
class VDKPaned: public VDKObjectContainer
{
public:
  /*!
    Constructor
    \param owner
    \param mode either vertical (mode == v_box) or horizontal
    (mode == h_box)
   */
  VDKPaned(VDKForm* owner = NULL,int mode = v_box);
  /*!
    Destructor
   */
  virtual ~VDKPaned();
  /*!
    Add an object to pane
    \param obj object to be added
    \param pane if pane == 1 add to top/left pane, bottom/right otherwise
    \param expnad
    \param fill
    \param padding
   */
  virtual void Add(VDKObject* obj, int pane = 1,
		   int expand = TRUE, int fill = TRUE, int padding = 0);
  /*!
    Pack an object into paned
    \param obj object to be packed
    \param resize 
    \param shrink 
   */
  void Pack(VDKObject* obj, int pane = 1 , 
	    bool resize = false, 
	    bool shrink = true);
};
#endif
