// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_MLA_4S_TRACE_AARCH64_H_
#define VIXL_SIM_MLA_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_mla_4S[] = {
  0x3e040000, 0x3f010001, 0x00090002, 0x00000020,
  0x3e820000, 0x7e830001, 0x00000002, 0x00000020,
  0xfe860000, 0x00000001, 0x007ffd02, 0x00000020,
  0x00000000, 0x00007f01, 0x00fffa02, 0x00000020,
  0x00007e00, 0x0000fe01, 0x0fffa002, 0x00000020,
  0x0000fc00, 0x000fe001, 0x3e7e8902, 0x00000020,
  0x000fc000, 0x003e0301, 0x3efe8602, 0x00000020,
  0x003d8600, 0x003e8201, 0x3f7e8302, 0x00000020,
  0x003e0400, 0x003f0101, 0xfd000902, 0x00000020,
  0x003e8200, 0x3f7e8301, 0xfd800602, 0x00000020,
  0x3efe8600, 0x3f7f0201, 0xfe000302, 0x00000020,
  0x3eff0400, 0x3f7f8101, 0xffe66702, 0x00000020,
  0x3eff8200, 0x66664d01, 0xaa800102, 0x00000020,
  0x33331a00, 0x55552b01, 0xfe800902, 0x00000020,
  0xffffd600, 0xfffe8301, 0xff000602, 0x00000020,
  0xfffe8600, 0xffff0201, 0xff800302, 0x00000020,
  0xffff0400, 0xffff8101, 0x00000002, 0x00000020,
  0xffff8200, 0x00000001, 0x007ffd02, 0x00000020,
  0x00000000, 0x00007f01, 0x55000202, 0x00000020,
  0x00007e00, 0xaaaa5601, 0xff999c02, 0x00000020,
  0xffffac00, 0x99993401, 0x01800002, 0x00000020,
  0xcccc6800, 0xc0800001, 0x01fffd02, 0x00000020,
  0xc1000000, 0xc0807f01, 0x027ffa02, 0x00000020,
  0xc1007e00, 0xc080fe01, 0x02fff702, 0x00000020,
  0xc100fc00, 0xc0817d01, 0xc0018002, 0x00000020,
  0xc1017a00, 0xffc08001, 0xc0817d02, 0x00000020,
  0xffc10000, 0xffc0ff01, 0xc1017a02, 0x00000020,
  0xffc17e00, 0xffc17e01, 0xc1817702, 0x00000020,
  0xffc1fc00, 0xffc1fd01, 0xf0006002, 0x00000020,
  0xffc27a00, 0xfff02001, 0xfe800902, 0x00000020,
  0xfff04000, 0xfffe8301, 0xff000602, 0x00000020,
  0xfffe8300, 0xff000601, 0x00000002, 0x00000020,
  0xffff0200, 0xff800301, 0x00000002, 0x00000021,
  0xffff8100, 0x00000001, 0x00000002, 0x00000022,
  0x00000000, 0x007ffd01, 0x00000002, 0x00000040,
  0x00007f00, 0x00fffa01, 0x00000002, 0x0000009d,
  0x0000fe00, 0x0fffa001, 0x00000002, 0x0000009e,
  0x000fe000, 0x3e7e8901, 0x00000002, 0x0000009f,
  0x003e0300, 0x3efe8601, 0x00000002, 0x0000801d,
  0x003e8200, 0x3f7e8301, 0x00000002, 0x0000801e,
  0x003f0100, 0xfd000901, 0x00000002, 0x0000801f,
  0x3f7e8300, 0xfd800601, 0x00000002, 0x33333353,
  0x3f7f0200, 0xfe000301, 0x00000002, 0x55555575,
  0x3f7f8100, 0xffe66701, 0x00000002, 0x8000001d,
  0x66664d00, 0xaa800101, 0x00000002, 0x8000001e,
  0x55552b00, 0xfe800901, 0x00000002, 0x8000001f,
  0xfffe8300, 0xff000601, 0x00000002, 0x80000020,
  0xffff0200, 0xff800301, 0x00000002, 0x80000021,
  0xffff8100, 0x00000001, 0x00000002, 0xaaaaaaca,
  0x00000000, 0x007ffd01, 0x00000002, 0xccccccec,
  0x00007f00, 0x55000201, 0x00000002, 0xffff8020,
  0xaaaa5600, 0xff999c01, 0x00000002, 0xffff8021,
  0x99993400, 0x01800001, 0x00000002, 0xffff8022,
  0xc0800000, 0x01fffd01, 0x00000002, 0xffff8023,
  0xc0807f00, 0x027ffa01, 0x00000002, 0xffffffa0,
  0xc080fe00, 0x02fff701, 0x00000002, 0xffffffa1,
  0xc0817d00, 0xc0018001, 0x00000002, 0xffffffa2,
  0xffc08000, 0xc0817d01, 0x00000002, 0xffffffa3,
  0xffc0ff00, 0xc1017a01, 0x00000002, 0x00000000,
  0xffc17e00, 0xc1817701, 0x00000002, 0x0000001d,
  0xffc1fd00, 0xf0006001, 0x00000002, 0x0000001e,
  0xfff02000, 0xfe800901, 0x00000002, 0x0000001f,
  0xfe800900, 0x00000001, 0x00000001, 0x00000020,
  0xff000600, 0x00000001, 0x00000002, 0x00000022,
  0xff800300, 0x00000001, 0x00000003, 0x00000024,
  0x00000000, 0x00000001, 0x00000004, 0x00000060,
  0x007ffd00, 0x00000001, 0x00000022, 0x0000011a,
  0x00fffa00, 0x00000001, 0x0000007f, 0x0000011c,
  0x0fffa000, 0x00000001, 0x00000080, 0x0000011e,
  0x3e7e8900, 0x00000001, 0x00000081, 0x0001001a,
  0x3efe8600, 0x00000001, 0x00007fff, 0x0001001c,
  0x3f7e8300, 0x00000001, 0x00008000, 0x0001001e,
  0xfd000900, 0x00000001, 0x00008001, 0x66666686,
  0xfd800600, 0x00000001, 0x33333335, 0xaaaaaaca,
  0xfe000300, 0x00000001, 0x55555557, 0x0000001a,
  0xffe66700, 0x00000001, 0x7fffffff, 0x0000001c,
  0xaa800100, 0x00000001, 0x80000000, 0x0000001e,
  0xfe800900, 0x00000001, 0x80000001, 0x00000020,
  0xff000600, 0x00000001, 0x80000002, 0x00000022,
  0xff800300, 0x00000001, 0x80000003, 0x55555574,
  0x00000000, 0x00000001, 0xaaaaaaac, 0x999999b8,
  0x007ffd00, 0x00000001, 0xccccccce, 0xffff0020,
  0x55000200, 0x00000001, 0xffff8002, 0xffff0022,
  0xff999c00, 0x00000001, 0xffff8003, 0xffff0024,
  0x01800000, 0x00000001, 0xffff8004, 0xffff0026,
  0x01fffd00, 0x00000001, 0xffff8005, 0xffffff20,
  0x027ffa00, 0x00000001, 0xffffff82, 0xffffff22,
  0x02fff700, 0x00000001, 0xffffff83, 0xffffff24,
  0xc0018000, 0x00000001, 0xffffff84, 0xffffff26,
  0xc0817d00, 0x00000001, 0xffffff85, 0xffffffe0,
  0xc1017a00, 0x00000001, 0xffffffe2, 0x0000001a,
  0xc1817700, 0x00000001, 0xffffffff, 0x0000001c,
  0xf0006000, 0x00000001, 0x00000000, 0x0000001e,
  0x00000000, 0xffffffff, 0x00000000, 0x00000020,
  0x00000000, 0x00000000, 0x00000002, 0x00000040,
  0x00000000, 0x00000001, 0x00000004, 0x00000060,
  0x00000000, 0x00000002, 0x00000006, 0x00000420,
  0x00000000, 0x00000003, 0x00000042, 0x00000fc0,
  0x00000000, 0x00000021, 0x000000fc, 0x00000fe0,
  0x00000000, 0x0000007e, 0x000000fe, 0x00001000,
  0x00000000, 0x0000007f, 0x00000100, 0x000fffc0,
  0x00000000, 0x00000080, 0x0000fffc, 0x000fffe0,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00100000,
  0x00000000, 0x00007fff, 0x00010000, 0x66666680,
  0x00000000, 0x00008000, 0x66666668, 0xaaaaaac0,
  0x00000000, 0x33333334, 0xaaaaaaac, 0xffffffc0,
  0x00000000, 0x55555556, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x7ffffffe, 0xfffffffe, 0x00000000,
  0x00000000, 0x7fffffff, 0x00000000, 0x00000020,
  0x00000000, 0x80000000, 0x00000002, 0x00000040,
  0x00000000, 0x80000001, 0x00000004, 0x55555560,
  0x00000000, 0x80000002, 0x55555556, 0x999999a0,
  0x00000000, 0xaaaaaaab, 0x9999999a, 0xfff00020,
  0x00000000, 0xcccccccd, 0xffff0002, 0xfff00040,
  0x00000000, 0xffff8001, 0xffff0004, 0xfff00060,
  0x00000000, 0xffff8002, 0xffff0006, 0xfff00080,
  0x00000000, 0xffff8003, 0xffff0008, 0xfffff020,
  0x00000000, 0xffff8004, 0xffffff02, 0xfffff040,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff060,
  0x00000000, 0xffffff82, 0xffffff06, 0xfffff080,
  0x00000000, 0xffffff83, 0xffffff08, 0xfffffc20,
  0x00000000, 0xffffff84, 0xffffffc2, 0xffffffc0,
  0x00000000, 0xffffffe1, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xfffffffe, 0xfffffffe, 0x00000000,
  0xfffffffd, 0xfffffffd, 0xffffffe2, 0x00000020,
  0xfffffffe, 0xffffffff, 0x00000002, 0x0000009d,
  0xffffffff, 0x00000001, 0x00000022, 0x0000011a,
  0x00000000, 0x00000003, 0x00000042, 0x00000fc0,
  0x00000001, 0x00000005, 0x00000402, 0x00003d29,
  0x00000002, 0x00000041, 0x00000fa2, 0x00003da6,
  0x00000020, 0x000000fb, 0x00000fc2, 0x00003e23,
  0x0000007d, 0x000000fd, 0x00000fe2, 0x003e7ea9,
  0x0000007e, 0x000000ff, 0x000fffa2, 0x003e7f26,
  0x0000007f, 0x0000fffb, 0x000fffc2, 0x003e7fa3,
  0x00007ffd, 0x0000fffd, 0x000fffe2, 0x00000007,
  0x00007ffe, 0x0000ffff, 0x66666662, 0xaaaaaaa1,
  0x00007fff, 0x66666667, 0xaaaaaaa2, 0x7ffffea9,
  0x33333333, 0xaaaaaaab, 0xffffffa2, 0x7fffff26,
  0x55555555, 0xfffffffb, 0xffffffc2, 0x7fffffa3,
  0x7ffffffd, 0xfffffffd, 0xffffffe2, 0x80000020,
  0x7ffffffe, 0xffffffff, 0x00000002, 0x8000009d,
  0x7fffffff, 0x00000001, 0x00000022, 0x55555522,
  0x80000000, 0x00000003, 0x55555542, 0xffffffbc,
  0x80000001, 0x55555555, 0x99999982, 0xffc18020,
  0xaaaaaaaa, 0x99999999, 0xfff00002, 0xffc1809d,
  0xcccccccc, 0xffff0001, 0xfff00022, 0xffc1811a,
  0xffff8000, 0xffff0003, 0xfff00042, 0xffc18197,
  0xffff8001, 0xffff0005, 0xfff00062, 0xffffc1a0,
  0xffff8002, 0xffff0007, 0xfffff002, 0xffffc21d,
  0xffff8003, 0xffffff01, 0xfffff022, 0xffffc29a,
  0xffffff80, 0xffffff03, 0xfffff042, 0xffffc317,
  0xffffff81, 0xffffff05, 0xfffff062, 0xfffff080,
  0xffffff82, 0xffffff07, 0xfffffc02, 0xfffffea9,
  0xffffff83, 0xffffffc1, 0xffffffa2, 0xffffff26,
  0xffffffe0, 0xfffffffb, 0xffffffc2, 0xffffffa3,
  0xfffffffa, 0xffffffc1, 0xffffff85, 0x00000020,
  0xfffffffc, 0xffffffe1, 0x00000002, 0x0000009e,
  0xfffffffe, 0x00000001, 0x0000007f, 0x0000011c,
  0x00000000, 0x00000021, 0x000000fc, 0x00000fe0,
  0x00000002, 0x00000041, 0x00000fa2, 0x00003da6,
  0x00000004, 0x00000401, 0x00003d0b, 0x00003e24,
  0x00000040, 0x00000fa1, 0x00003d88, 0x00003ea2,
  0x000000fa, 0x00000fc1, 0x00003e05, 0x003efea6,
  0x000000fc, 0x00000fe1, 0x003e7e8b, 0x003eff24,
  0x000000fe, 0x000fffa1, 0x003e7f08, 0x003effa2,
  0x0000fffa, 0x000fffc1, 0x003e7f85, 0x3333333a,
  0x0000fffc, 0x000fffe1, 0xffffffe9, 0xfffffff6,
  0x0000fffe, 0x66666661, 0xaaaaaa83, 0xfffffea6,
  0x66666666, 0xaaaaaaa1, 0x7ffffe8b, 0xffffff24,
  0xaaaaaaaa, 0xffffffa1, 0x7fffff08, 0xffffffa2,
  0xfffffffa, 0xffffffc1, 0x7fffff85, 0x00000020,
  0xfffffffc, 0xffffffe1, 0x80000002, 0x0000009e,
  0xfffffffe, 0x00000001, 0x8000007f, 0xffffffcc,
  0x00000000, 0x00000021, 0x55555504, 0xcccccc88,
  0x00000002, 0x55555541, 0xffffff9e, 0xffc10020,
  0x55555554, 0x99999981, 0xffc18002, 0xffc1009e,
  0x99999998, 0xfff00001, 0xffc1807f, 0xffc1011c,
  0xffff0000, 0xfff00021, 0xffc180fc, 0xffc1019a,
  0xffff0002, 0xfff00041, 0xffc18179, 0xffffc120,
  0xffff0004, 0xfff00061, 0xffffc182, 0xffffc19e,
  0xffff0006, 0xfffff001, 0xffffc1ff, 0xffffc21c,
  0xffffff00, 0xfffff021, 0xffffc27c, 0xffffc29a,
  0xffffff02, 0xfffff041, 0xffffc2f9, 0xfffff060,
  0xffffff04, 0xfffff061, 0xfffff062, 0xfffffea6,
  0xffffff06, 0xfffffc01, 0xfffffe8b, 0xffffff24,
  0xffffffc0, 0xffffffa1, 0xffffff08, 0xffffffa2,
  0xffffffa0, 0xffffff07, 0xffffff84, 0x00000020,
  0xffffffc0, 0xffffff84, 0x00000002, 0x0000009f,
  0xffffffe0, 0x00000001, 0x00000080, 0x0000011e,
  0x00000000, 0x0000007e, 0x000000fe, 0x00001000,
  0x00000020, 0x000000fb, 0x00000fc2, 0x00003e23,
  0x00000040, 0x00000fa1, 0x00003d88, 0x00003ea2,
  0x00000400, 0x00003d0a, 0x00003e06, 0x00003f21,
  0x00000fa0, 0x00003d87, 0x00003e84, 0x003f7ea3,
  0x00000fc0, 0x00003e04, 0x003efe88, 0x003f7f22,
  0x00000fe0, 0x003e7e8a, 0x003eff06, 0x003f7fa1,
  0x000fffa0, 0x003e7f07, 0x003eff84, 0x6666666d,
  0x000fffc0, 0x003e7f84, 0x3333331c, 0x5555554b,
  0x000fffe0, 0xffffffe8, 0xffffffd8, 0x7ffffea3,
  0x66666660, 0xaaaaaa82, 0xfffffe88, 0x7fffff22,
  0xaaaaaaa0, 0x7ffffe8a, 0xffffff06, 0x7fffffa1,
  0xffffffa0, 0x7fffff07, 0xffffff84, 0x80000020,
  0xffffffc0, 0x7fffff84, 0x00000002, 0x8000009f,
  0xffffffe0, 0x80000001, 0x00000080, 0xaaaaaa76,
  0x00000000, 0x8000007e, 0xffffffae, 0x99999954,
  0x00000020, 0x55555503, 0xcccccc6a, 0xffc08020,
  0x55555540, 0xffffff9d, 0xffc10002, 0xffc0809f,
  0x99999980, 0xffc18001, 0xffc10080, 0xffc0811e,
  0xfff00000, 0xffc1807e, 0xffc100fe, 0xffc0819d,
  0xfff00020, 0xffc180fb, 0xffc1017c, 0xffffc0a0,
  0xfff00040, 0xffc18178, 0xffffc102, 0xffffc11f,
  0xfff00060, 0xffffc181, 0xffffc180, 0xffffc19e,
  0xfffff000, 0xffffc1fe, 0xffffc1fe, 0xffffc21d,
  0xfffff020, 0xffffc27b, 0xffffc27c, 0xfffff040,
  0xfffff040, 0xffffc2f8, 0xfffff042, 0xfffffea3,
  0xfffff060, 0xfffff061, 0xfffffe88, 0xffffff22,
  0xfffffc00, 0xfffffe8a, 0xffffff06, 0xffffffa1,
  0xfffffe89, 0xffffff05, 0xffffff83, 0x00000020,
  0xffffff06, 0xffffff83, 0x00000002, 0x0000801d,
  0xffffff83, 0x00000001, 0x00000081, 0x0001001a,
  0x00000000, 0x0000007f, 0x00000100, 0x000fffc0,
  0x0000007d, 0x000000fd, 0x00000fe2, 0x003e7ea9,
  0x000000fa, 0x00000fc1, 0x00003e05, 0x003efea6,
  0x00000fa0, 0x00003d87, 0x00003e84, 0x003f7ea3,
  0x00003d09, 0x00003e05, 0x00003f03, 0x3ffd0029,
  0x00003d86, 0x00003e83, 0x003f7e85, 0x3ffd8026,
  0x00003e03, 0x003efe87, 0x003f7f04, 0x3ffe0023,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0xffffe687,
  0x003e7f06, 0x003eff83, 0x6666664f, 0xaaaa8021,
  0x003e7f83, 0x3333331b, 0x5555552d, 0x7ffe8029,
  0xffffffe7, 0xffffffd7, 0x7ffffe85, 0x7fff0026,
  0xaaaaaa81, 0xfffffe87, 0x7fffff04, 0x7fff8023,
  0x7ffffe89, 0xffffff05, 0x7fffff83, 0x80000020,
  0x7fffff06, 0xffffff83, 0x80000002, 0x8000801d,
  0x7fffff83, 0x00000001, 0x80000081, 0x55550022,
  0x80000000, 0x0000007f, 0xaaaaaa58, 0xffff99bc,
  0x8000007d, 0xffffffad, 0x99999936, 0xc0018020,
  0x55555502, 0xcccccc69, 0xffc08002, 0xc002001d,
  0xffffff9c, 0xffc10001, 0xffc08081, 0xc002801a,
  0xffc18000, 0xffc1007f, 0xffc08100, 0xc0030017,
  0xffc1807d, 0xffc100fd, 0xffc0817f, 0xffc001a0,
  0xffc180fa, 0xffc1017b, 0xffffc082, 0xffc0819d,
  0xffc18177, 0xffffc101, 0xffffc101, 0xffc1019a,
  0xffffc180, 0xffffc17f, 0xffffc180, 0xffc18197,
  0xffffc1fd, 0xffffc1fd, 0xffffc1ff, 0xfff00080,
  0xffffc27a, 0xffffc27b, 0xfffff022, 0xfffe8029,
  0xffffc2f7, 0xfffff041, 0xfffffe85, 0xffff0026,
  0xfffff060, 0xfffffe87, 0xffffff04, 0xffff8023,
  0xfffffe86, 0xffffff03, 0xffff8005, 0x00000020,
  0xffffff04, 0xffffff82, 0x00000002, 0x0000801e,
  0xffffff82, 0x00000001, 0x00007fff, 0x0001001c,
  0x00000000, 0x00000080, 0x0000fffc, 0x000fffe0,
  0x0000007e, 0x000000ff, 0x000fffa2, 0x003e7f26,
  0x000000fc, 0x00000fe1, 0x003e7e8b, 0x003eff24,
  0x00000fc0, 0x00003e04, 0x003efe88, 0x003f7f22,
  0x00003d86, 0x00003e83, 0x003f7e85, 0x3ffd8026,
  0x00003e04, 0x00003f02, 0x3ffd000b, 0x3ffe0024,
  0x00003e82, 0x003f7e84, 0x3ffd8008, 0x3ffe8022,
  0x003efe86, 0x003f7f03, 0x3ffe0005, 0x333319ba,
  0x003eff04, 0x003f7f82, 0xffffe669, 0xffffd576,
  0x003eff82, 0x6666664e, 0xaaaa8003, 0xfffe8026,
  0x3333331a, 0x5555552c, 0x7ffe800b, 0xffff0024,
  0xffffffd6, 0x7ffffe84, 0x7fff0008, 0xffff8022,
  0xfffffe86, 0x7fffff03, 0x7fff8005, 0x00000020,
  0xffffff04, 0x7fffff82, 0x80000002, 0x0000801e,
  0xffffff82, 0x80000001, 0x80007fff, 0xffffaacc,
  0x00000000, 0x80000080, 0x55550004, 0xcccc6688,
  0x0000007e, 0xaaaaaa57, 0xffff999e, 0xc0010020,
  0xffffffac, 0x99999935, 0xc0018002, 0xc001801e,
  0xcccccc68, 0xffc08001, 0xc001ffff, 0xc002001c,
  0xffc10000, 0xffc08080, 0xc0027ffc, 0xc002801a,
  0xffc1007e, 0xffc080ff, 0xc002fff9, 0xffc00120,
  0xffc100fc, 0xffc0817e, 0xffc00182, 0xffc0811e,
  0xffc1017a, 0xffffc081, 0xffc0817f, 0xffc1011c,
  0xffffc100, 0xffffc100, 0xffc1017c, 0xffc1811a,
  0xffffc17e, 0xffffc17f, 0xffc18179, 0xfff00060,
  0xffffc1fc, 0xffffc1fe, 0xfff00062, 0xfffe8026,
  0xffffc27a, 0xfffff021, 0xfffe800b, 0xffff0024,
  0xfffff040, 0xfffffe84, 0xffff0008, 0xffff8022,
  0xfffffe83, 0xffff0007, 0xffff8004, 0x00000020,
  0xffffff02, 0xffff8004, 0x00000002, 0x0000801f,
  0xffffff81, 0x00000001, 0x00008000, 0x0001001e,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00100000,
  0x0000007f, 0x0000fffb, 0x000fffc2, 0x003e7fa3,
  0x000000fe, 0x000fffa1, 0x003e7f08, 0x003effa2,
  0x00000fe0, 0x003e7e8a, 0x003eff06, 0x003f7fa1,
  0x00003e03, 0x003efe87, 0x003f7f04, 0x3ffe0023,
  0x00003e82, 0x003f7e84, 0x3ffd8008, 0x3ffe8022,
  0x00003f01, 0x3ffd000a, 0x3ffe0006, 0x3fff0021,
  0x003f7e83, 0x3ffd8007, 0x3ffe8004, 0x66664ced,
  0x003f7f02, 0x3ffe0004, 0x3333199c, 0x55552acb,
  0x003f7f81, 0xffffe668, 0xffffd558, 0x7ffe8023,
  0x6666664d, 0xaaaa8002, 0xfffe8008, 0x7fff0022,
  0x5555552b, 0x7ffe800a, 0xffff0006, 0x7fff8021,
  0x7ffffe83, 0x7fff0007, 0xffff8004, 0x80000020,
  0x7fffff02, 0x7fff8004, 0x00000002, 0x8000801f,
  0x7fffff81, 0x80000001, 0x00008000, 0xaaaa5576,
  0x80000000, 0x80007ffe, 0xffffaaae, 0x99993354,
  0x8000007f, 0x55550003, 0xcccc666a, 0xc0008020,
  0xaaaaaa56, 0xffff999d, 0xc0010002, 0xc001001f,
  0x99999934, 0xc0018001, 0xc0018000, 0xc001801e,
  0xffc08000, 0xc001fffe, 0xc001fffe, 0xc002001d,
  0xffc0807f, 0xc0027ffb, 0xc0027ffc, 0xffc000a0,
  0xffc080fe, 0xc002fff8, 0xffc00102, 0xffc0809f,
  0xffc0817d, 0xffc00181, 0xffc08100, 0xffc1009e,
  0xffffc080, 0xffc0817e, 0xffc100fe, 0xffc1809d,
  0xffffc0ff, 0xffc1017b, 0xffc180fc, 0xfff00040,
  0xffffc17e, 0xffc18178, 0xfff00042, 0xfffe8023,
  0xffffc1fd, 0xfff00061, 0xfffe8008, 0xffff0022,
  0xfffff020, 0xfffe800a, 0xffff0006, 0xffff8021,
  0xfffe8009, 0xffff0005, 0xffff8003, 0x00000020,
  0xffff0006, 0xffff8003, 0x00000002, 0x33333353,
  0xffff8003, 0x00000001, 0x00008001, 0x66666686,
  0x00000000, 0x00007fff, 0x00010000, 0x66666680,
  0x00007ffd, 0x0000fffd, 0x000fffe2, 0x00000007,
  0x0000fffa, 0x000fffc1, 0x003e7f85, 0x3333333a,
  0x000fffa0, 0x003e7f07, 0x003eff84, 0x6666666d,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0xffffe687,
  0x003efe86, 0x003f7f03, 0x3ffe0005, 0x333319ba,
  0x003f7e83, 0x3ffd8007, 0x3ffe8004, 0x66664ced,
  0x3ffd0009, 0x3ffe0005, 0x3fff0003, 0xc28f5c49,
  0x3ffd8006, 0x3ffe8003, 0x66664ccf, 0xeeeeef0f,
  0x3ffe0003, 0x3333199b, 0x55552aad, 0xe6666687,
  0xffffe667, 0xffffd557, 0x7ffe8005, 0x199999ba,
  0xaaaa8001, 0xfffe8007, 0x7fff0004, 0x4ccccced,
  0x7ffe8009, 0xffff0005, 0x7fff8003, 0x80000020,
  0x7fff0006, 0xffff8003, 0x80000002, 0xb3333353,
  0x7fff8003, 0x00000001, 0x80008001, 0xddddddfe,
  0x80000000, 0x00007fff, 0xaaaa5558, 0x0a3d70c4,
  0x80007ffd, 0xffffaaad, 0x99993336, 0x66668020,
  0x55550002, 0xcccc6669, 0xc0008002, 0x9999b353,
  0xffff999c, 0xc0010001, 0xc0010001, 0xcccce686,
  0xc0018000, 0xc0017fff, 0xc0018000, 0x000019b9,
  0xc001fffd, 0xc001fffd, 0xc001ffff, 0x666666a0,
  0xc0027ffa, 0xc0027ffb, 0xffc00082, 0x999999d3,
  0xc002fff7, 0xffc00101, 0xffc08081, 0xcccccd06,
  0xffc00180, 0xffc080ff, 0xffc10080, 0x00000039,
  0xffc0817d, 0xffc100fd, 0xffc1807f, 0x999999c0,
  0xffc1017a, 0xffc180fb, 0xfff00022, 0x66666687,
  0xffc18177, 0xfff00041, 0xfffe8005, 0x999999ba,
  0xfff00060, 0xfffe8007, 0xffff0004, 0xcccccced,
  0xfffe8006, 0xffff0003, 0xcccccccf, 0x00000020,
  0xffff0004, 0xffff8002, 0x00000002, 0x55555575,
  0xffff8002, 0x00000001, 0x33333335, 0xaaaaaaca,
  0x00000000, 0x00008000, 0x66666668, 0xaaaaaac0,
  0x00007ffe, 0x0000ffff, 0x66666662, 0xaaaaaaa1,
  0x0000fffc, 0x000fffe1, 0xffffffe9, 0xfffffff6,
  0x000fffc0, 0x003e7f84, 0x3333331c, 0x5555554b,
  0x003e7f06, 0x003eff83, 0x6666664f, 0xaaaa8021,
  0x003eff04, 0x003f7f82, 0xffffe669, 0xffffd576,
  0x003f7f02, 0x3ffe0004, 0x3333199c, 0x55552acb,
  0x3ffd8006, 0x3ffe8003, 0x66664ccf, 0xeeeeef0f,
  0x3ffe0004, 0x3fff0002, 0xc28f5c2b, 0x38e38e59,
  0x3ffe8002, 0x66664cce, 0xeeeeeef1, 0x80000021,
  0x3333199a, 0x55552aac, 0xe6666669, 0xd5555576,
  0xffffd556, 0x7ffe8004, 0x1999999c, 0x2aaaaacb,
  0xfffe8006, 0x7fff0003, 0x4ccccccf, 0x80000020,
  0xffff0004, 0x7fff8002, 0x80000002, 0xd5555575,
  0xffff8002, 0x80000001, 0xb3333335, 0x71c71c92,
  0x00000000, 0x80008000, 0xdddddde0, 0xbbbbbbdc,
  0x00007ffe, 0xaaaa5557, 0x0a3d70a6, 0x55558020,
  0xffffaaac, 0x99993335, 0x66668002, 0xaaaad575,
  0xcccc6668, 0xc0008001, 0x9999b335, 0x00002aca,
  0xc0010000, 0xc0010000, 0xcccce668, 0x5555801f,
  0xc0017ffe, 0xc0017fff, 0x0000199b, 0x555555a0,
  0xc001fffc, 0xc001fffe, 0x66666682, 0xaaaaaaf5,
  0xc0027ffa, 0xffc00081, 0x999999b5, 0x0000004a,
  0xffc00100, 0xffc08080, 0xcccccce8, 0x5555559f,
  0xffc080fe, 0xffc1007f, 0x0000001b, 0x55555580,
  0xffc100fc, 0xffc1807e, 0x999999a2, 0x00000021,
  0xffc180fa, 0xfff00021, 0x66666669, 0x55555576,
  0xfff00040, 0xfffe8004, 0x9999999c, 0xaaaaaacb,
  0xfffe8003, 0x9999999b, 0xaaaaaaad, 0x00000020,
  0xffff0002, 0xccccccce, 0x00000002, 0x8000001d,
  0xffff8001, 0x00000001, 0x55555557, 0x0000001a,
  0x00000000, 0x33333334, 0xaaaaaaac, 0xffffffc0,
  0x00007fff, 0x66666667, 0xaaaaaaa2, 0x7ffffea9,
  0x0000fffe, 0x66666661, 0xaaaaaa83, 0xfffffea6,
  0x000fffe0, 0xffffffe8, 0xffffffd8, 0x7ffffea3,
  0x003e7f83, 0x3333331b, 0x5555552d, 0x7ffe8029,
  0x003eff82, 0x6666664e, 0xaaaa8003, 0xfffe8026,
  0x003f7f81, 0xffffe668, 0xffffd558, 0x7ffe8023,
  0x3ffe0003, 0x3333199b, 0x55552aad, 0xe6666687,
  0x3ffe8002, 0x66664cce, 0xeeeeeef1, 0x80000021,
  0x3fff0001, 0xc28f5c2a, 0x38e38e3b, 0x00000029,
  0x66664ccd, 0xeeeeeef0, 0x80000003, 0x80000026,
  0x55552aab, 0xe6666668, 0xd5555558, 0x00000023,
  0x7ffe8003, 0x1999999b, 0x2aaaaaad, 0x80000020,
  0x7fff0002, 0x4cccccce, 0x80000002, 0x0000001d,
  0x7fff8001, 0x80000001, 0xd5555557, 0x00000022,
  0x80000000, 0xb3333334, 0x71c71c74, 0x999999bc,
  0x80007fff, 0xdddddddf, 0xbbbbbbbe, 0x00018020,
  0xaaaa5556, 0x0a3d70a5, 0x55558002, 0x8001801d,
  0x99993334, 0x66668001, 0xaaaad557, 0x0001801a,
  0xc0008000, 0x9999b334, 0x00002aac, 0x80018017,
  0xc000ffff, 0xcccce667, 0x55558001, 0x000001a0,
  0xc0017ffe, 0x0000199a, 0x55555582, 0x8000019d,
  0xc001fffd, 0x66666681, 0xaaaaaad7, 0x0000019a,
  0xffc00080, 0x999999b4, 0x0000002c, 0x80000197,
  0xffc0807f, 0xcccccce7, 0x55555581, 0x00000080,
  0xffc1007e, 0x0000001a, 0x55555562, 0x80000029,
  0xffc1807d, 0x999999a1, 0x00000003, 0x00000026,
  0xfff00020, 0x66666668, 0x55555558, 0x80000023,
  0x66666667, 0x55555557, 0x80000005, 0x00000020,
  0x9999999a, 0xaaaaaaac, 0x00000002, 0x8000001e,
  0xcccccccd, 0x00000001, 0x7fffffff, 0x0000001c,
  0x00000000, 0x55555556, 0xfffffffc, 0xffffffe0,
  0x33333333, 0xaaaaaaab, 0xffffffa2, 0x7fffff26,
  0x66666666, 0xaaaaaaa1, 0x7ffffe8b, 0xffffff24,
  0x66666660, 0xaaaaaa82, 0xfffffe88, 0x7fffff22,
  0xffffffe7, 0xffffffd7, 0x7ffffe85, 0x7fff0026,
  0x3333331a, 0x5555552c, 0x7ffe800b, 0xffff0024,
  0x6666664d, 0xaaaa8002, 0xfffe8008, 0x7fff0022,
  0xffffe667, 0xffffd557, 0x7ffe8005, 0x199999ba,
  0x3333199a, 0x55552aac, 0xe6666669, 0xd5555576,
  0x66664ccd, 0xeeeeeef0, 0x80000003, 0x80000026,
  0xc28f5c29, 0x38e38e3a, 0x0000000b, 0x00000024,
  0xeeeeeeef, 0x80000002, 0x80000008, 0x80000022,
  0xe6666667, 0xd5555557, 0x00000005, 0x00000020,
  0x1999999a, 0x2aaaaaac, 0x80000002, 0x8000001e,
  0x4ccccccd, 0x80000001, 0xffffffff, 0xaaaaaacc,
  0x80000000, 0xd5555556, 0x00000004, 0x66666688,
  0xb3333333, 0x71c71c73, 0x9999999e, 0x00010020,
  0xddddddde, 0xbbbbbbbd, 0x00018002, 0x8001001e,
  0x0a3d70a4, 0x55558001, 0x80017fff, 0x0001001c,
  0x66668000, 0xaaaad556, 0x00017ffc, 0x8001001a,
  0x9999b333, 0x00002aab, 0x80017ff9, 0x00000120,
  0xcccce666, 0x55558000, 0x00000182, 0x8000011e,
  0x00001999, 0x55555581, 0x8000017f, 0x0000011c,
  0x66666680, 0xaaaaaad6, 0x0000017c, 0x8000011a,
  0x999999b3, 0x0000002b, 0x80000179, 0x00000060,
  0xcccccce6, 0x55555580, 0x00000062, 0x80000026,
  0x00000019, 0x55555561, 0x8000000b, 0x00000024,
  0x999999a0, 0x00000002, 0x00000008, 0x80000022,
  0x00000001, 0x00000007, 0x80000004, 0x00000020,
  0x55555556, 0x80000004, 0x00000002, 0x8000001f,
  0xaaaaaaab, 0x00000001, 0x80000000, 0x0000001e,
  0x00000000, 0x7ffffffe, 0xfffffffe, 0x00000000,
  0x55555555, 0xfffffffb, 0xffffffc2, 0x7fffffa3,
  0xaaaaaaaa, 0xffffffa1, 0x7fffff08, 0xffffffa2,
  0xaaaaaaa0, 0x7ffffe8a, 0xffffff06, 0x7fffffa1,
  0xaaaaaa81, 0xfffffe87, 0x7fffff04, 0x7fff8023,
  0xffffffd6, 0x7ffffe84, 0x7fff0008, 0xffff8022,
  0x5555552b, 0x7ffe800a, 0xffff0006, 0x7fff8021,
  0xaaaa8001, 0xfffe8007, 0x7fff0004, 0x4ccccced,
  0xffffd556, 0x7ffe8004, 0x1999999c, 0x2aaaaacb,
  0x55552aab, 0xe6666668, 0xd5555558, 0x00000023,
  0xeeeeeeef, 0x80000002, 0x80000008, 0x80000022,
  0x38e38e39, 0x0000000a, 0x00000006, 0x00000021,
  0x80000001, 0x80000007, 0x80000004, 0x80000020,
  0xd5555556, 0x00000004, 0x00000002, 0x0000001f,
  0x2aaaaaab, 0x80000001, 0x80000000, 0x55555576,
  0x80000000, 0xfffffffe, 0xaaaaaaae, 0x33333354,
  0xd5555555, 0x00000003, 0x6666666a, 0x00008020,
  0x71c71c72, 0x9999999d, 0x00010002, 0x8000801f,
  0xbbbbbbbc, 0x00018001, 0x80010000, 0x0000801e,
  0x55558000, 0x80017ffe, 0x0000fffe, 0x8000801d,
  0xaaaad555, 0x00017ffb, 0x8000fffc, 0x000000a0,
  0x00002aaa, 0x80017ff8, 0x00000102, 0x8000009f,
  0x55557fff, 0x00000181, 0x80000100, 0x0000009e,
  0x55555580, 0x8000017e, 0x000000fe, 0x8000009d,
  0xaaaaaad5, 0x0000017b, 0x800000fc, 0x00000040,
  0x0000002a, 0x80000178, 0x00000042, 0x80000023,
  0x5555557f, 0x00000061, 0x80000008, 0x00000022,
  0x55555560, 0x8000000a, 0x00000006, 0x80000021,
  0x80000009, 0x00000005, 0x80000003, 0x00000020,
  0x00000006, 0x80000003, 0x00000002, 0x80000020,
  0x80000003, 0x00000001, 0x80000001, 0x00000020,
  0x00000000, 0x7fffffff, 0x00000000, 0x00000020,
  0x7ffffffd, 0xfffffffd, 0xffffffe2, 0x80000020,
  0xfffffffa, 0xffffffc1, 0x7fffff85, 0x00000020,
  0xffffffa0, 0x7fffff07, 0xffffff84, 0x80000020,
  0x7ffffe89, 0xffffff05, 0x7fffff83, 0x80000020,
  0xfffffe86, 0x7fffff03, 0x7fff8005, 0x00000020,
  0x7ffffe83, 0x7fff0007, 0xffff8004, 0x80000020,
  0x7ffe8009, 0xffff0005, 0x7fff8003, 0x80000020,
  0xfffe8006, 0x7fff0003, 0x4ccccccf, 0x80000020,
  0x7ffe8003, 0x1999999b, 0x2aaaaaad, 0x80000020,
  0xe6666667, 0xd5555557, 0x00000005, 0x00000020,
  0x80000001, 0x80000007, 0x80000004, 0x80000020,
  0x00000009, 0x00000005, 0x00000003, 0x00000020,
  0x80000006, 0x80000003, 0x80000002, 0x80000020,
  0x00000003, 0x00000001, 0x00000001, 0x00000020,
  0x80000000, 0x7fffffff, 0x55555558, 0x00000020,
  0xfffffffd, 0xaaaaaaad, 0x33333336, 0x00000020,
  0x00000002, 0x66666669, 0x00008002, 0x80000020,
  0x9999999c, 0x00010001, 0x80008001, 0x00000020,
  0x00018000, 0x8000ffff, 0x00008000, 0x80000020,
  0x80017ffd, 0x0000fffd, 0x80007fff, 0x00000020,
  0x00017ffa, 0x8000fffb, 0x00000082, 0x80000020,
  0x80017ff7, 0x00000101, 0x80000081, 0x00000020,
  0x00000180, 0x800000ff, 0x00000080, 0x80000020,
  0x8000017d, 0x000000fd, 0x8000007f, 0x00000020,
  0x0000017a, 0x800000fb, 0x00000022, 0x80000020,
  0x80000177, 0x00000041, 0x80000005, 0x00000020,
  0x00000060, 0x80000007, 0x00000004, 0x80000020,
  0x80000006, 0x00000003, 0x80000002, 0x00000020,
  0x00000004, 0x80000002, 0x00000002, 0x80000021,
  0x80000002, 0x00000001, 0x80000002, 0x00000022,
  0x00000000, 0x80000000, 0x00000002, 0x00000040,
  0x7ffffffe, 0xffffffff, 0x00000002, 0x8000009d,
  0xfffffffc, 0xffffffe1, 0x80000002, 0x0000009e,
  0xffffffc0, 0x7fffff84, 0x00000002, 0x8000009f,
  0x7fffff06, 0xffffff83, 0x80000002, 0x8000801d,
  0xffffff04, 0x7fffff82, 0x80000002, 0x0000801e,
  0x7fffff02, 0x7fff8004, 0x00000002, 0x8000801f,
  0x7fff0006, 0xffff8003, 0x80000002, 0xb3333353,
  0xffff0004, 0x7fff8002, 0x80000002, 0xd5555575,
  0x7fff0002, 0x4cccccce, 0x80000002, 0x0000001d,
  0x1999999a, 0x2aaaaaac, 0x80000002, 0x8000001e,
  0xd5555556, 0x00000004, 0x00000002, 0x0000001f,
  0x80000006, 0x80000003, 0x80000002, 0x80000020,
  0x00000004, 0x00000002, 0x00000002, 0x00000021,
  0x80000002, 0x80000001, 0x80000002, 0xaaaaaaca,
  0x00000000, 0x00000000, 0x00000002, 0xccccccec,
  0x7ffffffe, 0x55555557, 0x00000002, 0xffff8020,
  0xaaaaaaac, 0x33333335, 0x00000002, 0x7fff8021,
  0x66666668, 0x00008001, 0x80000002, 0xffff8022,
  0x00010000, 0x80008000, 0x00000002, 0x7fff8023,
  0x8000fffe, 0x00007fff, 0x80000002, 0xffffffa0,
  0x0000fffc, 0x80007ffe, 0x00000002, 0x7fffffa1,
  0x8000fffa, 0x00000081, 0x80000002, 0xffffffa2,
  0x00000100, 0x80000080, 0x00000002, 0x7fffffa3,
  0x800000fe, 0x0000007f, 0x80000002, 0x00000000,
  0x000000fc, 0x8000007e, 0x00000002, 0x8000001d,
  0x800000fa, 0x00000021, 0x80000002, 0x0000001e,
  0x00000040, 0x80000004, 0x00000002, 0x8000001f,
  0x80000003, 0x00000001, 0x80000001, 0x00000020,
  0x00000002, 0x80000001, 0x00000002, 0xaaaaaaca,
  0x80000001, 0x00000001, 0x80000003, 0x55555574,
  0x00000000, 0x80000001, 0x00000004, 0x55555560,
  0x7fffffff, 0x00000001, 0x00000022, 0x55555522,
  0xfffffffe, 0x00000001, 0x8000007f, 0xffffffcc,
  0xffffffe0, 0x80000001, 0x00000080, 0xaaaaaa76,
  0x7fffff83, 0x00000001, 0x80000081, 0x55550022,
  0xffffff82, 0x80000001, 0x80007fff, 0xffffaacc,
  0x7fffff81, 0x80000001, 0x00008000, 0xaaaa5576,
  0x7fff8003, 0x00000001, 0x80008001, 0xddddddfe,
  0xffff8002, 0x80000001, 0xb3333335, 0x71c71c92,
  0x7fff8001, 0x80000001, 0xd5555557, 0x00000022,
  0x4ccccccd, 0x80000001, 0xffffffff, 0xaaaaaacc,
  0x2aaaaaab, 0x80000001, 0x80000000, 0x55555576,
  0x00000003, 0x00000001, 0x00000001, 0x00000020,
  0x80000002, 0x80000001, 0x80000002, 0xaaaaaaca,
  0x00000001, 0x00000001, 0x00000003, 0xe38e3904,
  0x80000000, 0x80000001, 0xaaaaaaac, 0x77777798,
  0xffffffff, 0x00000001, 0xccccccce, 0xaaab0020,
  0x55555556, 0x00000001, 0xffff8002, 0x5555aaca,
  0x33333334, 0x00000001, 0x7fff8003, 0x00005574,
  0x00008000, 0x80000001, 0xffff8004, 0xaaab001e,
  0x80007fff, 0x00000001, 0x7fff8005, 0xaaaaab20,
  0x00007ffe, 0x80000001, 0xffffff82, 0x555555ca,
  0x80007ffd, 0x00000001, 0x7fffff83, 0x00000074,
  0x00000080, 0x80000001, 0xffffff84, 0xaaaaab1e,
  0x8000007f, 0x00000001, 0x7fffff85, 0xaaaaaae0,
  0x0000007e, 0x80000001, 0xffffffe2, 0x00000022,
  0x8000007d, 0x00000001, 0x7fffffff, 0xaaaaaacc,
  0x00000020, 0x80000001, 0x00000000, 0x55555576,
  0x80000000, 0xffffffff, 0x55555558, 0x00000020,
  0x00000000, 0x80000000, 0x00000002, 0xccccccec,
  0x80000000, 0x00000001, 0xaaaaaaac, 0x999999b8,
  0x00000000, 0x80000002, 0x55555556, 0x999999a0,
  0x80000000, 0x00000003, 0x55555542, 0xffffffbc,
  0x00000000, 0x00000021, 0x55555504, 0xcccccc88,
  0x00000000, 0x8000007e, 0xffffffae, 0x99999954,
  0x80000000, 0x0000007f, 0xaaaaaa58, 0xffff99bc,
  0x00000000, 0x80000080, 0x55550004, 0xcccc6688,
  0x80000000, 0x80007ffe, 0xffffaaae, 0x99993354,
  0x80000000, 0x00007fff, 0xaaaa5558, 0x0a3d70c4,
  0x00000000, 0x80008000, 0xdddddde0, 0xbbbbbbdc,
  0x80000000, 0xb3333334, 0x71c71c74, 0x999999bc,
  0x80000000, 0xd5555556, 0x00000004, 0x66666688,
  0x80000000, 0xfffffffe, 0xaaaaaaae, 0x33333354,
  0x80000000, 0x7fffffff, 0x55555558, 0x00000020,
  0x00000000, 0x00000000, 0x00000002, 0xccccccec,
  0x80000000, 0x80000001, 0xaaaaaaac, 0x77777798,
  0x00000000, 0x00000002, 0xe38e38e6, 0x28f5c2b0,
  0x80000000, 0xaaaaaaab, 0x7777777a, 0x999a0020,
  0x00000000, 0xcccccccd, 0xaaab0002, 0x6666ccec,
  0x00000000, 0xffff8001, 0x5555aaac, 0x333399b8,
  0x00000000, 0x7fff8002, 0x00005556, 0x00006684,
  0x80000000, 0xffff8003, 0xaaab0000, 0x99999a20,
  0x00000000, 0x7fff8004, 0xaaaaab02, 0x666666ec,
  0x80000000, 0xffffff81, 0x555555ac, 0x333333b8,
  0x00000000, 0x7fffff82, 0x00000056, 0x00000084,
  0x80000000, 0xffffff83, 0xaaaaab00, 0x666666a0,
  0x00000000, 0x7fffff84, 0xaaaaaac2, 0x999999bc,
  0x80000000, 0xffffffe1, 0x00000004, 0x66666688,
  0x00000000, 0x7ffffffe, 0xaaaaaaae, 0x33333354,
  0x7ffffffd, 0xaaaaaaad, 0x33333336, 0x00000020,
  0xfffffffe, 0x55555557, 0x00000002, 0xffff8020,
  0x7fffffff, 0x00000001, 0xccccccce, 0xffff0020,
  0x00000000, 0xaaaaaaab, 0x9999999a, 0xfff00020,
  0x80000001, 0x55555555, 0x99999982, 0xffc18020,
  0x00000002, 0x55555541, 0xffffff9e, 0xffc10020,
  0x00000020, 0x55555503, 0xcccccc6a, 0xffc08020,
  0x8000007d, 0xffffffad, 0x99999936, 0xc0018020,
  0x0000007e, 0xaaaaaa57, 0xffff999e, 0xc0010020,
  0x8000007f, 0x55550003, 0xcccc666a, 0xc0008020,
  0x80007ffd, 0xffffaaad, 0x99993336, 0x66668020,
  0x00007ffe, 0xaaaa5557, 0x0a3d70a6, 0x55558020,
  0x80007fff, 0xdddddddf, 0xbbbbbbbe, 0x00018020,
  0xb3333333, 0x71c71c73, 0x9999999e, 0x00010020,
  0xd5555555, 0x00000003, 0x6666666a, 0x00008020,
  0xfffffffd, 0xaaaaaaad, 0x33333336, 0x00000020,
  0x7ffffffe, 0x55555557, 0x00000002, 0xffff8020,
  0xffffffff, 0x00000001, 0xccccccce, 0xaaab0020,
  0x80000000, 0xaaaaaaab, 0x7777777a, 0x999a0020,
  0x00000001, 0xe38e38e5, 0x28f5c292, 0x40000020,
  0xaaaaaaaa, 0x77777779, 0x999a0002, 0x3fff8020,
  0xcccccccc, 0xaaab0001, 0x6666ccce, 0x3fff0020,
  0xffff8000, 0x5555aaab, 0x3333999a, 0x3ffe8020,
  0x7fff8001, 0x00005555, 0x00006666, 0x00400020,
  0xffff8002, 0xaaaaffff, 0x99999a02, 0x003f8020,
  0x7fff8003, 0xaaaaab01, 0x666666ce, 0x003f0020,
  0xffffff80, 0x555555ab, 0x3333339a, 0x003e8020,
  0x7fffff81, 0x00000055, 0x00000066, 0x00100020,
  0xffffff82, 0xaaaaaaff, 0x66666682, 0x00018020,
  0x7fffff83, 0xaaaaaac1, 0x9999999e, 0x00010020,
  0xffffffe0, 0x00000003, 0x6666666a, 0x00008020,
  0x00000002, 0x66666669, 0x00008002, 0x00000020,
  0xaaaaaaac, 0x33333335, 0x00000002, 0xffff8021,
  0x55555556, 0x00000001, 0xffff8002, 0xffff0022,
  0x00000000, 0xcccccccd, 0xffff0002, 0xfff00040,
  0xaaaaaaaa, 0x99999999, 0xfff00002, 0xffc1809d,
  0x55555554, 0x99999981, 0xffc18002, 0xffc1009e,
  0x55555540, 0xffffff9d, 0xffc10002, 0xffc0809f,
  0x55555502, 0xcccccc69, 0xffc08002, 0xc002001d,
  0xffffffac, 0x99999935, 0xc0018002, 0xc001801e,
  0xaaaaaa56, 0xffff999d, 0xc0010002, 0xc001001f,
  0x55550002, 0xcccc6669, 0xc0008002, 0x9999b353,
  0xffffaaac, 0x99993335, 0x66668002, 0xaaaad575,
  0xaaaa5556, 0x0a3d70a5, 0x55558002, 0x8001801d,
  0xddddddde, 0xbbbbbbbd, 0x00018002, 0x8001001e,
  0x71c71c72, 0x9999999d, 0x00010002, 0x8000801f,
  0x00000002, 0x66666669, 0x00008002, 0x80000020,
  0xaaaaaaac, 0x33333335, 0x00000002, 0x7fff8021,
  0x55555556, 0x00000001, 0xffff8002, 0x5555aaca,
  0x00000000, 0xcccccccd, 0xaaab0002, 0x6666ccec,
  0xaaaaaaaa, 0x77777779, 0x999a0002, 0x3fff8020,
  0xe38e38e4, 0x28f5c291, 0x40000002, 0x3fff0021,
  0x77777778, 0x999a0001, 0x3fff8002, 0x3ffe8022,
  0xaaab0000, 0x6666cccd, 0x3fff0002, 0x3ffe0023,
  0x5555aaaa, 0x33339999, 0x3ffe8002, 0x003fffa0,
  0x00005554, 0x00006665, 0x00400002, 0x003f7fa1,
  0xaaaafffe, 0x99999a01, 0x003f8002, 0x003effa2,
  0xaaaaab00, 0x666666cd, 0x003f0002, 0x003e7fa3,
  0x555555aa, 0x33333399, 0x003e8002, 0x00100000,
  0x00000054, 0x00000065, 0x00100002, 0x0001801d,
  0xaaaaaafe, 0x66666681, 0x00018002, 0x0001001e,
  0xaaaaaac0, 0x9999999d, 0x00010002, 0x0000801f,
  0x9999999c, 0x00010001, 0x00008001, 0x00000020,
  0x66666668, 0x00008001, 0x00000002, 0xffff8022,
  0x33333334, 0x00000001, 0xffff8003, 0xffff0024,
  0x00000000, 0xffff8001, 0xffff0004, 0xfff00060,
  0xcccccccc, 0xffff0001, 0xfff00022, 0xffc1811a,
  0x99999998, 0xfff00001, 0xffc1807f, 0xffc1011c,
  0x99999980, 0xffc18001, 0xffc10080, 0xffc0811e,
  0xffffff9c, 0xffc10001, 0xffc08081, 0xc002801a,
  0xcccccc68, 0xffc08001, 0xc001ffff, 0xc002001c,
  0x99999934, 0xc0018001, 0xc0018000, 0xc001801e,
  0xffff999c, 0xc0010001, 0xc0010001, 0xcccce686,
  0xcccc6668, 0xc0008001, 0x9999b335, 0x00002aca,
  0x99993334, 0x66668001, 0xaaaad557, 0x0001801a,
  0x0a3d70a4, 0x55558001, 0x80017fff, 0x0001001c,
  0xbbbbbbbc, 0x00018001, 0x80010000, 0x0000801e,
  0x9999999c, 0x00010001, 0x80008001, 0x00000020,
  0x66666668, 0x00008001, 0x80000002, 0xffff8022,
  0x33333334, 0x00000001, 0x7fff8003, 0x00005574,
  0x00000000, 0xffff8001, 0x5555aaac, 0x333399b8,
  0xcccccccc, 0xaaab0001, 0x6666ccce, 0x3fff0020,
  0x77777778, 0x999a0001, 0x3fff8002, 0x3ffe8022,
  0x28f5c290, 0x40000001, 0x3fff0003, 0x3ffe0024,
  0x999a0000, 0x3fff8001, 0x3ffe8004, 0x3ffd8026,
  0x6666cccc, 0x3fff0001, 0x3ffe0005, 0x003fff20,
  0x33339998, 0x3ffe8001, 0x003fff82, 0x003f7f22,
  0x00006664, 0x00400001, 0x003f7f83, 0x003eff24,
  0x99999a00, 0x003f8001, 0x003eff84, 0x003e7f26,
  0x666666cc, 0x003f0001, 0x003e7f85, 0x000fffe0,
  0x33333398, 0x003e8001, 0x000fffe2, 0x0001801a,
  0x00000064, 0x00100001, 0x00017fff, 0x0001001c,
  0x66666680, 0x00018001, 0x00010000, 0x0000801e,
  0x00018000, 0x0000ffff, 0x00008000, 0x00000020,
  0x00010000, 0x00008000, 0x00000002, 0xffff8023,
  0x00008000, 0x00000001, 0xffff8004, 0xffff0026,
  0x00000000, 0xffff8002, 0xffff0006, 0xfff00080,
  0xffff8000, 0xffff0003, 0xfff00042, 0xffc18197,
  0xffff0000, 0xfff00021, 0xffc180fc, 0xffc1019a,
  0xfff00000, 0xffc1807e, 0xffc100fe, 0xffc0819d,
  0xffc18000, 0xffc1007f, 0xffc08100, 0xc0030017,
  0xffc10000, 0xffc08080, 0xc0027ffc, 0xc002801a,
  0xffc08000, 0xc001fffe, 0xc001fffe, 0xc002001d,
  0xc0018000, 0xc0017fff, 0xc0018000, 0x000019b9,
  0xc0010000, 0xc0010000, 0xcccce668, 0x5555801f,
  0xc0008000, 0x9999b334, 0x00002aac, 0x80018017,
  0x66668000, 0xaaaad556, 0x00017ffc, 0x8001001a,
  0x55558000, 0x80017ffe, 0x0000fffe, 0x8000801d,
  0x00018000, 0x8000ffff, 0x00008000, 0x80000020,
  0x00010000, 0x80008000, 0x00000002, 0x7fff8023,
  0x00008000, 0x80000001, 0xffff8004, 0xaaab001e,
  0x00000000, 0x7fff8002, 0x00005556, 0x00006684,
  0xffff8000, 0x5555aaab, 0x3333999a, 0x3ffe8020,
  0xaaab0000, 0x6666cccd, 0x3fff0002, 0x3ffe0023,
  0x999a0000, 0x3fff8001, 0x3ffe8004, 0x3ffd8026,
  0x40000000, 0x3fff0002, 0x3ffe0006, 0x3ffd0029,
  0x3fff8000, 0x3ffe8003, 0x3ffd8008, 0x003ffea0,
  0x3fff0000, 0x3ffe0004, 0x003fff02, 0x003f7ea3,
  0x3ffe8000, 0x003fff81, 0x003f7f04, 0x003efea6,
  0x00400000, 0x003f7f82, 0x003eff06, 0x003e7ea9,
  0x003f8000, 0x003eff83, 0x003e7f08, 0x000fffc0,
  0x003f0000, 0x003e7f84, 0x000fffc2, 0x00018017,
  0x003e8000, 0x000fffe1, 0x00017ffc, 0x0001001a,
  0x00100000, 0x00017ffe, 0x0000fffe, 0x0000801d,
  0x00017ffd, 0x0000fffd, 0x00007fff, 0x00000020,
  0x0000fffe, 0x00007fff, 0x00000002, 0xffffffa0,
  0x00007fff, 0x00000001, 0xffff8005, 0xffffff20,
  0x00000000, 0xffff8003, 0xffff0008, 0xfffff020,
  0xffff8001, 0xffff0005, 0xfff00062, 0xffffc1a0,
  0xffff0002, 0xfff00041, 0xffc18179, 0xffffc120,
  0xfff00020, 0xffc180fb, 0xffc1017c, 0xffffc0a0,
  0xffc1807d, 0xffc100fd, 0xffc0817f, 0xffc001a0,
  0xffc1007e, 0xffc080ff, 0xc002fff9, 0xffc00120,
  0xffc0807f, 0xc0027ffb, 0xc0027ffc, 0xffc000a0,
  0xc001fffd, 0xc001fffd, 0xc001ffff, 0x666666a0,
  0xc0017ffe, 0xc0017fff, 0x0000199b, 0x555555a0,
  0xc000ffff, 0xcccce667, 0x55558001, 0x000001a0,
  0x9999b333, 0x00002aab, 0x80017ff9, 0x00000120,
  0xaaaad555, 0x00017ffb, 0x8000fffc, 0x000000a0,
  0x80017ffd, 0x0000fffd, 0x80007fff, 0x00000020,
  0x8000fffe, 0x00007fff, 0x80000002, 0xffffffa0,
  0x80007fff, 0x00000001, 0x7fff8005, 0xaaaaab20,
  0x80000000, 0xffff8003, 0xaaab0000, 0x99999a20,
  0x7fff8001, 0x00005555, 0x00006666, 0x00400020,
  0x5555aaaa, 0x33339999, 0x3ffe8002, 0x003fffa0,
  0x6666cccc, 0x3fff0001, 0x3ffe0005, 0x003fff20,
  0x3fff8000, 0x3ffe8003, 0x3ffd8008, 0x003ffea0,
  0x3fff0001, 0x3ffe0005, 0x3ffd000b, 0x00004020,
  0x3ffe8002, 0x3ffd8007, 0x003ffe82, 0x00003fa0,
  0x3ffe0003, 0x003fff01, 0x003f7e85, 0x00003f20,
  0x003fff80, 0x003f7f03, 0x003efe88, 0x00003ea0,
  0x003f7f81, 0x003eff05, 0x003e7e8b, 0x00001020,
  0x003eff82, 0x003e7f07, 0x000fffa2, 0x000001a0,
  0x003e7f83, 0x000fffc1, 0x00017ff9, 0x00000120,
  0x000fffe0, 0x00017ffb, 0x0000fffc, 0x000000a0,
  0x00017ffa, 0x0000fffb, 0x00000082, 0x00000020,
  0x0000fffc, 0x00007ffe, 0x00000002, 0xffffffa1,
  0x00007ffe, 0x00000001, 0xffffff82, 0xffffff22,
  0x00000000, 0xffff8004, 0xffffff02, 0xfffff040,
  0xffff8002, 0xffff0007, 0xfffff002, 0xffffc21d,
  0xffff0004, 0xfff00061, 0xffffc182, 0xffffc19e,
  0xfff00040, 0xffc18178, 0xffffc102, 0xffffc11f,
  0xffc180fa, 0xffc1017b, 0xffffc082, 0xffc0819d,
  0xffc100fc, 0xffc0817e, 0xffc00182, 0xffc0811e,
  0xffc080fe, 0xc002fff8, 0xffc00102, 0xffc0809f,
  0xc0027ffa, 0xc0027ffb, 0xffc00082, 0x999999d3,
  0xc001fffc, 0xc001fffe, 0x66666682, 0xaaaaaaf5,
  0xc0017ffe, 0x0000199a, 0x55555582, 0x8000019d,
  0xcccce666, 0x55558000, 0x00000182, 0x8000011e,
  0x00002aaa, 0x80017ff8, 0x00000102, 0x8000009f,
  0x00017ffa, 0x8000fffb, 0x00000082, 0x80000020,
  0x0000fffc, 0x80007ffe, 0x00000002, 0x7fffffa1,
  0x00007ffe, 0x80000001, 0xffffff82, 0x555555ca,
  0x00000000, 0x7fff8004, 0xaaaaab02, 0x666666ec,
  0xffff8002, 0xaaaaffff, 0x99999a02, 0x003f8020,
  0x00005554, 0x00006665, 0x00400002, 0x003f7fa1,
  0x33339998, 0x3ffe8001, 0x003fff82, 0x003f7f22,
  0x3fff0000, 0x3ffe0004, 0x003fff02, 0x003f7ea3,
  0x3ffe8002, 0x3ffd8007, 0x003ffe82, 0x00003fa0,
  0x3ffe0004, 0x3ffd000a, 0x00004002, 0x00003f21,
  0x3ffd8006, 0x003ffe81, 0x00003f82, 0x00003ea2,
  0x003fff00, 0x003f7e84, 0x00003f02, 0x00003e23,
  0x003f7f02, 0x003efe87, 0x00003e82, 0x00001000,
  0x003eff04, 0x003e7e8a, 0x00001002, 0x0000019d,
  0x003e7f06, 0x000fffa1, 0x00000182, 0x0000011e,
  0x000fffc0, 0x00017ff8, 0x00000102, 0x0000009f,
  0x00017ff7, 0x00000101, 0x00000081, 0x00000020,
  0x0000fffa, 0x00000081, 0x00000002, 0xffffffa2,
  0x00007ffd, 0x00000001, 0xffffff83, 0xffffff24,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff060,
  0xffff8003, 0xffffff01, 0xfffff022, 0xffffc29a,
  0xffff0006, 0xfffff001, 0xffffc1ff, 0xffffc21c,
  0xfff00060, 0xffffc181, 0xffffc180, 0xffffc19e,
  0xffc18177, 0xffffc101, 0xffffc101, 0xffc1019a,
  0xffc1017a, 0xffffc081, 0xffc0817f, 0xffc1011c,
  0xffc0817d, 0xffc00181, 0xffc08100, 0xffc1009e,
  0xc002fff7, 0xffc00101, 0xffc08081, 0xcccccd06,
  0xc0027ffa, 0xffc00081, 0x999999b5, 0x0000004a,
  0xc001fffd, 0x66666681, 0xaaaaaad7, 0x0000019a,
  0x00001999, 0x55555581, 0x8000017f, 0x0000011c,
  0x55557fff, 0x00000181, 0x80000100, 0x0000009e,
  0x80017ff7, 0x00000101, 0x80000081, 0x00000020,
  0x8000fffa, 0x00000081, 0x80000002, 0xffffffa2,
  0x80007ffd, 0x00000001, 0x7fffff83, 0x00000074,
  0x80000000, 0xffffff81, 0x555555ac, 0x333333b8,
  0x7fff8003, 0xaaaaab01, 0x666666ce, 0x003f0020,
  0xaaaafffe, 0x99999a01, 0x003f8002, 0x003effa2,
  0x00006664, 0x00400001, 0x003f7f83, 0x003eff24,
  0x3ffe8000, 0x003fff81, 0x003f7f04, 0x003efea6,
  0x3ffe0003, 0x003fff01, 0x003f7e85, 0x00003f20,
  0x3ffd8006, 0x003ffe81, 0x00003f82, 0x00003ea2,
  0x3ffd0009, 0x00004001, 0x00003f03, 0x00003e24,
  0x003ffe80, 0x00003f81, 0x00003e84, 0x00003da6,
  0x003f7e83, 0x00003f01, 0x00003e05, 0x00000fe0,
  0x003efe86, 0x00003e81, 0x00000fe2, 0x0000019a,
  0x003e7e89, 0x00001001, 0x0000017f, 0x0000011c,
  0x000fffa0, 0x00000181, 0x00000100, 0x0000009e,
  0x00000180, 0x000000ff, 0x00000080, 0x00000020,
  0x00000100, 0x00000080, 0x00000002, 0xffffffa3,
  0x00000080, 0x00000001, 0xffffff84, 0xffffff26,
  0x00000000, 0xffffff82, 0xffffff06, 0xfffff080,
  0xffffff80, 0xffffff03, 0xfffff042, 0xffffc317,
  0xffffff00, 0xfffff021, 0xffffc27c, 0xffffc29a,
  0xfffff000, 0xffffc1fe, 0xffffc1fe, 0xffffc21d,
  0xffffc180, 0xffffc17f, 0xffffc180, 0xffc18197,
  0xffffc100, 0xffffc100, 0xffc1017c, 0xffc1811a,
  0xffffc080, 0xffc0817e, 0xffc100fe, 0xffc1809d,
  0xffc00180, 0xffc080ff, 0xffc10080, 0x00000039,
  0xffc00100, 0xffc08080, 0xcccccce8, 0x5555559f,
  0xffc00080, 0x999999b4, 0x0000002c, 0x80000197,
  0x66666680, 0xaaaaaad6, 0x0000017c, 0x8000011a,
  0x55555580, 0x8000017e, 0x000000fe, 0x8000009d,
  0x00000180, 0x800000ff, 0x00000080, 0x80000020,
  0x00000100, 0x80000080, 0x00000002, 0x7fffffa3,
  0x00000080, 0x80000001, 0xffffff84, 0xaaaaab1e,
  0x00000000, 0x7fffff82, 0x00000056, 0x00000084,
  0xffffff80, 0x555555ab, 0x3333339a, 0x003e8020,
  0xaaaaab00, 0x666666cd, 0x003f0002, 0x003e7fa3,
  0x99999a00, 0x003f8001, 0x003eff84, 0x003e7f26,
  0x00400000, 0x003f7f82, 0x003eff06, 0x003e7ea9,
  0x003fff80, 0x003f7f03, 0x003efe88, 0x00003ea0,
  0x003fff00, 0x003f7e84, 0x00003f02, 0x00003e23,
  0x003ffe80, 0x00003f81, 0x00003e84, 0x00003da6,
  0x00004000, 0x00003f02, 0x00003e06, 0x00003d29,
  0x00003f80, 0x00003e83, 0x00003d88, 0x00000fc0,
  0x00003f00, 0x00003e04, 0x00000fc2, 0x00000197,
  0x00003e80, 0x00000fe1, 0x0000017c, 0x0000011a,
  0x00001000, 0x0000017e, 0x000000fe, 0x0000009d,
  0x0000017d, 0x000000fd, 0x0000007f, 0x00000020,
  0x000000fe, 0x0000007f, 0x00000002, 0x00000000,
  0x0000007f, 0x00000001, 0xffffff85, 0xffffffe0,
  0x00000000, 0xffffff83, 0xffffff08, 0xfffffc20,
  0xffffff81, 0xffffff05, 0xfffff062, 0xfffff080,
  0xffffff02, 0xfffff041, 0xffffc2f9, 0xfffff060,
  0xfffff020, 0xffffc27b, 0xffffc27c, 0xfffff040,
  0xffffc1fd, 0xffffc1fd, 0xffffc1ff, 0xfff00080,
  0xffffc17e, 0xffffc17f, 0xffc18179, 0xfff00060,
  0xffffc0ff, 0xffc1017b, 0xffc180fc, 0xfff00040,
  0xffc0817d, 0xffc100fd, 0xffc1807f, 0x999999c0,
  0xffc080fe, 0xffc1007f, 0x0000001b, 0x55555580,
  0xffc0807f, 0xcccccce7, 0x55555581, 0x00000080,
  0x999999b3, 0x0000002b, 0x80000179, 0x00000060,
  0xaaaaaad5, 0x0000017b, 0x800000fc, 0x00000040,
  0x8000017d, 0x000000fd, 0x8000007f, 0x00000020,
  0x800000fe, 0x0000007f, 0x80000002, 0x00000000,
  0x8000007f, 0x00000001, 0x7fffff85, 0xaaaaaae0,
  0x80000000, 0xffffff83, 0xaaaaab00, 0x666666a0,
  0x7fffff81, 0x00000055, 0x00000066, 0x00100020,
  0x555555aa, 0x33333399, 0x003e8002, 0x00100000,
  0x666666cc, 0x003f0001, 0x003e7f85, 0x000fffe0,
  0x003f8000, 0x003eff83, 0x003e7f08, 0x000fffc0,
  0x003f7f81, 0x003eff05, 0x003e7e8b, 0x00001020,
  0x003f7f02, 0x003efe87, 0x00003e82, 0x00001000,
  0x003f7e83, 0x00003f01, 0x00003e05, 0x00000fe0,
  0x00003f80, 0x00003e83, 0x00003d88, 0x00000fc0,
  0x00003f01, 0x00003e05, 0x00003d0b, 0x00000420,
  0x00003e82, 0x00003d87, 0x00000fa2, 0x00000080,
  0x00003e03, 0x00000fc1, 0x00000179, 0x00000060,
  0x00000fe0, 0x0000017b, 0x000000fc, 0x00000040,
  0x0000017a, 0x000000fb, 0x00000022, 0x00000020,
  0x000000fc, 0x0000007e, 0x00000002, 0x0000001d,
  0x0000007e, 0x00000001, 0xffffffe2, 0x0000001a,
  0x00000000, 0xffffff84, 0xffffffc2, 0xffffffc0,
  0xffffff82, 0xffffff07, 0xfffffc02, 0xfffffea9,
  0xffffff04, 0xfffff061, 0xfffff062, 0xfffffea6,
  0xfffff040, 0xffffc2f8, 0xfffff042, 0xfffffea3,
  0xffffc27a, 0xffffc27b, 0xfffff022, 0xfffe8029,
  0xffffc1fc, 0xffffc1fe, 0xfff00062, 0xfffe8026,
  0xffffc17e, 0xffc18178, 0xfff00042, 0xfffe8023,
  0xffc1017a, 0xffc180fb, 0xfff00022, 0x66666687,
  0xffc100fc, 0xffc1807e, 0x999999a2, 0x00000021,
  0xffc1007e, 0x0000001a, 0x55555562, 0x80000029,
  0xcccccce6, 0x55555580, 0x00000062, 0x80000026,
  0x0000002a, 0x80000178, 0x00000042, 0x80000023,
  0x0000017a, 0x800000fb, 0x00000022, 0x80000020,
  0x000000fc, 0x8000007e, 0x00000002, 0x8000001d,
  0x0000007e, 0x80000001, 0xffffffe2, 0x00000022,
  0x00000000, 0x7fffff84, 0xaaaaaac2, 0x999999bc,
  0xffffff82, 0xaaaaaaff, 0x66666682, 0x00018020,
  0x00000054, 0x00000065, 0x00100002, 0x0001801d,
  0x33333398, 0x003e8001, 0x000fffe2, 0x0001801a,
  0x003f0000, 0x003e7f84, 0x000fffc2, 0x00018017,
  0x003eff82, 0x003e7f07, 0x000fffa2, 0x000001a0,
  0x003eff04, 0x003e7e8a, 0x00001002, 0x0000019d,
  0x003efe86, 0x00003e81, 0x00000fe2, 0x0000019a,
  0x00003f00, 0x00003e04, 0x00000fc2, 0x00000197,
  0x00003e82, 0x00003d87, 0x00000fa2, 0x00000080,
  0x00003e04, 0x00003d0a, 0x00000402, 0x00000029,
  0x00003d86, 0x00000fa1, 0x00000062, 0x00000026,
  0x00000fc0, 0x00000178, 0x00000042, 0x00000023,
  0x00000177, 0x00000041, 0x00000005, 0x00000020,
  0x000000fa, 0x00000021, 0x00000002, 0x0000001e,
  0x0000007d, 0x00000001, 0xffffffff, 0x0000001c,
  0x00000000, 0xffffffe1, 0xfffffffc, 0xffffffe0,
  0xffffff83, 0xffffffc1, 0xffffffa2, 0xffffff26,
  0xffffff06, 0xfffffc01, 0xfffffe8b, 0xffffff24,
  0xfffff060, 0xfffff061, 0xfffffe88, 0xffffff22,
  0xffffc2f7, 0xfffff041, 0xfffffe85, 0xffff0026,
  0xffffc27a, 0xfffff021, 0xfffe800b, 0xffff0024,
  0xffffc1fd, 0xfff00061, 0xfffe8008, 0xffff0022,
  0xffc18177, 0xfff00041, 0xfffe8005, 0x999999ba,
  0xffc180fa, 0xfff00021, 0x66666669, 0x55555576,
  0xffc1807d, 0x999999a1, 0x00000003, 0x00000026,
  0x00000019, 0x55555561, 0x8000000b, 0x00000024,
  0x5555557f, 0x00000061, 0x80000008, 0x00000022,
  0x80000177, 0x00000041, 0x80000005, 0x00000020,
  0x800000fa, 0x00000021, 0x80000002, 0x0000001e,
  0x8000007d, 0x00000001, 0x7fffffff, 0xaaaaaacc,
  0x80000000, 0xffffffe1, 0x00000004, 0x66666688,
  0x7fffff83, 0xaaaaaac1, 0x9999999e, 0x00010020,
  0xaaaaaafe, 0x66666681, 0x00018002, 0x0001001e,
  0x00000064, 0x00100001, 0x00017fff, 0x0001001c,
  0x003e8000, 0x000fffe1, 0x00017ffc, 0x0001001a,
  0x003e7f83, 0x000fffc1, 0x00017ff9, 0x00000120,
  0x003e7f06, 0x000fffa1, 0x00000182, 0x0000011e,
  0x003e7e89, 0x00001001, 0x0000017f, 0x0000011c,
  0x00003e80, 0x00000fe1, 0x0000017c, 0x0000011a,
  0x00003e03, 0x00000fc1, 0x00000179, 0x00000060,
  0x00003d86, 0x00000fa1, 0x00000062, 0x00000026,
  0x00003d09, 0x00000401, 0x0000000b, 0x00000024,
  0x00000fa0, 0x00000061, 0x00000008, 0x00000022,
  0x00000060, 0x00000007, 0x00000004, 0x00000020,
  0x00000040, 0x00000004, 0x00000002, 0x0000001f,
  0x00000020, 0x00000001, 0x00000000, 0x0000001e,
  0x00000000, 0xfffffffe, 0xfffffffe, 0x00000000,
  0xffffffe0, 0xfffffffb, 0xffffffc2, 0xffffffa3,
  0xffffffc0, 0xffffffa1, 0xffffff08, 0xffffffa2,
  0xfffffc00, 0xfffffe8a, 0xffffff06, 0xffffffa1,
  0xfffff060, 0xfffffe87, 0xffffff04, 0xffff8023,
  0xfffff040, 0xfffffe84, 0xffff0008, 0xffff8022,
  0xfffff020, 0xfffe800a, 0xffff0006, 0xffff8021,
  0xfff00060, 0xfffe8007, 0xffff0004, 0xcccccced,
  0xfff00040, 0xfffe8004, 0x9999999c, 0xaaaaaacb,
  0xfff00020, 0x66666668, 0x55555558, 0x80000023,
  0x999999a0, 0x00000002, 0x00000008, 0x80000022,
  0x55555560, 0x8000000a, 0x00000006, 0x80000021,
  0x00000060, 0x80000007, 0x00000004, 0x80000020,
  0x00000040, 0x80000004, 0x00000002, 0x8000001f,
  0x00000020, 0x80000001, 0x00000000, 0x55555576,
  0x00000000, 0x7ffffffe, 0xaaaaaaae, 0x33333354,
  0xffffffe0, 0x00000003, 0x6666666a, 0x00008020,
  0xaaaaaac0, 0x9999999d, 0x00010002, 0x0000801f,
  0x66666680, 0x00018001, 0x00010000, 0x0000801e,
  0x00100000, 0x00017ffe, 0x0000fffe, 0x0000801d,
  0x000fffe0, 0x00017ffb, 0x0000fffc, 0x000000a0,
  0x000fffc0, 0x00017ff8, 0x00000102, 0x0000009f,
  0x000fffa0, 0x00000181, 0x00000100, 0x0000009e,
  0x00001000, 0x0000017e, 0x000000fe, 0x0000009d,
  0x00000fe0, 0x0000017b, 0x000000fc, 0x00000040,
  0x00000fc0, 0x00000178, 0x00000042, 0x00000023,
  0x00000fa0, 0x00000061, 0x00000008, 0x00000022,
  0x00000400, 0x0000000a, 0x00000006, 0x00000021,
};
const unsigned kExpectedCount_NEON_mla_4S = 961;

#endif  // VIXL_SIM_MLA_4S_TRACE_AARCH64_H_
