dnl @synopsis AC_raf_FUNC_WHICH_GETSERVBYNAME_R
dnl
dnl Provides a test to determine the correct way to call
dnl getservbyname_r:
dnl
dnl  - defines HAVE_FUNC_GETSERVBYNAME_R_6 if it needs 6 arguments (e.g. linux)
dnl  - defines HAVE_FUNC_GETSERVBYNAME_R_5 if it needs 5 arguments (e.g. solaris)
dnl  - defines HAVE_FUNC_GETSERVBYNAME_R_4 if it needs 4 arguments (e.g. osf/1)
dnl
dnl An example use can be found at
dnl http://raf.org/autoconf/net_getservbyname.c
dnl
dnl Based on Caolan McNamara's gethostbyname_r macro. Based on David
dnl Arnold's autoconf suggestion in the threads faq.
dnl
dnl @category Misc
dnl @author raf <raf@raf.org>
dnl @version 2001-08-20
dnl @license GPLWithACException

AC_DEFUN([AC_raf_FUNC_WHICH_GETSERVBYNAME_R],
[
AC_CACHE_CHECK(how many arguments getservbyname_r() takes,
    ac_cv_func_which_getservbyname_r,
    [
        dnl we need to use C++ to detect missing prototypes
        AC_LANG_PUSH(C++)

        AC_TRY_COMPILE([#include <netdb.h>],
            [
                char *name;
                char *proto;
                struct servent *se, *res;
                char buffer[2048];
                int buflen = 2048;
                (void) getservbyname_r(name, proto, se, buffer, buflen, &res)
            ],
            ac_cv_func_which_getservbyname_r=six,
            [
                AC_TRY_COMPILE([#include <netdb.h>],
                    [
                        char *name;
                        char *proto;
                        struct servent *se;
                        char buffer[2048];
                        int buflen = 2048;
                        (void) getservbyname_r(name, proto, se, buffer, buflen)
                    ],
                    ac_cv_func_which_getservbyname_r=five,
                    [
                        AC_TRY_COMPILE([#include <netdb.h>],
                            [
                                char *name;
                                char *proto;
                                struct servent *se;
                                struct servent_data data;
                                (void) getservbyname_r(name, proto, se, &data);
                            ],
                            ac_cv_func_which_getservbyname_r=four,
                            ac_cv_func_which_getservbyname_r=no
                        )
                    ]
                )
            ]
        )
        AC_LANG_POP()
    ]
)

if test $ac_cv_func_which_getservbyname_r = six; then
  AC_DEFINE(HAVE_FUNC_GETSERVBYNAME_R_6)
elif test $ac_cv_func_which_getservbyname_r = five; then
  AC_DEFINE(HAVE_FUNC_GETSERVBYNAME_R_5)
elif test $ac_cv_func_which_getservbyname_r = four; then
  AC_DEFINE(HAVE_FUNC_GETSERVBYNAME_R_4)
fi

])
