# Revision history for ogma-core

## [1.7.0] - 2025-03-21

* Version bump 1.7.0 (#268).
* Import liftIO from Control.Monad.IO.Class (#215).
* Remove references to old design of Ogma from hlint files (#220).
* Bump upper version constraint on aeson, text (#225).
* Remove extraneous EOL character (#224).
* Make structured data available to cFS template (#229).
* Update Copilot struct code generator to use new function names (#231).
* Simplify Copilot struct definitions by using generics (#199).
* Update cFS backend to process a handlers file (#234).
* Update cFS backend to process a template variables file (#106).
* Remove dependency on ICAROUS from generated cFS applications (#237).
* Remove incorrect function declaration from template (#240).
* Re-structure cFS backend to avoid nested conditions (#242).
* Make structured data available to ROS template (#244).
* Make structured data available to FPrime template (#246).
* Equalize backends (#248).
* Update ROS, FPrime, standalone backends to process template vars file (#250).
* Make cFS backend accept spec as input (#252).
* Make cFS, ROS, FPrime backends generate Copilot monitor (#107).
* Standardize variable DB format across backends (#256).
* Make backends accept additional data to be passed to handlers (#219).
* Add support to read properties from CSV files (#261).
* Add support to read properties from XLSX files (#263).
* Add all auxiliary test files to distributable Cabal package (#258).
* Update to support boolean expressions in the Lustre language (#267).

## [1.6.0] - 2025-01-21

* Version bump 1.6.0 (#208).
* Replace queueSize with QUEUE_SIZE in FPP file (#186).
* Use template expansion system to generate F' monitoring component (#185).
* Use template expansion system to generate standalone Copilot monitor (#189).
* Add repository information to cabal package (#148).
* Add version bounds to all dependencies (#119).
* Add command to transform state diagrams into monitors (#194).
* Extend standalone command to use external process to parse properties (#197).
* Enable using user-provided file as format definition spec (#200).
* Add support for XML files to standalone backend (#202).
* Extend support for file, property formats across backends (#204).
* Add java runtime to Dockerfile generated by FPrime backend (#206).

## [1.5.0] - 2024-11-21

* Version bump 1.5.0 (#178).
* Fix incorrect path when using Space ROS humble-2024.10.0 (#158).
* Use template expansion system to generate cFS monitoring application (#157).
* Use template expansion system to generate ROS monitoring application (#162).
* Fix comment in generated Copilot spec (#164).
* Add missing notPreviousNot to generated spec (#168).
* Introduce new standalone command (#170).
* Correct name in documentation (#176).

## [1.4.1] - 2024-09-21

* Version bump 1.4.1 (#155).
* Remove dependency on IfElse (#150).
* Replace homepage (#147).

## [1.4.0] - 2024-05-21

* Version bump 1.4.0 (#145).
* Make ros command generate dockerfile (#136).
* Map float and double to the same types in C++ (#138).

## [1.3.0] - 2024-03-21

* Version bump 1.3.0 (#133).
* Fix missing stream name substitution (#120).
* Use generalized JSON parser for DB Spec (#122).
* Fix translation of equivalence boolean operator from SMV (#126).
* Sanitize handler names (#127).
* Use same handler name in FPrime/ROS and Copilot (#130).

## [1.2.0] - 2024-01-21

* Version bump 1.2.0 (#117).
* Generalize JSON parser (#115).

## [1.1.0] - 2023-11-21

* Version bump 1.1.0 (#112).
* Remove trailing spaces from cFS app template (#108).
* Replace all mentions of the Sample App (#105).

## [1.0.11] - 2023-09-21

* Version bump 1.0.11 (#103).
* Support MTL operators with number ranges in SMV (#101).

## [1.0.10] - 2023-07-21

* Version bump 1.0.10 (#98).
* Correct test case (#96).

## [1.0.9] - 2023-05-21

* Version bump 1.0.9 (#93).
* Allow customizing the names of the C files generated by Copilot (#80).
* Translate ZtoPre and YtoPre to Copilot (#86).

## [1.0.8] - 2023-03-21

* Version bump 1.0.8 (#81).
* Support inequality operator in SMV and CoCoSpec (#71).
* Introduce new F' (FPrime) backend (#77).
* Mark package as uncurated (#74).

## [1.0.7] - 2023-01-21
* Version bump 1.0.7 (#69).
* Introduce new ROS2 backend (#56).

## [1.0.6] - 2022-11-21

* Version bump 1.0.6 (#64).
* Update license in cabal file to OtherLicense (#62).

## [1.0.5] - 2022-09-21

* Version bump 1.0.5 (#60).
* Bump version bounds of Aeson (#55).
* Support floating point numbers in SMV expressions (#58).

## [1.0.4] - 2022-07-21

* Version bump 1.0.4 (#53).
* Address all hlint suggestions (#51).

## [1.0.3] - 2022-05-21

* Version bump 1.0.3 (#49).
* Conformance with style guide (partial) (#45).

## [1.0.2] - 2022-03-21

* Version bump 1.0.2 (#43).
* Fix compilation error in unit tests (#42).
* Remove reduntant parenthesis (#40).

## [1.0.1] - 2022-01-21

* Version bump 1.0.1 (#39).
* Align definitions consistently (#35).
* Indent ogma-core:Language.Trans.CStruct2CopilotStruct.buildCField (#36).
* Indent ogma-core:Command.Result module declaration (#37).

## [1.0.0] - 2021-11-22

* Initial release.
