/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.StringMatcher;

public class DynamicMemberReferenceInitializer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final boolean DEBUG = false;
    private static final int CLASS_INDEX = 0x40000003;
    private static final int MEMBER_NAME_INDEX = 0x40000004;
    private static final int MEMBER_TYPE_INDEX = 0x40000005;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private final StringMatcher noteFieldExceptionMatcher;
    private final StringMatcher noteMethodExceptionMatcher;
    private final InstructionSequenceMatcher knownItegerUpdaterMatcher;
    private final InstructionSequenceMatcher knownLongUpdaterMatcher;
    private final InstructionSequenceMatcher knownReferenceUpdaterMatcher;
    private final InstructionSequenceMatcher unknownIntegerUpdaterMatcher;
    private final InstructionSequenceMatcher unknownLongUpdaterMatcher;
    private final InstructionSequenceMatcher unknownReferenceUpdaterMatcher;
    private final MyDynamicMemberFinder dynamicMemberFinder = new MyDynamicMemberFinder();
    private final MemberFinder memberFinder = new MemberFinder(true);
    private final MemberFinder declaredMemberFinder = new MemberFinder(false);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private Clazz referencedClass;

    public DynamicMemberReferenceInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, StringMatcher stringMatcher, StringMatcher stringMatcher2) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.notePrinter = warningPrinter;
        this.noteFieldExceptionMatcher = stringMatcher;
        this.noteMethodExceptionMatcher = stringMatcher2;
        InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder(classPool, classPool2);
        Instruction[] instructionArray = instructionSequenceBuilder.ldc_(0x40000003).ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicIntegerFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;").instructions();
        Instruction[] instructionArray2 = instructionSequenceBuilder.ldc_(0x40000003).ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicLongFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;").instructions();
        Instruction[] instructionArray3 = instructionSequenceBuilder.ldc_(0x40000003).ldc_(0x40000005).ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicReferenceFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;").instructions();
        Instruction[] instructionArray4 = instructionSequenceBuilder.ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicIntegerFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;").instructions();
        Instruction[] instructionArray5 = instructionSequenceBuilder.ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicLongFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;").instructions();
        Instruction[] instructionArray6 = instructionSequenceBuilder.ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicReferenceFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;").instructions();
        Constant[] constantArray = instructionSequenceBuilder.constants();
        this.knownItegerUpdaterMatcher = new InstructionSequenceMatcher(constantArray, instructionArray);
        this.knownLongUpdaterMatcher = new InstructionSequenceMatcher(constantArray, instructionArray2);
        this.knownReferenceUpdaterMatcher = new InstructionSequenceMatcher(constantArray, instructionArray3);
        this.unknownIntegerUpdaterMatcher = new InstructionSequenceMatcher(constantArray, instructionArray4);
        this.unknownLongUpdaterMatcher = new InstructionSequenceMatcher(constantArray, instructionArray5);
        this.unknownReferenceUpdaterMatcher = new InstructionSequenceMatcher(constantArray, instructionArray6);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        instruction.accept(clazz, method, codeAttribute, n, this.dynamicMemberFinder);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.knownItegerUpdaterMatcher, this.unknownIntegerUpdaterMatcher, true, false, false, "I");
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.knownLongUpdaterMatcher, this.unknownLongUpdaterMatcher, true, false, false, "J");
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.knownReferenceUpdaterMatcher, this.unknownReferenceUpdaterMatcher, true, false, false, null);
    }

    private void matchGetMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction, InstructionSequenceMatcher instructionSequenceMatcher, InstructionSequenceMatcher instructionSequenceMatcher2, boolean bl, boolean bl2, boolean bl3, String string) {
        int n2;
        if (instructionSequenceMatcher != null) {
            instruction.accept(clazz, method, codeAttribute, n, instructionSequenceMatcher);
            if (instructionSequenceMatcher.isMatching()) {
                n2 = instructionSequenceMatcher.matchedInstructionOffset(instructionSequenceMatcher.instructionCount() - 2);
                int n3 = instructionSequenceMatcher.matchedConstantIndex(0x40000003);
                clazz.constantPoolEntryAccept(n3, this);
                if (this.referencedClass != null) {
                    int n4 = instructionSequenceMatcher.matchedConstantIndex(0x40000005);
                    if (n4 > 0) {
                        string = ClassUtil.internalTypeFromClassName(clazz.getClassName(n4));
                    }
                    int n5 = instructionSequenceMatcher.matchedConstantIndex(0x40000004);
                    String string2 = clazz.getStringString(n5);
                    this.initializeDynamicMemberReference(clazz, n2, this.referencedClass, string2, string, bl, bl2, bl3);
                }
                instructionSequenceMatcher2.reset();
            }
        }
        instruction.accept(clazz, method, codeAttribute, n, instructionSequenceMatcher2);
        if (instructionSequenceMatcher2.isMatching()) {
            n2 = instructionSequenceMatcher2.matchedConstantIndex(0x40000004);
            String string3 = clazz.getStringString(n2);
            this.printDynamicMemberAccessNote(clazz, string3, string, bl, bl2, bl3);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencedClass = ClassUtil.isInternalArrayType(classConstant.getName(clazz)) ? null : classConstant.referencedClass;
    }

    private void initializeDynamicMemberReference(Clazz clazz, int n, Clazz clazz2, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        MemberFinder memberFinder = bl3 ? this.declaredMemberFinder : this.memberFinder;
        Member member = memberFinder.findMember(clazz2, string, string2, bl);
        if (member != null) {
            if (!bl3) {
                clazz2 = memberFinder.correspondingClass();
            }
            int n2 = new ConstantPoolEditor((ProgramClass)clazz).addStringConstant(string, clazz2, member);
            this.codeAttributeEditor.replaceInstruction(n, new ConstantInstruction(18, n2));
        }
    }

    private void printDynamicConstructorAccessNote(Clazz clazz, Clazz clazz2, String string, boolean bl) {
        if (this.notePrinter != null && this.notePrinter.accepts(clazz.getName()) && (this.noteMethodExceptionMatcher == null || !this.noteMethodExceptionMatcher.matches("<init>"))) {
            this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " retrieves a " + (bl ? "declared " : "") + "constructor '" + "<init>" + '(' + ClassUtil.externalMethodArguments(string) + ')' + "' dynamically");
            AllMethodVisitor allMethodVisitor = new AllMethodVisitor(new MemberNameFilter("<init>", (MemberVisitor)new MemberDescriptorFilter(string, (MemberVisitor)this)));
            if (clazz2 != null) {
                clazz2.hierarchyAccept(true, !bl, false, false, allMethodVisitor);
            } else {
                this.programClassPool.classesAcceptAlphabetically(allMethodVisitor);
                this.libraryClassPool.classesAcceptAlphabetically(allMethodVisitor);
            }
        }
    }

    private void printDynamicMemberAccessNote(Clazz clazz, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (this.notePrinter != null && this.notePrinter.accepts(clazz.getName())) {
            StringMatcher stringMatcher;
            StringMatcher stringMatcher2 = stringMatcher = bl ? this.noteFieldExceptionMatcher : this.noteMethodExceptionMatcher;
            if (stringMatcher == null || !stringMatcher.matches(string)) {
                String string3 = string;
                if (!bl) {
                    string3 = string3 + '(' + ClassUtil.externalMethodArguments(string2) + ')';
                }
                this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " accesses a " + (bl3 ? "declared " : "") + (bl ? "field" : (bl2 ? "constructor" : "method")) + " '" + string3 + "' dynamically");
                ClassVisitor classVisitor = bl ? (string2 == null ? new AllFieldVisitor(new MemberNameFilter(string, (MemberVisitor)this)) : new AllFieldVisitor(new MemberNameFilter(string, (MemberVisitor)new MemberDescriptorFilter(string2, (MemberVisitor)this)))) : new AllMethodVisitor(new MemberNameFilter(string, (MemberVisitor)new MemberDescriptorFilter(string2, (MemberVisitor)this)));
                this.programClassPool.classesAcceptAlphabetically(classVisitor);
                this.libraryClassPool.classesAcceptAlphabetically(classVisitor);
            }
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.notePrinter.accepts(programClass.getName())) {
            System.out.println("      Maybe this is program field '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + "; }'");
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.notePrinter.accepts(programClass.getName())) {
            System.out.println("      Maybe this is program method '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + "; }'");
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.notePrinter.accepts(libraryClass.getName())) {
            System.out.println("      Maybe this is library field '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass)) + "; }'");
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.notePrinter.accepts(libraryClass.getName())) {
            System.out.println("      Maybe this is library method '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), 0, libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass)) + "; }'");
        }
    }

    private class MyDynamicMemberFinder
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor {
        private static final int LABEL_START = 0;
        private static final int LABEL_LOAD_MEMBER_NAME = 1;
        private static final int LABEL_LOAD_CLASS_ARRAY_SIZE = 2;
        private static final int LABEL_CREATE_CLASS_ARRAY = 3;
        private static final int LABEL_DUP_CLASS_ARRAY = 4;
        private static final int LABEL_LOAD_PARAMETER_INDEX = 5;
        private static final int LABEL_LOAD_PARAMETER_TYPE = 6;
        private static final int LABEL_STORE_PARAMETER = 7;
        private static final int LABEL_GET_MEMBER = 8;
        private int label;
        private int instructionOffset;
        private int memberNameInstructionOffset;
        private Clazz referencedClass;
        private String memberName;
        private int parameterCount;
        private int parameterIndex;
        private StringBuffer parameterTypes = new StringBuffer();

        private MyDynamicMemberFinder() {
        }

        public void reset() {
            this.label = 0;
            this.referencedClass = null;
            this.memberName = null;
            this.parameterTypes.setLength(0);
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            this.reset();
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            int n2 = this.label | simpleInstruction.canonicalOpcode() << 8;
            switch (n2) {
                case 768: 
                case 769: 
                case 771: 
                case 772: 
                case 774: 
                case 775: 
                case 776: {
                    this.reset();
                    this.parameterCount = simpleInstruction.constant;
                    this.label = 3;
                    break;
                }
                case 770: {
                    this.parameterCount = simpleInstruction.constant;
                    this.label = 3;
                    break;
                }
                case 258: {
                    this.parameterCount = 0;
                    this.label = 8;
                    break;
                }
                case 22788: {
                    this.label = 5;
                    break;
                }
                case 773: {
                    if (this.parameterIndex == simpleInstruction.constant) {
                        this.label = 6;
                        break;
                    }
                    this.reset();
                    this.parameterCount = simpleInstruction.constant;
                    this.label = 3;
                    break;
                }
                case 21255: {
                    this.label = ++this.parameterIndex < this.parameterCount ? 4 : 8;
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.canonicalOpcode()) {
                case 18: {
                    this.instructionOffset = n;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    break;
                }
                case -78: 
                case -74: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    break;
                }
                case -67: {
                    if (this.label == 3) {
                        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                        break;
                    }
                    this.reset();
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
            this.reset();
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            switch (this.label) {
                case 0: {
                    this.referencedClass = classConstant.referencedClass;
                    this.label = 1;
                    break;
                }
                case 3: {
                    if (classConstant.getName(clazz).equals("java/lang/Class")) {
                        this.parameterIndex = 0;
                        this.label = this.parameterCount > 0 ? 4 : 8;
                        break;
                    }
                    this.referencedClass = classConstant.referencedClass;
                    this.label = 1;
                    break;
                }
                case 6: {
                    String string = ClassUtil.internalTypeFromClassType(classConstant.getName(clazz));
                    this.parameterTypes.append(string);
                    this.label = 7;
                    break;
                }
                default: {
                    this.referencedClass = classConstant.referencedClass;
                    this.label = 1;
                }
            }
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            switch (this.label) {
                case 1: {
                    break;
                }
                default: {
                    this.referencedClass = null;
                }
            }
            this.memberNameInstructionOffset = this.instructionOffset;
            this.memberName = stringConstant.getString(clazz);
            this.label = 2;
        }

        @Override
        public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
            switch (this.label) {
                case 6: {
                    String string = fieldrefConstant.getClassName(clazz);
                    String string2 = fieldrefConstant.getName(clazz);
                    String string3 = fieldrefConstant.getType(clazz);
                    if (string.startsWith("java/lang/") && string2.equals("TYPE") && string3.equals("Ljava/lang/Class;")) {
                        char c = ClassUtil.internalPrimitiveTypeFromNumericClassName(string);
                        this.parameterTypes.append(c);
                        this.label = 7;
                        break;
                    }
                    this.reset();
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }

        @Override
        public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
            String string = methodrefConstant.getClassName(clazz);
            if (string.equals("java/lang/Class")) {
                String string2 = methodrefConstant.getName(clazz);
                String string3 = methodrefConstant.getType(clazz);
                if (this.label == 2 && string3.equals("(Ljava/lang/String;)Ljava/lang/reflect/Field;") && this.memberName != null) {
                    if (string2.equals("getField")) {
                        this.resolveMemberString(clazz, true, false, false);
                    } else if (string2.equals("getDeclaredField")) {
                        this.resolveMemberString(clazz, true, false, true);
                    } else {
                        this.reset();
                    }
                } else if (this.label == 8 && string3.equals("([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;")) {
                    if (string2.equals("getConstructor")) {
                        this.resolveMemberString(clazz, false, true, false);
                    } else if (string2.equals("getDeclaredConstructor")) {
                        this.resolveMemberString(clazz, false, true, true);
                    } else {
                        this.reset();
                    }
                } else if (this.label == 8 && string3.equals("(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;") && this.memberName != null) {
                    if (string2.equals("getMethod")) {
                        this.resolveMemberString(clazz, false, false, false);
                    } else if (string2.equals("getDeclaredMethod")) {
                        this.resolveMemberString(clazz, false, false, true);
                    } else {
                        this.reset();
                    }
                } else {
                    this.reset();
                }
            } else {
                this.reset();
            }
        }

        private void resolveMemberString(Clazz clazz, boolean bl, boolean bl2, boolean bl3) {
            String string;
            String string2 = string = bl ? null : '(' + this.parameterTypes.toString() + ')' + "L***;";
            if (this.referencedClass != null) {
                if (bl2) {
                    DynamicMemberReferenceInitializer.this.printDynamicConstructorAccessNote(clazz, this.referencedClass, string, bl3);
                } else {
                    DynamicMemberReferenceInitializer.this.initializeDynamicMemberReference(clazz, this.memberNameInstructionOffset, this.referencedClass, this.memberName, string, bl, bl2, bl3);
                }
            } else {
                DynamicMemberReferenceInitializer.this.printDynamicMemberAccessNote(clazz, bl2 ? "<init>" : this.memberName, string, bl, bl2, bl3);
            }
        }
    }
}

