# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

$(eval $(call gb_AllLangHelp_AllLangHelp,shared))

$(eval $(call gb_AllLangHelp_set_treefile,shared,helpcontent2/source/auxiliary/shared,helpcontent2/source/text))

$(eval $(call gb_AllLangHelp_use_modules,shared,\
	scalc \
	schart \
	sdraw \
	simpress \
	smath \
	swriter \
))

$(eval $(call gb_AllLangHelp_add_localized_files,shared,helpcontent2/source/auxiliary,\
	default.css \
	highcontrast1.css \
	highcontrast2.css \
	highcontrastblack.css \
	highcontrastwhite.css \
))

$(eval $(call gb_AllLangHelp_add_helpdir_file,shared,err.html,helpcontent2/source/text/shared/05/err_html))

$(eval $(call gb_AllLangHelp_add_helpfiles,shared,\
    helpcontent2/source/text/shared/00/00000001 \
    helpcontent2/source/text/shared/00/00000002 \
    helpcontent2/source/text/shared/00/00000003 \
    helpcontent2/source/text/shared/00/00000004 \
    helpcontent2/source/text/shared/00/00000005 \
    helpcontent2/source/text/shared/00/00000007 \
    helpcontent2/source/text/shared/00/00000010 \
    helpcontent2/source/text/shared/00/00000011 \
    helpcontent2/source/text/shared/00/00000020 \
    helpcontent2/source/text/shared/00/00000021 \
    helpcontent2/source/text/shared/00/00000099 \
    helpcontent2/source/text/shared/00/00000200 \
    helpcontent2/source/text/shared/00/00000206 \
    helpcontent2/source/text/shared/00/00000207 \
    helpcontent2/source/text/shared/00/00000208 \
    helpcontent2/source/text/shared/00/00000215 \
    helpcontent2/source/text/shared/00/00000401 \
    helpcontent2/source/text/shared/00/edit_menu \
    helpcontent2/source/text/shared/00/00000403 \
    helpcontent2/source/text/shared/00/00000404 \
    helpcontent2/source/text/shared/00/00000406 \
    helpcontent2/source/text/shared/00/00000407 \
    helpcontent2/source/text/shared/00/00000408 \
    helpcontent2/source/text/shared/00/00000409 \
    helpcontent2/source/text/shared/00/00000450 \
    helpcontent2/source/text/shared/00/00040500 \
    helpcontent2/source/text/shared/00/00040501 \
    helpcontent2/source/text/shared/00/00040502 \
    helpcontent2/source/text/shared/00/00040503 \
    helpcontent2/source/text/shared/00/01000000 \
    helpcontent2/source/text/shared/00/01010000 \
    helpcontent2/source/text/shared/00/01020000 \
    helpcontent2/source/text/shared/00/01050000 \
    helpcontent2/source/text/shared/00/icon_alt \
    helpcontent2/source/text/shared/01/01010000 \
    helpcontent2/source/text/shared/01/01010001 \
    helpcontent2/source/text/shared/01/01010200 \
    helpcontent2/source/text/shared/01/01010201 \
    helpcontent2/source/text/shared/01/01010202 \
    helpcontent2/source/text/shared/01/01010203 \
    helpcontent2/source/text/shared/01/01010300 \
    helpcontent2/source/text/shared/01/01010301 \
    helpcontent2/source/text/shared/01/01010302 \
    helpcontent2/source/text/shared/01/01010303 \
    helpcontent2/source/text/shared/01/01010304 \
    helpcontent2/source/text/shared/01/01020000 \
    helpcontent2/source/text/shared/01/OpenRemote \
    helpcontent2/source/text/shared/01/01020101 \
    helpcontent2/source/text/shared/01/01020103 \
    helpcontent2/source/text/shared/01/01050000 \
    helpcontent2/source/text/shared/01/01060000 \
    helpcontent2/source/text/shared/01/SaveAsRemote \
    helpcontent2/source/text/shared/01/01060002 \
    helpcontent2/source/text/shared/01/01070000 \
    helpcontent2/source/text/shared/01/01070001 \
    helpcontent2/source/text/shared/01/01070002 \
    helpcontent2/source/text/shared/01/01100000 \
    helpcontent2/source/text/shared/01/01100100 \
    helpcontent2/source/text/shared/01/01100200 \
    helpcontent2/source/text/shared/01/01100300 \
    helpcontent2/source/text/shared/01/01100400 \
    helpcontent2/source/text/shared/01/01100600 \
    helpcontent2/source/text/shared/01/prop_font_embed \
    helpcontent2/source/text/shared/01/01110000 \
    helpcontent2/source/text/shared/01/01110101 \
    helpcontent2/source/text/shared/01/01110300 \
    helpcontent2/source/text/shared/01/01110400 \
    helpcontent2/source/text/shared/01/01130000 \
    helpcontent2/source/text/shared/01/01140000 \
    helpcontent2/source/text/shared/01/01160000 \
    helpcontent2/source/text/shared/01/01160200 \
    helpcontent2/source/text/shared/01/01160300 \
    helpcontent2/source/text/shared/01/01170000 \
    helpcontent2/source/text/shared/01/01180000 \
    helpcontent2/source/text/shared/01/01190000 \
    helpcontent2/source/text/shared/01/01990000 \
    helpcontent2/source/text/shared/01/02010000 \
    helpcontent2/source/text/shared/01/02020000 \
    helpcontent2/source/text/shared/01/02030000 \
    helpcontent2/source/text/shared/01/02040000 \
    helpcontent2/source/text/shared/01/02050000 \
    helpcontent2/source/text/shared/01/02060000 \
    helpcontent2/source/text/shared/01/02070000 \
    helpcontent2/source/text/shared/01/02090000 \
    helpcontent2/source/text/shared/01/02100000 \
    helpcontent2/source/text/shared/01/02100001 \
    helpcontent2/source/text/shared/01/02100100 \
    helpcontent2/source/text/shared/01/02100200 \
    helpcontent2/source/text/shared/01/02100300 \
    helpcontent2/source/text/shared/01/02110000 \
    helpcontent2/source/text/shared/01/02180000 \
    helpcontent2/source/text/shared/01/02180100 \
    helpcontent2/source/text/shared/01/02200000 \
    helpcontent2/source/text/shared/01/02200100 \
    helpcontent2/source/text/shared/01/02200200 \
    helpcontent2/source/text/shared/01/02210101 \
    helpcontent2/source/text/shared/01/02220000 \
    helpcontent2/source/text/shared/01/02220100 \
    helpcontent2/source/text/shared/01/02230000 \
    helpcontent2/source/text/shared/01/02230100 \
    helpcontent2/source/text/shared/01/02230150 \
    helpcontent2/source/text/shared/01/02230200 \
    helpcontent2/source/text/shared/01/02230300 \
    helpcontent2/source/text/shared/01/02230400 \
    helpcontent2/source/text/shared/01/02230401 \
    helpcontent2/source/text/shared/01/02230402 \
    helpcontent2/source/text/shared/01/02230500 \
    helpcontent2/source/text/shared/01/02240000 \
    helpcontent2/source/text/shared/01/02250000 \
    helpcontent2/source/text/shared/01/03010000 \
    helpcontent2/source/text/shared/01/03020000 \
    helpcontent2/source/text/shared/01/03050000 \
    helpcontent2/source/text/shared/01/03060000 \
    helpcontent2/source/text/shared/01/03110000 \
    helpcontent2/source/text/shared/01/03170000 \
    helpcontent2/source/text/shared/01/03990000 \
    helpcontent2/source/text/shared/01/04050000 \
    helpcontent2/source/text/shared/01/04060000 \
    helpcontent2/source/text/shared/01/04060100 \
    helpcontent2/source/text/shared/01/04060200 \
    helpcontent2/source/text/shared/01/04100000 \
    helpcontent2/source/text/shared/01/04140000 \
    helpcontent2/source/text/shared/01/04150000 \
    helpcontent2/source/text/shared/01/04150100 \
    helpcontent2/source/text/shared/01/04160300 \
    helpcontent2/source/text/shared/01/04160500 \
    helpcontent2/source/text/shared/01/04180100 \
    helpcontent2/source/text/shared/01/04990000 \
    helpcontent2/source/text/shared/01/05010000 \
    helpcontent2/source/text/shared/01/05020000 \
    helpcontent2/source/text/shared/01/05020100 \
    helpcontent2/source/text/shared/01/05020200 \
    helpcontent2/source/text/shared/01/05020300 \
    helpcontent2/source/text/shared/01/05020301 \
    helpcontent2/source/text/shared/01/05020500 \
    helpcontent2/source/text/shared/01/05020600 \
    helpcontent2/source/text/shared/01/05020700 \
    helpcontent2/source/text/shared/01/05030000 \
    helpcontent2/source/text/shared/01/05030100 \
    helpcontent2/source/text/shared/01/05030300 \
    helpcontent2/source/text/shared/01/05030500 \
    helpcontent2/source/text/shared/01/05030700 \
    helpcontent2/source/text/shared/01/05030800 \
    helpcontent2/source/text/shared/01/05040100 \
    helpcontent2/source/text/shared/01/05040200 \
    helpcontent2/source/text/shared/01/05040300 \
    helpcontent2/source/text/shared/01/05040400 \
    helpcontent2/source/text/shared/01/05060000 \
    helpcontent2/source/text/shared/01/05070000 \
    helpcontent2/source/text/shared/01/05070100 \
    helpcontent2/source/text/shared/01/05070200 \
    helpcontent2/source/text/shared/01/05070300 \
    helpcontent2/source/text/shared/01/05070400 \
    helpcontent2/source/text/shared/01/05070410 \
    helpcontent2/source/text/shared/01/05070500 \
    helpcontent2/source/text/shared/01/05070510 \
    helpcontent2/source/text/shared/01/05070600 \
    helpcontent2/source/text/shared/01/05070610 \
    helpcontent2/source/text/shared/01/05080000 \
    helpcontent2/source/text/shared/01/05080100 \
    helpcontent2/source/text/shared/01/05080200 \
    helpcontent2/source/text/shared/01/05080300 \
    helpcontent2/source/text/shared/01/05080400 \
    helpcontent2/source/text/shared/01/05090000 \
    helpcontent2/source/text/shared/01/05100000 \
    helpcontent2/source/text/shared/01/05100100 \
    helpcontent2/source/text/shared/01/05100200 \
    helpcontent2/source/text/shared/01/05100500 \
    helpcontent2/source/text/shared/01/05100600 \
    helpcontent2/source/text/shared/01/05100700 \
    helpcontent2/source/text/shared/01/05110000 \
    helpcontent2/source/text/shared/01/05110100 \
    helpcontent2/source/text/shared/01/05110200 \
    helpcontent2/source/text/shared/01/05110300 \
    helpcontent2/source/text/shared/01/05110400 \
    helpcontent2/source/text/shared/01/05110500 \
    helpcontent2/source/text/shared/01/05110600m \
    helpcontent2/source/text/shared/01/05110700 \
    helpcontent2/source/text/shared/01/05110800 \
    helpcontent2/source/text/shared/01/05120000 \
    helpcontent2/source/text/shared/01/05120100 \
    helpcontent2/source/text/shared/01/05120200 \
    helpcontent2/source/text/shared/01/05120300 \
    helpcontent2/source/text/shared/01/05120600 \
    helpcontent2/source/text/shared/01/05140100 \
    helpcontent2/source/text/shared/01/05190000 \
    helpcontent2/source/text/shared/01/05190100 \
    helpcontent2/source/text/shared/01/05200000 \
    helpcontent2/source/text/shared/01/05200100 \
    helpcontent2/source/text/shared/01/05200200 \
    helpcontent2/source/text/shared/01/05200300 \
    helpcontent2/source/text/shared/01/05210000 \
    helpcontent2/source/text/shared/01/05210100 \
    helpcontent2/source/text/shared/01/05210200 \
    helpcontent2/source/text/shared/01/05210300 \
    helpcontent2/source/text/shared/01/05210400 \
    helpcontent2/source/text/shared/01/05210500 \
    helpcontent2/source/text/shared/01/05210600 \
    helpcontent2/source/text/shared/01/05210700 \
    helpcontent2/source/text/shared/01/05210800 \
    helpcontent2/source/text/shared/01/05220000 \
    helpcontent2/source/text/shared/01/05230000 \
    helpcontent2/source/text/shared/01/05230100 \
    helpcontent2/source/text/shared/01/05230300 \
    helpcontent2/source/text/shared/01/05230400 \
    helpcontent2/source/text/shared/01/05230500 \
    helpcontent2/source/text/shared/01/05240000 \
    helpcontent2/source/text/shared/01/05240100 \
    helpcontent2/source/text/shared/01/05240200 \
    helpcontent2/source/text/shared/01/05250000 \
    helpcontent2/source/text/shared/01/05250100 \
    helpcontent2/source/text/shared/01/05250200 \
    helpcontent2/source/text/shared/01/05250300 \
    helpcontent2/source/text/shared/01/05250400 \
    helpcontent2/source/text/shared/01/05250500 \
    helpcontent2/source/text/shared/01/05250600 \
    helpcontent2/source/text/shared/01/05260000 \
    helpcontent2/source/text/shared/01/05260100 \
    helpcontent2/source/text/shared/01/05260200 \
    helpcontent2/source/text/shared/01/05260300 \
    helpcontent2/source/text/shared/01/05260400 \
    helpcontent2/source/text/shared/01/05260500 \
    helpcontent2/source/text/shared/01/05260600 \
    helpcontent2/source/text/shared/01/05270000 \
    helpcontent2/source/text/shared/01/05280000 \
    helpcontent2/source/text/shared/01/05290000 \
    helpcontent2/source/text/shared/01/05290100 \
    helpcontent2/source/text/shared/01/05290200 \
    helpcontent2/source/text/shared/01/05290300 \
    helpcontent2/source/text/shared/01/05290400 \
    helpcontent2/source/text/shared/01/05320000 \
    helpcontent2/source/text/shared/01/05320001 \
    helpcontent2/source/text/shared/01/05320002 \
    helpcontent2/source/text/shared/01/05340100 \
    helpcontent2/source/text/shared/01/05340200 \
    helpcontent2/source/text/shared/01/05340300 \
    helpcontent2/source/text/shared/01/05340400 \
    helpcontent2/source/text/shared/01/05340402 \
    helpcontent2/source/text/shared/01/05340404 \
    helpcontent2/source/text/shared/01/05340405 \
    helpcontent2/source/text/shared/01/05340500 \
    helpcontent2/source/text/shared/01/05340600 \
    helpcontent2/source/text/shared/01/05350000 \
    helpcontent2/source/text/shared/01/05350200 \
    helpcontent2/source/text/shared/01/05350300 \
    helpcontent2/source/text/shared/01/05350400 \
    helpcontent2/source/text/shared/01/05350500 \
    helpcontent2/source/text/shared/01/05350600 \
    helpcontent2/source/text/shared/01/05360000 \
    helpcontent2/source/text/shared/01/05990000 \
    helpcontent2/source/text/shared/01/06010000 \
    helpcontent2/source/text/shared/01/06010101 \
    helpcontent2/source/text/shared/01/06010500 \
    helpcontent2/source/text/shared/01/06010600 \
    helpcontent2/source/text/shared/01/06010601 \
    helpcontent2/source/text/shared/01/06020000 \
    helpcontent2/source/text/shared/01/06030000 \
    helpcontent2/source/text/shared/01/06040000 \
    helpcontent2/source/text/shared/01/06040100 \
    helpcontent2/source/text/shared/01/06040200 \
    helpcontent2/source/text/shared/01/06040300 \
    helpcontent2/source/text/shared/01/06040400 \
    helpcontent2/source/text/shared/01/06040500 \
    helpcontent2/source/text/shared/01/06040600 \
    helpcontent2/source/text/shared/01/06040700 \
    helpcontent2/source/text/shared/01/06050000 \
    helpcontent2/source/text/shared/01/06050100 \
    helpcontent2/source/text/shared/01/06050200 \
    helpcontent2/source/text/shared/01/06050300 \
    helpcontent2/source/text/shared/01/06050400 \
    helpcontent2/source/text/shared/01/06050500 \
    helpcontent2/source/text/shared/01/06050600 \
    helpcontent2/source/text/shared/01/06130000 \
    helpcontent2/source/text/shared/01/06130001 \
    helpcontent2/source/text/shared/01/06130010 \
    helpcontent2/source/text/shared/01/06130020 \
    helpcontent2/source/text/shared/01/06130030 \
    helpcontent2/source/text/shared/01/06130100 \
    helpcontent2/source/text/shared/01/06130200 \
    helpcontent2/source/text/shared/01/06130300 \
    helpcontent2/source/text/shared/01/06130500 \
    helpcontent2/source/text/shared/01/06140000 \
    helpcontent2/source/text/shared/01/06140100 \
    helpcontent2/source/text/shared/01/06140101 \
    helpcontent2/source/text/shared/01/06140102 \
    helpcontent2/source/text/shared/01/06140200 \
    helpcontent2/source/text/shared/01/06140300 \
    helpcontent2/source/text/shared/01/06140400 \
    helpcontent2/source/text/shared/01/06140402 \
    helpcontent2/source/text/shared/01/06140500 \
    helpcontent2/source/text/shared/01/06150000 \
    helpcontent2/source/text/shared/01/06150100 \
    helpcontent2/source/text/shared/01/06150110 \
    helpcontent2/source/text/shared/01/06150120 \
    helpcontent2/source/text/shared/01/06150200 \
    helpcontent2/source/text/shared/01/06150210 \
    helpcontent2/source/text/shared/01/06200000 \
    helpcontent2/source/text/shared/01/06201000 \
    helpcontent2/source/text/shared/01/06202000 \
    helpcontent2/source/text/shared/01/07010000 \
    helpcontent2/source/text/shared/01/07080000 \
    helpcontent2/source/text/shared/01/about_meta_tags \
    helpcontent2/source/text/shared/01/addsignatureline \
    helpcontent2/source/text/shared/01/AutoFormat \
    helpcontent2/source/text/shared/01/AutoRedactDoc \
    helpcontent2/source/text/shared/01/certificatepath \
    helpcontent2/source/text/shared/01/ChangeCaseRotateCase \
    helpcontent2/source/text/shared/01/ChangeCaseToLower \
    helpcontent2/source/text/shared/01/ChangeCaseToSentenceCase \
    helpcontent2/source/text/shared/01/ChangeCaseToTitleCase \
    helpcontent2/source/text/shared/01/ChangeCaseToToggleCase \
    helpcontent2/source/text/shared/01/ChangeCaseToUpper \
    helpcontent2/source/text/shared/01/classificationbar \
    helpcontent2/source/text/shared/01/classificationdialog \
    helpcontent2/source/text/shared/01/DeleteColumns \
    helpcontent2/source/text/shared/01/DeleteRows \
    helpcontent2/source/text/shared/01/DeleteTable \
    helpcontent2/source/text/shared/01/digitalsignatures \
    helpcontent2/source/text/shared/01/digitalsignaturespdf \
    helpcontent2/source/text/shared/01/DrawText \
    helpcontent2/source/text/shared/01/EntireCell \
    helpcontent2/source/text/shared/01/EntireColumn \
    helpcontent2/source/text/shared/01/EntireRow \
    helpcontent2/source/text/shared/01/extensionupdate \
    helpcontent2/source/text/shared/01/fit_to_cell \
    helpcontent2/source/text/shared/01/formatting_mark \
    helpcontent2/source/text/shared/01/font_features \
    helpcontent2/source/text/shared/01/gallery \
    helpcontent2/source/text/shared/01/gallery_files \
    helpcontent2/source/text/shared/01/Grow \
    helpcontent2/source/text/shared/01/graphic_size_check \
    helpcontent2/source/text/shared/01/graphic_styles \
    helpcontent2/source/text/shared/01/grid_and_helplines \
    helpcontent2/source/text/shared/01/guides \
    helpcontent2/source/text/shared/01/image_compression \
    helpcontent2/source/text/shared/01/image_external_tool \
    helpcontent2/source/text/shared/01/insert_chart \
    helpcontent2/source/text/shared/01/InsertColumnsAfter \
    helpcontent2/source/text/shared/01/InsertColumnsBefore \
    helpcontent2/source/text/shared/01/InsertRowsAfter \
    helpcontent2/source/text/shared/01/InsertRowsBefore \
    helpcontent2/source/text/shared/01/mediaplayer \
    helpcontent2/source/text/shared/01/menu_edit_find \
    helpcontent2/source/text/shared/01/menu_view_sidebar \
    helpcontent2/source/text/shared/01/minimal_column_width \
    helpcontent2/source/text/shared/01/minimal_row_height \
    helpcontent2/source/text/shared/01/moviesound \
    helpcontent2/source/text/shared/01/nav_rename \
    helpcontent2/source/text/shared/01/notebook_bar \
    helpcontent2/source/text/shared/01/OutlineFont \
    helpcontent2/source/text/shared/01/Overline \
    helpcontent2/source/text/shared/01/online_update \
    helpcontent2/source/text/shared/01/online_update_dialog \
    helpcontent2/source/text/shared/01/packagemanager \
    helpcontent2/source/text/shared/01/password_dlg \
    helpcontent2/source/text/shared/01/password_main \
    helpcontent2/source/text/shared/01/pastespecialmenu \
    helpcontent2/source/text/shared/01/pasteunformatted \
    helpcontent2/source/text/shared/01/pastenestedtable \
    helpcontent2/source/text/shared/01/pasterowabove \
    helpcontent2/source/text/shared/01/pastecolumnleft \
    helpcontent2/source/text/shared/01/profile_safe_mode \
    helpcontent2/source/text/shared/01/Protect \
    helpcontent2/source/text/shared/01/qrcode \
    helpcontent2/source/text/shared/01/quickcolorselector \
    helpcontent2/source/text/shared/01/RedactDoc \
    helpcontent2/source/text/shared/01/ref_epub_export \
    helpcontent2/source/text/shared/01/ref_pdf_export \
    helpcontent2/source/text/shared/01/ref_pdf_export_digital_signature \
    helpcontent2/source/text/shared/01/ref_pdf_export_general \
    helpcontent2/source/text/shared/01/ref_pdf_export_initial_view \
    helpcontent2/source/text/shared/01/ref_pdf_export_links \
    helpcontent2/source/text/shared/01/ref_pdf_export_security \
    helpcontent2/source/text/shared/01/ref_pdf_export_user_interface \
    helpcontent2/source/text/shared/01/ref_pdf_export_universal_accessibility \
    helpcontent2/source/text/shared/01/ref_pdf_send_as \
    helpcontent2/source/text/shared/01/replace_image \
    helpcontent2/source/text/shared/01/save_graphic \
    helpcontent2/source/text/shared/01/scrollbars \
    helpcontent2/source/text/shared/01/securitywarning \
    helpcontent2/source/text/shared/01/selectcertificate \
    helpcontent2/source/text/shared/01/SelectTable \
    helpcontent2/source/text/shared/01/SetOptimalColumnWidth \
    helpcontent2/source/text/shared/01/SetOptimalRowHeight \
    helpcontent2/source/text/shared/01/search_commands \
    helpcontent2/source/text/shared/01/Shrink \
    helpcontent2/source/text/shared/01/SignaturesMenu \
    helpcontent2/source/text/shared/01/SmallCaps \
    helpcontent2/source/text/shared/01/SpacePara115 \
    helpcontent2/source/text/shared/01/SpellOnline \
    helpcontent2/source/text/shared/01/select_template_category \
    helpcontent2/source/text/shared/01/signexistingpdf \
    helpcontent2/source/text/shared/01/signsignatureline \
    helpcontent2/source/text/shared/01/StyleNewByExample \
    helpcontent2/source/text/shared/01/StyleUpdateByExample \
    helpcontent2/source/text/shared/01/TipOfTheDay \
    helpcontent2/source/text/shared/01/themescolordialog \
    helpcontent2/source/text/shared/01/themesdialog \
    helpcontent2/source/text/shared/01/timestampauth \
    helpcontent2/source/text/shared/01/view_comments \
    helpcontent2/source/text/shared/01/webhtml \
    helpcontent2/source/text/shared/01/xformsdata \
    helpcontent2/source/text/shared/01/xformsdataadd \
    helpcontent2/source/text/shared/01/xformsdataaddcon \
    helpcontent2/source/text/shared/01/xformsdatachange \
    helpcontent2/source/text/shared/01/xformsdataname \
    helpcontent2/source/text/shared/01/xformsdatatab \
    helpcontent2/source/text/shared/01/ZoomMenu \
    helpcontent2/source/text/shared/01/ZoomMode \
    helpcontent2/source/text/shared/01/ZoomNext \
    helpcontent2/source/text/shared/01/ZoomObjects \
    helpcontent2/source/text/shared/01/ZoomOptimal \
    helpcontent2/source/text/shared/01/ZoomPage \
    helpcontent2/source/text/shared/01/ZoomPageWidth \
    helpcontent2/source/text/shared/01/ZoomPercent \
    helpcontent2/source/text/shared/01/ZoomPrevious \
    helpcontent2/source/text/shared/02/01110000 \
    helpcontent2/source/text/shared/02/01140000 \
    helpcontent2/source/text/shared/02/01170000 \
    helpcontent2/source/text/shared/02/01170001 \
    helpcontent2/source/text/shared/02/01170002 \
    helpcontent2/source/text/shared/02/01170003 \
    helpcontent2/source/text/shared/02/01170004 \
    helpcontent2/source/text/shared/02/01170100 \
    helpcontent2/source/text/shared/02/01170101 \
    helpcontent2/source/text/shared/02/01170102 \
    helpcontent2/source/text/shared/02/01170103 \
    helpcontent2/source/text/shared/02/01170200 \
    helpcontent2/source/text/shared/02/01170201 \
    helpcontent2/source/text/shared/02/01170202 \
    helpcontent2/source/text/shared/02/01170203 \
    helpcontent2/source/text/shared/02/01170300 \
    helpcontent2/source/text/shared/02/01170400 \
    helpcontent2/source/text/shared/02/01170500 \
    helpcontent2/source/text/shared/02/01170600 \
    helpcontent2/source/text/shared/02/01170700 \
    helpcontent2/source/text/shared/02/01170800 \
    helpcontent2/source/text/shared/02/01170801 \
    helpcontent2/source/text/shared/02/01170802 \
    helpcontent2/source/text/shared/02/01170900 \
    helpcontent2/source/text/shared/02/01170901 \
    helpcontent2/source/text/shared/02/01170902 \
    helpcontent2/source/text/shared/02/01170903 \
    helpcontent2/source/text/shared/02/01170904 \
    helpcontent2/source/text/shared/02/01171000 \
    helpcontent2/source/text/shared/02/01171100 \
    helpcontent2/source/text/shared/02/01171200 \
    helpcontent2/source/text/shared/02/01171300 \
    helpcontent2/source/text/shared/02/01171400 \
    helpcontent2/source/text/shared/02/01220000 \
    helpcontent2/source/text/shared/02/01230000 \
    helpcontent2/source/text/shared/02/02010000 \
    helpcontent2/source/text/shared/02/02020000 \
    helpcontent2/source/text/shared/02/02030000 \
    helpcontent2/source/text/shared/02/02040000 \
    helpcontent2/source/text/shared/02/02050000 \
    helpcontent2/source/text/shared/02/02130000 \
    helpcontent2/source/text/shared/02/02140000 \
    helpcontent2/source/text/shared/02/02160000 \
    helpcontent2/source/text/shared/02/02170000 \
    helpcontent2/source/text/shared/02/03110000 \
    helpcontent2/source/text/shared/02/03120000 \
    helpcontent2/source/text/shared/02/03130000 \
    helpcontent2/source/text/shared/02/03140000 \
    helpcontent2/source/text/shared/02/03150000 \
    helpcontent2/source/text/shared/02/03200000 \
    helpcontent2/source/text/shared/02/04210000 \
    helpcontent2/source/text/shared/02/05020000 \
    helpcontent2/source/text/shared/02/05090000 \
    helpcontent2/source/text/shared/02/05110000 \
    helpcontent2/source/text/shared/02/06050000 \
    helpcontent2/source/text/shared/02/06060000 \
    helpcontent2/source/text/shared/02/06100000 \
    helpcontent2/source/text/shared/02/06110000 \
    helpcontent2/source/text/shared/02/06120000 \
    helpcontent2/source/text/shared/02/07010000 \
    helpcontent2/source/text/shared/02/07060000 \
    helpcontent2/source/text/shared/02/07070000 \
    helpcontent2/source/text/shared/02/07070100 \
    helpcontent2/source/text/shared/02/07070200 \
    helpcontent2/source/text/shared/02/07080000 \
    helpcontent2/source/text/shared/02/07090000 \
    helpcontent2/source/text/shared/02/08010000 \
    helpcontent2/source/text/shared/02/08020000 \
    helpcontent2/source/text/shared/02/09070000 \
    helpcontent2/source/text/shared/02/09070100 \
    helpcontent2/source/text/shared/02/09070200 \
    helpcontent2/source/text/shared/02/09070300 \
    helpcontent2/source/text/shared/02/09070400 \
    helpcontent2/source/text/shared/02/10010000 \
    helpcontent2/source/text/shared/02/10020000 \
    helpcontent2/source/text/shared/02/10030000 \
    helpcontent2/source/text/shared/02/10040000 \
    helpcontent2/source/text/shared/02/10100000 \
    helpcontent2/source/text/shared/02/12000000 \
    helpcontent2/source/text/shared/02/12010000 \
    helpcontent2/source/text/shared/02/12020000 \
    helpcontent2/source/text/shared/02/12030000 \
    helpcontent2/source/text/shared/02/12040000 \
    helpcontent2/source/text/shared/02/12050000 \
    helpcontent2/source/text/shared/02/12070000 \
    helpcontent2/source/text/shared/02/12070100 \
    helpcontent2/source/text/shared/02/12070200 \
    helpcontent2/source/text/shared/02/12070300 \
    helpcontent2/source/text/shared/02/12080000 \
    helpcontent2/source/text/shared/02/12090000 \
    helpcontent2/source/text/shared/02/12090100 \
    helpcontent2/source/text/shared/02/12090101 \
    helpcontent2/source/text/shared/02/12100000 \
    helpcontent2/source/text/shared/02/12100100 \
    helpcontent2/source/text/shared/02/12100200 \
    helpcontent2/source/text/shared/02/12110000 \
    helpcontent2/source/text/shared/02/12120000 \
    helpcontent2/source/text/shared/02/12130000 \
    helpcontent2/source/text/shared/02/12140000 \
    helpcontent2/source/text/shared/02/13010000 \
    helpcontent2/source/text/shared/02/13020000 \
    helpcontent2/source/text/shared/02/14010000 \
    helpcontent2/source/text/shared/02/14020000 \
    helpcontent2/source/text/shared/02/14020100 \
    helpcontent2/source/text/shared/02/14020200 \
    helpcontent2/source/text/shared/02/14030000 \
    helpcontent2/source/text/shared/02/14040000 \
    helpcontent2/source/text/shared/02/14050000 \
    helpcontent2/source/text/shared/02/14060000 \
    helpcontent2/source/text/shared/02/14070000 \
    helpcontent2/source/text/shared/02/18010000 \
    helpcontent2/source/text/shared/02/18030000 \
    helpcontent2/source/text/shared/02/19090000 \
    helpcontent2/source/text/shared/02/20020000 \
    helpcontent2/source/text/shared/02/20030000 \
    helpcontent2/source/text/shared/02/20040000 \
    helpcontent2/source/text/shared/02/20050000 \
    helpcontent2/source/text/shared/02/20060000 \
    helpcontent2/source/text/shared/02/20090000 \
    helpcontent2/source/text/shared/02/20100000 \
    helpcontent2/source/text/shared/02/24010000 \
    helpcontent2/source/text/shared/02/24020000 \
    helpcontent2/source/text/shared/02/24030000 \
    helpcontent2/source/text/shared/02/24040000 \
    helpcontent2/source/text/shared/02/24050000 \
    helpcontent2/source/text/shared/02/24060000 \
    helpcontent2/source/text/shared/02/24070000 \
    helpcontent2/source/text/shared/02/24080000 \
    helpcontent2/source/text/shared/02/24090000 \
    helpcontent2/source/text/shared/02/24100000 \
    helpcontent2/source/text/shared/02/basicshapes \
    helpcontent2/source/text/shared/02/blockarrows \
    helpcontent2/source/text/shared/02/callouts \
    helpcontent2/source/text/shared/02/colortoolbar \
    helpcontent2/source/text/shared/02/eliminate_points \
    helpcontent2/source/text/shared/02/flowcharts \
    helpcontent2/source/text/shared/02/fontwork \
    helpcontent2/source/text/shared/02/gridtofront \
    helpcontent2/source/text/shared/02/limit \
    helpcontent2/source/text/shared/02/namedialog \
    helpcontent2/source/text/shared/02/paintbrush \
    helpcontent2/source/text/shared/02/querypropdlg \
    helpcontent2/source/text/shared/02/rotate_left \
    helpcontent2/source/text/shared/02/rotate_right \
    helpcontent2/source/text/shared/02/rotate_180 \
    helpcontent2/source/text/shared/02/stars \
    helpcontent2/source/text/shared/02/symbolshapes \
    helpcontent2/source/text/shared/04/01010000 \
    helpcontent2/source/text/shared/04/01020000 \
    helpcontent2/source/text/shared/05/00000001 \
    helpcontent2/source/text/shared/05/00000002 \
    helpcontent2/source/text/shared/05/00000100 \
    helpcontent2/source/text/shared/05/00000110 \
    helpcontent2/source/text/shared/05/00000120 \
    helpcontent2/source/text/shared/05/00000130 \
    helpcontent2/source/text/shared/05/00000140 \
    helpcontent2/source/text/shared/05/00000150 \
    helpcontent2/source/text/shared/05/00000160 \
    helpcontent2/source/text/shared/05/new_help \
    helpcontent2/source/text/shared/05/err_html \
    helpcontent2/source/text/shared/06/youtubevideos \
    helpcontent2/source/text/shared/06/filter_screenshots \
    helpcontent2/source/text/shared/06/svx_screenshots \
    helpcontent2/source/text/shared/06/optionen_screenshots \
    helpcontent2/source/text/shared/06/shared_cui_screenshots \
    helpcontent2/source/text/shared/06/sc_screenshots \
    helpcontent2/source/text/shared/06/sd_screenshots \
    helpcontent2/source/text/shared/06/simpress_screenshots \
    helpcontent2/source/text/shared/06/sw_screenshots \
    helpcontent2/source/text/shared/07/09000000 \
    helpcontent2/source/text/shared/autokorr/01000000 \
    helpcontent2/source/text/shared/autokorr/02000000 \
    helpcontent2/source/text/shared/autokorr/03000000 \
    helpcontent2/source/text/shared/autokorr/04000000 \
    helpcontent2/source/text/shared/autokorr/05000000 \
    helpcontent2/source/text/shared/autokorr/06000000 \
    helpcontent2/source/text/shared/autokorr/07000000 \
    helpcontent2/source/text/shared/autokorr/08000000 \
    helpcontent2/source/text/shared/autokorr/09000000 \
    helpcontent2/source/text/shared/autokorr/10000000 \
    helpcontent2/source/text/shared/autokorr/12000000 \
    helpcontent2/source/text/shared/autokorr/13000000 \
    helpcontent2/source/text/shared/autopi/01000000 \
    helpcontent2/source/text/shared/autopi/01010000 \
    helpcontent2/source/text/shared/autopi/01010100 \
    helpcontent2/source/text/shared/autopi/01010200 \
    helpcontent2/source/text/shared/autopi/01010300 \
    helpcontent2/source/text/shared/autopi/01010400 \
    helpcontent2/source/text/shared/autopi/01010500 \
    helpcontent2/source/text/shared/autopi/01010600 \
    helpcontent2/source/text/shared/autopi/01020000 \
    helpcontent2/source/text/shared/autopi/01020100 \
    helpcontent2/source/text/shared/autopi/01020200 \
    helpcontent2/source/text/shared/autopi/01020300 \
    helpcontent2/source/text/shared/autopi/01020400 \
    helpcontent2/source/text/shared/autopi/01020500 \
    helpcontent2/source/text/shared/autopi/01040000 \
    helpcontent2/source/text/shared/autopi/01040100 \
    helpcontent2/source/text/shared/autopi/01040200 \
    helpcontent2/source/text/shared/autopi/01040300 \
    helpcontent2/source/text/shared/autopi/01040400 \
    helpcontent2/source/text/shared/autopi/01040500 \
    helpcontent2/source/text/shared/autopi/01040600 \
    helpcontent2/source/text/shared/autopi/01090000 \
    helpcontent2/source/text/shared/autopi/01090100 \
    helpcontent2/source/text/shared/autopi/01090200 \
    helpcontent2/source/text/shared/autopi/01090210 \
    helpcontent2/source/text/shared/autopi/01090220 \
    helpcontent2/source/text/shared/autopi/01090300 \
    helpcontent2/source/text/shared/autopi/01090400 \
    helpcontent2/source/text/shared/autopi/01090500 \
    helpcontent2/source/text/shared/autopi/01090600 \
    helpcontent2/source/text/shared/autopi/01100000 \
    helpcontent2/source/text/shared/autopi/01100100 \
    helpcontent2/source/text/shared/autopi/01100150 \
    helpcontent2/source/text/shared/autopi/01100200 \
    helpcontent2/source/text/shared/autopi/01100300 \
    helpcontent2/source/text/shared/autopi/01100400 \
    helpcontent2/source/text/shared/autopi/01100500 \
    helpcontent2/source/text/shared/autopi/01120000 \
    helpcontent2/source/text/shared/autopi/01120100 \
    helpcontent2/source/text/shared/autopi/01120200 \
    helpcontent2/source/text/shared/autopi/01120300 \
    helpcontent2/source/text/shared/autopi/01120400 \
    helpcontent2/source/text/shared/autopi/01120500 \
    helpcontent2/source/text/shared/autopi/01130000 \
    helpcontent2/source/text/shared/autopi/01130100 \
    helpcontent2/source/text/shared/autopi/01130200 \
    helpcontent2/source/text/shared/autopi/01150000 \
    helpcontent2/source/text/shared/autopi/01170000 \
    helpcontent2/source/text/shared/autopi/01170200 \
    helpcontent2/source/text/shared/autopi/01170300 \
    helpcontent2/source/text/shared/autopi/01170400 \
    helpcontent2/source/text/shared/autopi/01170500 \
    helpcontent2/source/text/shared/fontwork_toolbar \
    helpcontent2/source/text/shared/help/browserhelp \
    helpcontent2/source/text/shared/guide/aaa_start \
    helpcontent2/source/text/shared/guide/accessibility \
    helpcontent2/source/text/shared/guide/active_help_on_off \
    helpcontent2/source/text/shared/guide/activex \
    helpcontent2/source/text/shared/guide/assistive \
    helpcontent2/source/text/shared/guide/autocorr_url \
    helpcontent2/source/text/shared/guide/auto_redact \
    helpcontent2/source/text/shared/guide/autohide \
    helpcontent2/source/text/shared/guide/background \
    helpcontent2/source/text/shared/guide/border_paragraph \
    helpcontent2/source/text/shared/guide/border_table \
    helpcontent2/source/text/shared/guide/builtin_help \
    helpcontent2/source/text/shared/guide/breaking_lines \
    helpcontent2/source/text/shared/guide/change_title \
    helpcontent2/source/text/shared/guide/chart_axis \
    helpcontent2/source/text/shared/guide/chart_barformat \
    helpcontent2/source/text/shared/guide/chart_insert \
    helpcontent2/source/text/shared/guide/chart_legend \
    helpcontent2/source/text/shared/guide/chart_title \
    helpcontent2/source/text/shared/guide/classification \
    helpcontent2/source/text/shared/guide/cmis-remote-files \
    helpcontent2/source/text/shared/guide/cmis-remote-files-setup \
    helpcontent2/source/text/shared/guide/collab \
    helpcontent2/source/text/shared/guide/configure_overview \
    helpcontent2/source/text/shared/guide/convertfilters \
    helpcontent2/source/text/shared/guide/contextmenu \
    helpcontent2/source/text/shared/guide/copy_drawfunctions \
    helpcontent2/source/text/shared/guide/copytable2application \
    helpcontent2/source/text/shared/guide/copytext2application \
    helpcontent2/source/text/shared/guide/csv_params \
    helpcontent2/source/text/shared/guide/ctl \
    helpcontent2/source/text/shared/guide/data_addressbook \
    helpcontent2/source/text/shared/guide/data_dbase2office \
    helpcontent2/source/text/shared/guide/data_enter_sql \
    helpcontent2/source/text/shared/guide/data_forms \
    helpcontent2/source/text/shared/guide/data_im_export \
    helpcontent2/source/text/shared/guide/data_new \
    helpcontent2/source/text/shared/guide/data_queries \
    helpcontent2/source/text/shared/guide/data_register \
    helpcontent2/source/text/shared/guide/data_report \
    helpcontent2/source/text/shared/guide/data_reports \
    helpcontent2/source/text/shared/guide/data_search \
    helpcontent2/source/text/shared/guide/data_search2 \
    helpcontent2/source/text/shared/guide/data_tabledefine \
    helpcontent2/source/text/shared/guide/data_tables \
    helpcontent2/source/text/shared/guide/data_view \
    helpcontent2/source/text/shared/guide/database_main \
    helpcontent2/source/text/shared/guide/dev_tools \
    helpcontent2/source/text/shared/guide/digital_signatures \
    helpcontent2/source/text/shared/guide/digitalsign_receive \
    helpcontent2/source/text/shared/guide/digitalsign_send \
    helpcontent2/source/text/shared/guide/doc_autosave \
    helpcontent2/source/text/shared/guide/doc_open \
    helpcontent2/source/text/shared/guide/doc_save \
    helpcontent2/source/text/shared/guide/dragdrop \
    helpcontent2/source/text/shared/guide/dragdrop_beamer \
    helpcontent2/source/text/shared/guide/dragdrop_gallery \
    helpcontent2/source/text/shared/guide/dragdrop_graphic \
    helpcontent2/source/text/shared/guide/dragdrop_table \
    helpcontent2/source/text/shared/guide/edit_symbolbar \
    helpcontent2/source/text/shared/guide/email \
    helpcontent2/source/text/shared/guide/error_report \
    helpcontent2/source/text/shared/guide/export_ms \
    helpcontent2/source/text/shared/guide/fax \
    helpcontent2/source/text/shared/guide/filternavigator \
    helpcontent2/source/text/shared/guide/find_attributes \
    helpcontent2/source/text/shared/guide/flat_icons \
    helpcontent2/source/text/shared/guide/floating_toolbar \
    helpcontent2/source/text/shared/guide/fontwork \
    helpcontent2/source/text/shared/guide/formfields \
    helpcontent2/source/text/shared/guide/gallery_insert \
    helpcontent2/source/text/shared/guide/groups \
    helpcontent2/source/text/shared/guide/hyperlink_edit \
    helpcontent2/source/text/shared/guide/hyperlink_insert \
    helpcontent2/source/text/shared/guide/hyperlink_rel_abs \
    helpcontent2/source/text/shared/guide/imagemap \
    helpcontent2/source/text/shared/guide/import_ms \
    helpcontent2/source/text/shared/guide/insert_bitmap \
    helpcontent2/source/text/shared/guide/insert_graphic_drawit \
    helpcontent2/source/text/shared/guide/insert_specialchar \
    helpcontent2/source/text/shared/guide/integratinguno \
    helpcontent2/source/text/shared/guide/keyboard \
    helpcontent2/source/text/shared/guide/labels \
    helpcontent2/source/text/shared/guide/labels_database \
    helpcontent2/source/text/shared/guide/language_select \
    helpcontent2/source/text/shared/guide/line_intext \
    helpcontent2/source/text/shared/guide/lineend_define \
    helpcontent2/source/text/shared/guide/linestyle_define \
    helpcontent2/source/text/shared/guide/linestyles \
    helpcontent2/source/text/shared/guide/lotusdbasediff \
    helpcontent2/source/text/shared/guide/macro_recording \
    helpcontent2/source/text/shared/guide/main \
    helpcontent2/source/text/shared/guide/manage_templates \
    helpcontent2/source/text/shared/guide/measurement_units \
    helpcontent2/source/text/shared/guide/microsoft_terms \
    helpcontent2/source/text/shared/guide/ms_doctypes \
    helpcontent2/source/text/shared/guide/ms_import_export_limitations \
    helpcontent2/source/text/shared/guide/ms_user \
    helpcontent2/source/text/shared/guide/navigator \
    helpcontent2/source/text/shared/guide/navigator_setcursor \
    helpcontent2/source/text/shared/guide/navpane_on \
    helpcontent2/source/text/shared/guide/numbering_stop \
    helpcontent2/source/text/shared/guide/openpgp \
    helpcontent2/source/text/shared/guide/pageformat_max \
    helpcontent2/source/text/shared/guide/palette_files \
    helpcontent2/source/text/shared/guide/paintbrush \
    helpcontent2/source/text/shared/guide/pasting \
    helpcontent2/source/text/shared/guide/pdf_params \
    helpcontent2/source/text/shared/guide/print_blackwhite \
    helpcontent2/source/text/shared/guide/print_faster \
    helpcontent2/source/text/shared/guide/protection \
    helpcontent2/source/text/shared/guide/redaction \
    helpcontent2/source/text/shared/guide/redlining \
    helpcontent2/source/text/shared/guide/redlining_accept \
    helpcontent2/source/text/shared/guide/redlining_doccompare \
    helpcontent2/source/text/shared/guide/redlining_docmerge \
    helpcontent2/source/text/shared/guide/redlining_enter \
    helpcontent2/source/text/shared/guide/redlining_navigation \
    helpcontent2/source/text/shared/guide/redlining_protect \
    helpcontent2/source/text/shared/guide/redlining_versions \
    helpcontent2/source/text/shared/guide/round_corner \
    helpcontent2/source/text/shared/guide/scripting \
    helpcontent2/source/text/shared/guide/space_hyphen \
    helpcontent2/source/text/shared/guide/spadmin \
    helpcontent2/source/text/shared/guide/standard_template \
    helpcontent2/source/text/shared/guide/start_parameters \
    helpcontent2/source/text/shared/guide/startcenter \
    helpcontent2/source/text/shared/guide/tabs \
    helpcontent2/source/text/shared/guide/template_manager \
    helpcontent2/source/text/shared/guide/text_color \
    helpcontent2/source/text/shared/guide/textmode_change \
    helpcontent2/source/text/shared/guide/tipoftheday \
    helpcontent2/source/text/shared/guide/undo_formatting \
    helpcontent2/source/text/shared/guide/usingthemes \
    helpcontent2/source/text/shared/guide/version_number \
    helpcontent2/source/text/shared/guide/viewing_file_properties \
    helpcontent2/source/text/shared/guide/workfolder \
    helpcontent2/source/text/shared/guide/xforms \
    helpcontent2/source/text/shared/guide/xsltfilter \
    helpcontent2/source/text/shared/guide/xsltfilter_create \
    helpcontent2/source/text/shared/guide/xsltfilter_distribute \
    helpcontent2/source/text/shared/find_toolbar \
    helpcontent2/source/text/shared/main0108 \
    helpcontent2/source/text/shared/main0201 \
    helpcontent2/source/text/shared/main0204 \
    helpcontent2/source/text/shared/main0208 \
    helpcontent2/source/text/shared/main0212 \
    helpcontent2/source/text/shared/main0213 \
    helpcontent2/source/text/shared/main0214 \
    helpcontent2/source/text/shared/main0226 \
    helpcontent2/source/text/shared/main0227 \
    helpcontent2/source/text/shared/main0400 \
    helpcontent2/source/text/shared/main0500 \
    helpcontent2/source/text/shared/main0650 \
    helpcontent2/source/text/shared/main0800 \
    helpcontent2/source/text/shared/main_tools \
    helpcontent2/source/text/shared/mediaplay_toolbar \
    helpcontent2/source/text/shared/menu/forms \
    helpcontent2/source/text/shared/menu/comment_menu \
    helpcontent2/source/text/shared/menu/insert_form_control \
    helpcontent2/source/text/shared/menu/insert_shape \
    helpcontent2/source/text/shared/menu/PickList \
    helpcontent2/source/text/shared/menu/save_image \
    helpcontent2/source/text/shared/menu/set_image_background \
    helpcontent2/source/text/shared/menu/submenu_image \
    helpcontent2/source/text/shared/menu/submenu_lists \
    helpcontent2/source/text/shared/menu/submenu_rotateflip \
    helpcontent2/source/text/shared/menu/submenu_spacing \
    helpcontent2/source/text/shared/menu/submenu_text \
    helpcontent2/source/text/shared/menu/style_menu \
    helpcontent2/source/text/shared/need_help \
    helpcontent2/source/text/shared/optionen/01000000 \
    helpcontent2/source/text/shared/optionen/01010000 \
    helpcontent2/source/text/shared/optionen/01010100 \
    helpcontent2/source/text/shared/optionen/01010200 \
    helpcontent2/source/text/shared/optionen/01010300 \
    helpcontent2/source/text/shared/optionen/01010301 \
    helpcontent2/source/text/shared/optionen/01010400 \
    helpcontent2/source/text/shared/optionen/01010401 \
    helpcontent2/source/text/shared/optionen/01010501 \
    helpcontent2/source/text/shared/optionen/01010600 \
    helpcontent2/source/text/shared/optionen/01010700 \
    helpcontent2/source/text/shared/optionen/01010800 \
    helpcontent2/source/text/shared/optionen/01010900 \
    helpcontent2/source/text/shared/optionen/01012000 \
    helpcontent2/source/text/shared/optionen/01013000 \
    helpcontent2/source/text/shared/optionen/01020000 \
    helpcontent2/source/text/shared/optionen/01020100 \
    helpcontent2/source/text/shared/optionen/01020300 \
    helpcontent2/source/text/shared/optionen/01030000 \
    helpcontent2/source/text/shared/optionen/01030300 \
    helpcontent2/source/text/shared/optionen/securityoptionsdialog \
    helpcontent2/source/text/shared/optionen/01030500 \
    helpcontent2/source/text/shared/optionen/01040000 \
    helpcontent2/source/text/shared/optionen/01040200 \
    helpcontent2/source/text/shared/optionen/01040300 \
    helpcontent2/source/text/shared/optionen/01040400 \
    helpcontent2/source/text/shared/optionen/01040500 \
    helpcontent2/source/text/shared/optionen/01040600 \
    helpcontent2/source/text/shared/optionen/01040700 \
    helpcontent2/source/text/shared/optionen/01040800 \
    helpcontent2/source/text/shared/optionen/01040900 \
    helpcontent2/source/text/shared/optionen/01041000 \
    helpcontent2/source/text/shared/optionen/01041100 \
    helpcontent2/source/text/shared/optionen/01050000 \
    helpcontent2/source/text/shared/optionen/01050100 \
    helpcontent2/source/text/shared/optionen/01050300 \
    helpcontent2/source/text/shared/optionen/01060000 \
    helpcontent2/source/text/shared/optionen/01060100 \
    helpcontent2/source/text/shared/optionen/01060300 \
    helpcontent2/source/text/shared/optionen/01060400 \
    helpcontent2/source/text/shared/optionen/01060401 \
    helpcontent2/source/text/shared/optionen/01060500 \
    helpcontent2/source/text/shared/optionen/01060600 \
    helpcontent2/source/text/shared/optionen/01060700 \
    helpcontent2/source/text/shared/optionen/01060800 \
    helpcontent2/source/text/shared/optionen/01060900 \
    helpcontent2/source/text/shared/optionen/01061000 \
    helpcontent2/source/text/shared/optionen/01070000 \
    helpcontent2/source/text/shared/optionen/01070100 \
    helpcontent2/source/text/shared/optionen/01070300 \
    helpcontent2/source/text/shared/optionen/01070400 \
    helpcontent2/source/text/shared/optionen/01070500 \
    helpcontent2/source/text/shared/optionen/01080000 \
    helpcontent2/source/text/shared/optionen/01090000 \
    helpcontent2/source/text/shared/optionen/01090100 \
    helpcontent2/source/text/shared/optionen/01110000 \
    helpcontent2/source/text/shared/optionen/01110100 \
    helpcontent2/source/text/shared/optionen/01130100 \
    helpcontent2/source/text/shared/optionen/01130200 \
    helpcontent2/source/text/shared/optionen/01140000 \
    helpcontent2/source/text/shared/optionen/01150000 \
    helpcontent2/source/text/shared/optionen/01150100 \
    helpcontent2/source/text/shared/optionen/01150200 \
    helpcontent2/source/text/shared/optionen/01150300 \
    helpcontent2/source/text/shared/optionen/01160000 \
    helpcontent2/source/text/shared/optionen/01160100 \
    helpcontent2/source/text/shared/optionen/01160200 \
    helpcontent2/source/text/shared/optionen/01160201 \
    helpcontent2/source/text/shared/optionen/BasicIDE \
    helpcontent2/source/text/shared/optionen/detailedcalculation \
    helpcontent2/source/text/shared/optionen/experimental \
    helpcontent2/source/text/shared/optionen/java \
    helpcontent2/source/text/shared/optionen/expertconfig \
    helpcontent2/source/text/shared/optionen/javaclasspath \
    helpcontent2/source/text/shared/optionen/javaparameters \
    helpcontent2/source/text/shared/optionen/languagetools \
    helpcontent2/source/text/shared/optionen/macrosecurity \
    helpcontent2/source/text/shared/optionen/macrosecurity_sl \
    helpcontent2/source/text/shared/optionen/macrosecurity_ts \
    helpcontent2/source/text/shared/optionen/mailmerge \
    helpcontent2/source/text/shared/optionen/online_update \
    helpcontent2/source/text/shared/optionen/opencl \
    helpcontent2/source/text/shared/optionen/serverauthentication \
    helpcontent2/source/text/shared/optionen/testaccount \
    helpcontent2/source/text/shared/optionen/translatetools \
    helpcontent2/source/text/shared/optionen/viewcertificate \
    helpcontent2/source/text/shared/optionen/viewcertificate_c \
    helpcontent2/source/text/shared/optionen/viewcertificate_d \
    helpcontent2/source/text/shared/optionen/viewcertificate_g \
))

# vim: set noet sw=4 ts=4:
