import wizards.ui.UIConsts
from wizards.ui.WizardDialog import *
from wizards.fax.FaxWizardDialogResources import FaxWizardDialogResources
from wizards.fax.FaxWizardDialogConst import *

from com.sun.star.awt.FontUnderline import SINGLE

class FaxWizardDialog(WizardDialog):

    def __init__(self, xmsf):
        super(FaxWizardDialog,self).__init__(xmsf, HIDMAIN )

        #Load Resources
        self.resources = FaxWizardDialogResources(xmsf)

        #set dialog properties...
        Helper.setUnoPropertyValues(self.xDialogModel,
             ("Closeable", PropertyNames.PROPERTY_HEIGHT, "Moveable",
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX,
                "Title", PropertyNames.PROPERTY_WIDTH),
             (True, 210, True, 104, 52, 1, 1,
                self.resources.resFaxWizardDialog_title, 310))

        self.fontDescriptor1 = \
            uno.createUnoStruct('com.sun.star.awt.FontDescriptor')
        self.fontDescriptor2 = \
            uno.createUnoStruct('com.sun.star.awt.FontDescriptor')
        self.fontDescriptor4 = \
            uno.createUnoStruct('com.sun.star.awt.FontDescriptor')
        self.fontDescriptor5 = \
            uno.createUnoStruct('com.sun.star.awt.FontDescriptor')
        #Set member- FontDescriptors...
        self.fontDescriptor1.Weight = 150
        self.fontDescriptor1.Underline = SINGLE
        self.fontDescriptor2.Weight = 100
        self.fontDescriptor4.Weight = 100
        self.fontDescriptor5.Weight = 150

    '''
    build components
    '''
    def buildStep1(self):
        self.optBusinessFax = self.insertRadioButton("optBusinessFax",
            OPTBUSINESSFAX_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTBUSINESSFAX_HID, self.resources.resoptBusinessFax_value,
                97, 28, 1, 1, 184), self)
        self.lstBusinessStyle = self.insertListBox("lstBusinessStyle",
            LSTBUSINESSSTYLE_ACTION_PERFORMED, LSTBUSINESSSTYLE_ITEM_CHANGED,
            ("Dropdown", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, LSTBUSINESSSTYLE_HID, 180, 40, 1, 3, 74), self)
        self.optPrivateFax = self.insertRadioButton("optPrivateFax",
            OPTPRIVATEFAX_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTPRIVATEFAX_HID, self.resources.resoptPrivateFax_value,
                97, 81, 1, 2, 184), self)
        self.lstPrivateStyle = self.insertListBox("lstPrivateStyle",
            LSTPRIVATESTYLE_ACTION_PERFORMED,
            LSTPRIVATESTYLE_ITEM_CHANGED,
            ("Dropdown", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, LSTPRIVATESTYLE_HID, 180, 95, 1,
                4, 74), self)
        self.insertLabel("lblBusinessStyle",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblBusinessStyle_value,
                110, 42, 1, 32, 60))

        self.insertLabel("lblTitle1",
            ("FontDescriptor", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor5, 16, self.resources.reslblTitle1_value,
                True, 91, 8, 1, 37, 212))
        self.insertLabel("lblPrivateStyle",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblPrivateStyle_value, 110, 95, 1, 50, 60))
        self.insertLabel("lblIntroduction",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (39, self.resources.reslblIntroduction_value, True, 104, 145, 1, 55, 199))
        self.ImageControl3 = self.insertInfoImage(92, 145, 1)
    def buildStep2(self):
        self.chkUseLogo = self.insertCheckBox("chkUseLogo",
            CHKUSELOGO_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKUSELOGO_HID, self.resources.reschkUseLogo_value, 97, 28,
                0, 2, 5, 212), self)
        self.chkUseDate = self.insertCheckBox("chkUseDate",
            CHKUSEDATE_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKUSEDATE_HID, self.resources.reschkUseDate_value, 97, 43,
                0, 2, 6, 212), self)
        self.chkUseCommunicationType = self.insertCheckBox(
            "chkUseCommunicationType",
            CHKUSECOMMUNICATIONTYPE_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKUSECOMMUNICATIONTYPE_HID,
                self.resources.reschkUseCommunicationType_value, 97, 57,
                0, 2, 7, 100), self)
        self.lstCommunicationType = self.insertComboBox(
            "lstCommunicationType",
            LSTCOMMUNICATIONTYPE_ACTION_PERFORMED,
            LSTCOMMUNICATIONTYPE_ITEM_CHANGED,
            LSTCOMMUNICATIONTYPE_TEXT_CHANGED,
            ("Dropdown", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
                (True, 12, LSTCOMMUNICATIONTYPE_HID, 105, 68, 2,
                    8, 174), self)
        self.chkUseSubject = self.insertCheckBox("chkUseSubject",
            CHKUSESUBJECT_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKUSESUBJECT_HID, self.resources.reschkUseSubject_value,
                97, 87, 0, 2, 9, 212), self)
        self.chkUseSalutation = self.insertCheckBox("chkUseSalutation",
            CHKUSESALUTATION_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKUSESALUTATION_HID,
                self.resources.reschkUseSalutation_value, 97, 102,
                0, 2, 10, 100), self)
        self.lstSalutation = self.insertComboBox("lstSalutation",
            LSTSALUTATION_ACTION_PERFORMED,
            LSTSALUTATION_ITEM_CHANGED,
            LSTSALUTATION_TEXT_CHANGED,
            ("Dropdown", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, LSTSALUTATION_HID, 105, 113, 2,
                11, 174), self)
        self.chkUseGreeting = self.insertCheckBox("chkUseGreeting",
            CHKUSEGREETING_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKUSEGREETING_HID,
                self.resources.reschkUseGreeting_value, 97, 132,
                0, 2, 12, 100), self)
        self.lstGreeting = self.insertComboBox("lstGreeting",
            LSTGREETING_ACTION_PERFORMED,
            LSTGREETING_ITEM_CHANGED,
            LSTGREETING_TEXT_CHANGED,
            ("Dropdown", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, LSTGREETING_HID, 105, 143, 2, 13, 174), self)
        self.chkUseFooter = self.insertCheckBox("chkUseFooter",
            CHKUSEFOOTER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKUSEFOOTER_HID,
                self.resources.reschkUseFooter_value, 97, 163,
                0, 2, 14, 212), self)
        self.insertLabel("lblTitle3",
            ("FontDescriptor", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor5, 16, self.resources.reslblTitle3_value,
                True, 91, 8, 2, 59, 212))

    def buildStep3(self):
        self.optSenderPlaceholder = self.insertRadioButton(
            "optSenderPlaceholder",
            OPTSENDERPLACEHOLDER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTSENDERPLACEHOLDER_HID,
                self.resources.resoptSenderPlaceholder_value,
                104, 42, 3, 15, 149), self)
        self.optSenderDefine = self.insertRadioButton("optSenderDefine",
            OPTSENDERDEFINE_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTSENDERDEFINE_HID, self.resources.resoptSenderDefine_value,
                104, 54, 3, 16, 149), self)
        self.txtSenderName = self.insertTextField("txtSenderName",
            TXTSENDERNAME_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, TXTSENDERNAME_HID, 182, 67, 3, 17, 119), self)
        self.txtSenderStreet = self.insertTextField("txtSenderStreet",
            TXTSENDERSTREET_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, TXTSENDERSTREET_HID, 182, 81, 3, 18, 119), self)
        self.txtSenderPostCode = self.insertTextField("txtSenderPostCode",
            TXTSENDERPOSTCODE_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, TXTSENDERPOSTCODE_HID, 182, 95, 3, 19, 25), self)
        self.txtSenderState = self.insertTextField("txtSenderState",
            TXTSENDERSTATE_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, TXTSENDERSTATE_HID, 211, 95, 3, 20, 21), self)
        self.txtSenderCity = self.insertTextField("txtSenderCity",
            TXTSENDERCITY_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, TXTSENDERCITY_HID, 236, 95, 3, 21, 65), self)
        self.txtSenderFax = self.insertTextField("txtSenderFax",
            TXTSENDERFAX_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, TXTSENDERFAX_HID, 182, 109, 3, 22, 119), self)
        self.optReceiverPlaceholder = self.insertRadioButton(
            "optReceiverPlaceholder",
            OPTRECEIVERPLACEHOLDER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTRECEIVERPLACEHOLDER_HID,
                self.resources.resoptReceiverPlaceholder_value,
                104, 148, 3, 23, 200), self)
        self.optReceiverDatabase = self.insertRadioButton(
            "optReceiverDatabase",
            OPTRECEIVERDATABASE_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTRECEIVERDATABASE_HID,
                self.resources.resoptReceiverDatabase_value, 104, 160, 3,
                24, 200), self)
        self.insertLabel("lblSenderAddress",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblSenderAddress_value, 97, 28, 3, 46, 136))
        self.insertFixedLine("FixedLine2", (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (5, 90, 126, 3, 51, 212))
        self.insertLabel("lblSenderName",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblSenderName_value, 113, 69, 3, 52, 68))
        self.insertLabel("lblSenderStreet",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblSenderStreet_value, 113, 82, 3, 53, 68))
        self.insertLabel("lblPostCodeCity",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblPostCodeCity_value, 113, 97, 3, 54, 68))
        self.insertLabel("lblTitle4",
            ("FontDescriptor",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor5, 16, self.resources.reslblTitle4_value,
                 True, 91, 8, 3, 60, 212))
        self.insertLabel("lblSenderFax",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.resLabel1_value, 113, 111, 3, 68, 68))
        self.insertLabel("Label2",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.resLabel2_value, 97, 137, 3, 69, 136))

    def buildStep4(self):
        self.txtFooter = self.insertTextField("txtFooter",
            TXTFOOTER_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (47, TXTFOOTER_HID, True, 97, 40, 4, 25, 203), self)
        self.chkFooterNextPages = self.insertCheckBox("chkFooterNextPages",
            CHKFOOTERNEXTPAGES_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKFOOTERNEXTPAGES_HID,
                self.resources.reschkFooterNextPages_value, 97, 92,
                0, 4, 26, 202), self)
        self.chkFooterPageNumbers = self.insertCheckBox("chkFooterPageNumbers",
            CHKFOOTERPAGENUMBERS_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, CHKFOOTERPAGENUMBERS_HID,
                self.resources.reschkFooterPageNumbers_value, 97, 106,
                0, 4, 27, 201), self)
        self.insertLabel("lblFooter",
            ("FontDescriptor",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor4, 8, self.resources.reslblFooter_value,
                97, 28, 4, 33, 116))
        self.insertLabel("lblTitle5",
            ("FontDescriptor",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor5, 16, self.resources.reslblTitle5_value,
                True, 91, 8, 4, 61, 212))

    def buildStep5(self):
        self.txtTemplateName = self.insertTextField("txtTemplateName",
            TXTTEMPLATENAME_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Text",
                PropertyNames.PROPERTY_WIDTH),
            (12, TXTTEMPLATENAME_HID, 202, 56, 5, 28,
                self.resources.restxtTemplateName_value, 100), self)

        self.optCreateFax = self.insertRadioButton("optCreateFax",
            OPTCREATEFAX_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTCREATEFAX_HID, self.resources.resoptCreateFax_value,
                104, 111, 5, 30, 198), self)
        self.optMakeChanges = self.insertRadioButton("optMakeChanges",
            OPTMAKECHANGES_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, OPTMAKECHANGES_HID, self.resources.resoptMakeChanges_value,
                104, 123, 5, 31, 198), self)
        self.insertLabel("lblFinalExplanation1",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (28, self.resources.reslblFinalExplanation1_value,
                True, 97, 28, 5, 34, 205))
        self.insertLabel("lblProceed",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblProceed_value, 97, 100, 5,
                35, 204))
        self.insertLabel("lblFinalExplanation2",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (33, self.resources.reslblFinalExplanation2_value, True, 104, 145, 5,
                36, 199))
        self.insertImage("ImageControl2",
            ("Border",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_IMAGEURL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "ScaleImage",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (0, 10, UIConsts.INFOIMAGEURL, 92, 145,
                False, 5, 47, 10))
        self.insertLabel("lblTemplateName",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblTemplateName_value, 97, 58, 5,
                57, 101))

        self.insertLabel("lblTitle6",
            ("FontDescriptor",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor5, 16, self.resources.reslblTitle6_value,
                True, 91, 8, 5, 62, 212))
