/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

using System;
using unoidl.com.sun.star.lang;
using unoidl.com.sun.star.uno;
using unoidl.com.sun.star.bridge;
using unoidl.com.sun.star.frame;

class DynLoad
{

    static void Main(string[] args)
    {
        connect(args);
    }
    
/** Connect to a running office that is accepting connections.
        @return  The ServiceManager to instantiate office components. */
    static private XMultiServiceFactory connect( string[] args )
    {
        if (args.Length == 0)
            Console.WriteLine("You need to provide a file URL to the office" +
                              " program folder\n");
        System.Collections.Hashtable ht = new System.Collections.Hashtable();
        ht.Add( "SYSBINDIR", args[ 0 ] );
        XComponentContext xContext =
            uno.util.Bootstrap.defaultBootstrap_InitialComponentContext(
                 args[ 0 ] + "/uno.ini", ht.GetEnumerator() );
        
        if (xContext != null)
            Console.WriteLine("Successfully created XComponentContext\n");
        else
            Console.WriteLine("Could not create XComponentContext\n");
       
       return null;
    }
}
