# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

$(eval $(call gb_CppunitTest_CppunitTest,sc_macros_test))

$(eval $(call gb_CppunitTest_use_externals,sc_macros_test, \
    boost_headers \
    mdds_headers \
))

$(eval $(call gb_CppunitTest_add_exception_objects,sc_macros_test, \
    sc/qa/extras/macros-test \
))

$(eval $(call gb_CppunitTest_use_libraries,sc_macros_test, \
    avmedia \
    basegfx \
    comphelper \
    cppu \
    cppuhelper \
    drawinglayer \
    editeng \
    for \
    forui \
    i18nlangtag \
    msfilter \
    oox \
    sal \
    salhelper \
    sax \
    sb \
    sc \
    sfx \
    sot \
    svl \
    svt \
    svx \
    svxcore \
	test \
    subsequenttest \
    tl \
    tk \
    ucbhelper \
	unotest \
    utl \
    vbahelper \
    vcl \
    xo \
	$(gb_UWINAPI) \
))

$(eval $(call gb_CppunitTest_set_include,sc_macros_test,\
    -I$(SRCDIR)/sc/source/ui/inc \
    -I$(SRCDIR)/sc/inc \
    $$(INCLUDE) \
))

$(eval $(call gb_CppunitTest_use_api,sc_macros_test,\
    offapi \
    oovbaapi \
    udkapi \
))

$(eval $(call gb_CppunitTest_use_ure,sc_macros_test))

$(eval $(call gb_CppunitTest_use_components,sc_macros_test,\
    basic/util/sb \
    comphelper/util/comphelp \
    configmgr/source/configmgr \
    dbaccess/util/dba \
    filter/source/config/cache/filterconfig1 \
    forms/util/frm \
    framework/util/fwk \
    i18npool/util/i18npool \
    linguistic/source/lng \
    oox/util/oox \
    package/source/xstor/xstor \
    package/util/package2 \
    sax/source/expatwrap/expwrap \
    sax/source/fastparser/fastsax \
    sc/util/sc \
    sc/util/scd \
    sc/util/scfilt \
    $(if $(filter TRUE,$(DISABLE_SCRIPTING)),, \
	    sc/util/vbaobj) \
    scripting/source/basprov/basprov \
    scripting/util/scriptframe \
    scripting/source/vbaevents/vbaevents \
    scripting/source/dlgprov/dlgprov \
    sfx2/util/sfx \
    sot/util/sot \
    svl/source/fsstor/fsstorage \
    svtools/util/svt \
    svx/util/svx \
    toolkit/util/tk \
    ucb/source/core/ucb1 \
    ucb/source/ucp/file/ucpfile1 \
    ucb/source/ucp/tdoc/ucptdoc1 \
    unotools/util/utl \
    unoxml/source/rdf/unordf \
    unoxml/source/service/unoxml \
    xmloff/util/xo \
    eventattacher/source/evtatt \
    i18npool/source/search/i18nsearch \
    vbahelper/util/msforms \
))

$(eval $(call gb_CppunitTest_use_configuration,sc_macros_test))

$(eval $(call gb_CppunitTest_use_unittest_configuration,sc_macros_test))

# vim: set noet sw=4 ts=4:
