 -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

$(eval $(call gb_UnpackedTarball_UnpackedTarball,hunspell))

$(eval $(call gb_UnpackedTarball_set_tarball,hunspell,$(HUNSPELL_TARBALL)))

ifeq ($(COM),MSC)
$(eval $(call gb_UnpackedTarball_set_post_action,hunspell,\
	touch src/hunspell/config.h \
))
endif

$(eval $(call gb_UnpackedTarball_set_patchlevel,hunspell,1))

$(eval $(call gb_UnpackedTarball_add_patches,hunspell, \
	external/hunspell/0001-Revert-Remove-autotools-autogenerated-files.patch \
	external/hunspell/0001-Extend-dotless-i-and-dotted-I-rules-to-Crimean-Tatar.patch \
	external/hunspell/0001-Allow-dotted-I-in-dictionary-and-disable-bad-capital.patch \
	external/hunspell/0001-FORBIDDENWORD-precedes-BREAK.patch \
	external/hunspell/0001-Remove-forbidden-words-from-dash-suggestion-list.patch \
	external/hunspell/0001-fix-compound-handling-for-new-Hungarian-orthography.patch \
	external/hunspell/0001-fix-compound-word-part-pa.patch \
	external/hunspell/0001-add-SPELLML-support-for-run-time-dictionary-extensio.patch \
	external/hunspell/0001-Recent-Hunspell-fixes-and-improvements.patch \
	external/hunspell/0001-tdf-116586-fix-LibreOffice-crash-by-Hungarian-person.patch \
	external/hunspell/0001-Hunspell-patches-for-missing-OCONV-conversion.patch \
	external/hunspell/0001-recent-Hunspell-fixes-for-suggestion-spelling-and-an.patch \
))

# vim: set noet sw=4 ts=4:
