/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#include <svx/strings.hrc>
#include <svx/dialmgr.hxx>
#include <svx/pagenumberlistbox.hxx>
#include <editeng/numitem.hxx>
#include <vcl/builderfactory.hxx>
#include <com/sun/star/style/NumberingType.hpp>
#include <numberingtype.hrc>

PageNumberListBox::PageNumberListBox(vcl::Window* pParent)
    : ListBox( pParent, WB_BORDER | WB_DROPDOWN)
{
    for (size_t i = 0; i < SAL_N_ELEMENTS(RID_SVXSTRARY_NUMBERINGTYPE); ++i)
    {
        sal_uInt16 nData = RID_SVXSTRARY_NUMBERINGTYPE[i].second;
        switch (nData)
        {
            // String list array is also used in Writer and contains strings
            // for Bullet and Graphics, ignore those here.
            case css::style::NumberingType::CHAR_SPECIAL:
            case css::style::NumberingType::BITMAP:
            case css::style::NumberingType::BITMAP | LINK_TOKEN:
            break;
            default:
                {
                    OUString aStr = SvxResId(RID_SVXSTRARY_NUMBERINGTYPE[i].first);
                    sal_Int32 nPos = InsertEntry( aStr );
                    SetEntryData( nPos, reinterpret_cast<void*>(static_cast<sal_uLong>(nData)) );
                }
        }
    }
    SetDropDownLineCount(6);
}

VCL_BUILDER_FACTORY(PageNumberListBox);

void PageNumberListBox::SetSelection( sal_uInt16 nPos )
{
    sal_Int32 nEntryCount = GetEntryCount();
    sal_Int32 nSelPos = LISTBOX_ENTRY_NOTFOUND;

    for (sal_Int32 i = 0; i < nEntryCount; ++i )
    {
        sal_uInt16 nTmp = static_cast<sal_uInt16>(reinterpret_cast<sal_uLong>(GetEntryData(i)));

        if ( nTmp == nPos )
        {
            nSelPos = i;
            break;
        }
    }
    SelectEntryPos( ( nSelPos != LISTBOX_ENTRY_NOTFOUND ) ? nSelPos : LISTBOX_ENTRY_NOTFOUND );
}

Size PageNumberListBox::GetOptimalSize() const
{
    return Size(150, ListBox::GetOptimalSize().Height());
}

SvxPageNumberListBox::SvxPageNumberListBox(weld::ComboBoxText* pControl)
    : m_xControl(pControl)
{
    m_xControl->set_size_request(150, -1);

    for (size_t i = 0; i < SAL_N_ELEMENTS(RID_SVXSTRARY_NUMBERINGTYPE); ++i)
    {
        sal_uInt16 nData = RID_SVXSTRARY_NUMBERINGTYPE[i].second;
        switch (nData)
        {
            // String list array is also used in Writer and contains strings
            // for Bullet and Graphics, ignore those here.
            case css::style::NumberingType::CHAR_SPECIAL:
            case css::style::NumberingType::BITMAP:
            case css::style::NumberingType::BITMAP | LINK_TOKEN:
                break;
            default:
            {
                OUString aStr = SvxResId(RID_SVXSTRARY_NUMBERINGTYPE[i].first);
                m_xControl->append(OUString::number(nData), aStr);
                break;
            }
        }
    }
}

void SvxPageNumberListBox::SetSelection( sal_uInt16 nPos )
{
    int nEntryCount = m_xControl->get_count();
    int nSelPos = -1;

    for (sal_Int32 i = 0; i < nEntryCount; ++i)
    {
        sal_uInt16 nTmp = static_cast<sal_uInt16>(m_xControl->get_id(i).toInt32());

        if (nTmp == nPos)
        {
            nSelPos = i;
            break;
        }
    }
    m_xControl->set_active(nSelPos);
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
