/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_CUI_SOURCE_OPTIONS_OPTJAVA_HXX
#define INCLUDED_CUI_SOURCE_OPTIONS_OPTJAVA_HXX

#include <config_java.h>

#include <memory>
#include <vector>
#include <ucbhelper/content.hxx>
#include <vcl/button.hxx>
#include <vcl/fixed.hxx>
#include <vcl/layout.hxx>
#include <vcl/timer.hxx>
#include <vcl/idle.hxx>
#include <vcl/weld.hxx>
#include <sfx2/tabdlg.hxx>
#include <com/sun/star/ui/dialogs/XFolderPicker2.hpp>
#include <svtools/dialogclosedlistener.hxx>
#include <svtools/restartdialog.hxx>
#include <svtools/simptabl.hxx>
#include <radiobtnbox.hxx>

// forward ---------------------------------------------------------------

#if HAVE_FEATURE_JAVA
struct JavaInfo;
#else
typedef void* JavaInfo;
#endif

class   SvxJavaParameterDlg;
class   SvxJavaClassPathDlg;
class   SvxJavaListBox;
class   OfaTreeOptionsDialog;

// class SvxJavaOptionsPage ----------------------------------------------

class SvxJavaOptionsPage : public SfxTabPage
{
private:
    VclPtr<CheckBox>                   m_pJavaEnableCB;
    VclPtr<VclContainer>               m_pJavaBox;
    VclPtr<SvxJavaListBox>             m_pJavaList;
    VclPtr<FixedText>                  m_pJavaPathText;
    VclPtr<PushButton>                 m_pAddBtn;
    VclPtr<PushButton>                 m_pParameterBtn;
    VclPtr<PushButton>                 m_pClassPathBtn;
    VclPtr<PushButton>                 m_pExpertConfigBtn;

    std::unique_ptr<SvxJavaParameterDlg> m_xParamDlg;
    std::unique_ptr<SvxJavaClassPathDlg> m_xPathDlg;
    VclPtr<OfaTreeOptionsDialog>       m_pParentDlg;

#if HAVE_FEATURE_JAVA
    std::vector<std::unique_ptr<JavaInfo>> m_parJavaInfo;
    std::vector<OUString>   m_parParameters;
    OUString                m_pClassPath;
#endif
    OUString                m_sInstallText;
    OUString                m_sAccessibilityText;
    OUString                m_sAddDialogText;
    Idle                    m_aResetIdle;

    VclPtr<CheckBox>               m_pExperimentalCB;
    VclPtr<CheckBox>               m_pMacroCB;

    std::vector<std::unique_ptr<JavaInfo>>
                            m_aAddedInfos;

    rtl::Reference< ::svt::DialogClosedListener >           xDialogListener;
    css::uno::Reference< css::ui::dialogs::XFolderPicker2 > xFolderPicker;

    DECL_LINK(        EnableHdl_Impl, Button*, void);
    DECL_LINK(        CheckHdl_Impl, SvTreeListBox*, void );
    DECL_LINK(        SelectHdl_Impl, SvTreeListBox*, void);
    DECL_LINK(        AddHdl_Impl, Button*, void);
    DECL_LINK(        ParameterHdl_Impl, Button*, void);
    DECL_LINK(        ClassPathHdl_Impl, Button*, void);
    DECL_LINK(        ResetHdl_Impl, Timer *, void);

    DECL_LINK(        StartFolderPickerHdl, void *, void );
    DECL_LINK(        DialogClosedHdl, css::ui::dialogs::DialogClosedEvent*, void );

    DECL_STATIC_LINK(SvxJavaOptionsPage, ExpertConfigHdl_Impl, Button*, void);

    void                    ClearJavaInfo();
    void                    ClearJavaList();
    void                    LoadJREs();
    void                    AddJRE( JavaInfo const * _pInfo );
    void                    HandleCheckEntry( SvTreeListEntry* _pEntry );
    void                    AddFolder( const OUString& _rFolder );
    void                    RequestRestart( svtools::RestartReason eReason );

public:
    SvxJavaOptionsPage( vcl::Window* pParent, const SfxItemSet& rSet );
    virtual ~SvxJavaOptionsPage() override;
    virtual void            dispose() override;

    static VclPtr<SfxTabPage>      Create( TabPageParent pParent, const SfxItemSet* rSet );

    virtual bool            FillItemSet( SfxItemSet* rSet ) override;
    virtual void            Reset( const SfxItemSet* rSet ) override;
    virtual void            FillUserData() override;
};

// class SvxJavaParameterDlg ---------------------------------------------

class SvxJavaParameterDlg : public weld::GenericDialogController
{
private:
    std::unique_ptr<weld::Entry> m_xParameterEdit;
    std::unique_ptr<weld::Button> m_xAssignBtn;
    std::unique_ptr<weld::TreeView> m_xAssignedList;
    std::unique_ptr<weld::Button> m_xRemoveBtn;
    std::unique_ptr<weld::Button> m_xEditBtn;

    DECL_LINK(ModifyHdl_Impl, weld::Entry&, void);
    DECL_LINK(AssignHdl_Impl, weld::Button&, void);
    DECL_LINK(SelectHdl_Impl, weld::TreeView&, void);
    DECL_LINK(DblClickHdl_Impl, weld::TreeView&, void);
    DECL_LINK(RemoveHdl_Impl, weld::Button&, void);
    DECL_LINK(EditHdl_Impl, weld::Button&, void);

    void EnableRemoveButton()
    {
        m_xRemoveBtn->set_sensitive(m_xAssignedList->get_selected_index() != -1);
    }

    void EnableEditButton()
    {
        m_xEditBtn->set_sensitive(m_xAssignedList->get_selected_index() != -1);
    }

    void DisableAssignButton()
    {
        m_xAssignBtn->set_sensitive(false);
    }

    void DisableRemoveButton()
    {
        m_xRemoveBtn->set_sensitive(false);
    }

    void DisableEditButton()
    {
        m_xEditBtn->set_sensitive(false);
    }

public:
    explicit SvxJavaParameterDlg(weld::Window* pParent);
    virtual ~SvxJavaParameterDlg() override;

    virtual short run() override;

    std::vector< OUString > GetParameters() const;
    void SetParameters( std::vector< OUString > const & rParams );
    void DisableButtons();
    void EditParameter();
};

// class SvxJavaClassPathDlg ---------------------------------------------

class SvxJavaClassPathDlg : public weld::GenericDialogController
{
private:
    std::unique_ptr<weld::TreeView> m_xPathList;
    std::unique_ptr<weld::Button> m_xAddArchiveBtn;
    std::unique_ptr<weld::Button> m_xAddPathBtn;
    std::unique_ptr<weld::Button> m_xRemoveBtn;

    OUString                m_sOldPath;

    DECL_LINK(AddArchiveHdl_Impl, weld::Button&, void);
    DECL_LINK(AddPathHdl_Impl, weld::Button&, void);
    DECL_LINK(RemoveHdl_Impl, weld::Button&, void);
    DECL_LINK(SelectHdl_Impl, weld::TreeView&, void);

    bool IsPathDuplicate(const OUString& _rPath);
    void EnableRemoveButton()
    {
        m_xRemoveBtn->set_sensitive(m_xPathList->get_selected_index() != -1);
    }

public:
    explicit SvxJavaClassPathDlg(weld::Window* pParent);
    virtual ~SvxJavaClassPathDlg() override;

    const OUString&  GetOldPath() const { return m_sOldPath; }
    void             SetFocus() { m_xPathList->grab_focus(); }

    OUString                GetClassPath() const;
    void                    SetClassPath( const OUString& _rPath );
};

#endif // INCLUDED_CUI_SOURCE_OPTIONS_OPTJAVA_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
